/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.QueryFrame;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.resolver.util.AccessPattern;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.ExpressionMappingVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FrameUtil {
    private static final String RECONTEXT_STRING = "__";

    static void findQueryFrames(PlanNode node, QueryFrame parentFrame, List frames) throws QueryPlannerException {
        List childNodes = node.getChildren();
        Iterator childIter = childNodes.iterator();
        if (node.getType() == 29) {
            while (childIter.hasNext()) {
                FrameUtil.findQueryFrames((PlanNode)childIter.next(), parentFrame, frames);
            }
            return;
        }
        ArrayList bottomNodes = new ArrayList();
        while (childIter.hasNext()) {
            FrameUtil.findBottomNodes((PlanNode)childIter.next(), bottomNodes);
        }
        QueryFrame frame = new QueryFrame(parentFrame, node, bottomNodes);
        FrameUtil.setJoinFlag(frame);
        if (bottomNodes.size() > 0) {
            for (PlanNode bottomNode : bottomNodes) {
                if (bottomNode.getChildCount() <= 0) continue;
                FrameUtil.findQueryFrames(bottomNode, frame, frames);
            }
        }
        frames.add(frame);
    }

    static void findBottomNodes(PlanNode node, List foundNodes) {
        block5: {
            block6: {
                block4: {
                    if (node.getType() != 29) break block4;
                    for (PlanNode child : node.getChildren()) {
                        if (child.getType() == 29) {
                            FrameUtil.findBottomNodes(child, foundNodes);
                            continue;
                        }
                        while (child.getType() != 11) {
                            child = child.getFirstChild();
                        }
                        foundNodes.add(child);
                    }
                    break block5;
                }
                if (node.getType() != 19) break block6;
                foundNodes.add(node);
                break block5;
            }
            if (node.getChildCount() <= 0) break block5;
            List children = node.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                FrameUtil.findBottomNodes((PlanNode)iter.next(), foundNodes);
            }
        }
    }

    static void setJoinFlag(QueryFrame frame) {
        LinkedList nodes = new LinkedList();
        nodes.addAll(frame.getTopNode().getChildren());
        List bottomNodes = frame.getBottomNodes();
        while (!nodes.isEmpty()) {
            PlanNode node = (PlanNode)nodes.removeFirst();
            if (node.getType() == 7) {
                frame.setJoinNode(node);
                break;
            }
            if (bottomNodes.contains(node)) continue;
            nodes.addAll(node.getChildren());
        }
    }

    static List getOverlappingGroups(GroupSymbol groupToIgnore, Set lowerGroups, Set upperGroups) {
        ArrayList<GroupSymbol> overlapGroups = null;
        for (GroupSymbol upperGroup : upperGroups) {
            if (upperGroup.equals((Object)groupToIgnore) || !lowerGroups.contains(upperGroup)) continue;
            if (overlapGroups == null) {
                overlapGroups = new ArrayList<GroupSymbol>();
            }
            overlapGroups.add(upperGroup);
        }
        return overlapGroups;
    }

    static void convertFrame(QueryFrame frame, PlanNode startNode, GroupSymbol oldGroup, GroupSymbol newGroup, Map symbolMap, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Map parentSymbolMap;
        PlanNode topNode = frame.getTopNode();
        PlanNode current = startNode;
        PlanNode endNode = null;
        if (topNode.getType() == 19) {
            endNode = topNode;
        } else {
            for (endNode = topNode.getParent(); endNode != null && endNode.getType() != 19; endNode = endNode.getParent()) {
            }
        }
        while (current != endNode) {
            FrameUtil.convertNode(current, oldGroup, newGroup, symbolMap, metadata);
            PlanNode parent = current.getParent();
            if (parent != null && parent.getType() == 29 && parent.getFirstChild() != current) {
                return;
            }
            current = parent;
        }
        if (endNode != null && (parentSymbolMap = (Map)endNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP)) != null) {
            for (Map.Entry entry : parentSymbolMap.entrySet()) {
                Expression convertedParentValue;
                Expression parentValue = (Expression)entry.getValue();
                if (symbolMap.containsKey(parentValue)) {
                    convertedParentValue = FrameUtil.convertSingleElementSymbol((SingleElementSymbol)parentValue, symbolMap, false, metadata);
                    if (convertedParentValue instanceof ExpressionSymbol && !(convertedParentValue instanceof AggregateSymbol)) {
                        convertedParentValue = ((ExpressionSymbol)convertedParentValue).getExpression();
                    }
                    entry.setValue(convertedParentValue);
                    continue;
                }
                convertedParentValue = FrameUtil.convertExpression(parentValue, symbolMap);
                entry.setValue(convertedParentValue);
            }
        }
    }

    static boolean canConvertAccessPatterns(PlanNode sourceNode) throws QueryPlannerException {
        List accessPatterns = (List)sourceNode.getProperty((Object)NodeConstants.Info.ACCESS_PATTERNS);
        Map symbolMap = (Map)sourceNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
        if (accessPatterns != null) {
            for (AccessPattern ap : accessPatterns) {
                for (ElementSymbol symbol : ap.getUnsatisfied()) {
                    Expression mapped = FrameUtil.convertExpression((Expression)symbol, symbolMap);
                    if (!ElementCollectorVisitor.getElements((LanguageObject)mapped, true).isEmpty()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static void convertAccessPatterns(Map symbolMap, PlanNode node) throws QueryPlannerException {
        List accessPatterns = (List)node.getProperty((Object)NodeConstants.Info.ACCESS_PATTERNS);
        if (accessPatterns != null) {
            for (AccessPattern ap : accessPatterns) {
                HashSet newElements = new HashSet();
                for (ElementSymbol symbol : ap.getUnsatisfied()) {
                    Expression mapped = FrameUtil.convertExpression((Expression)symbol, symbolMap);
                    newElements.addAll(ElementCollectorVisitor.getElements((LanguageObject)mapped, true));
                }
                ap.setUnsatisfied(newElements);
                HashSet newHistory = new HashSet();
                for (ElementSymbol symbol : ap.getCurrentElements()) {
                    Expression mapped = FrameUtil.convertExpression((Expression)symbol, symbolMap);
                    newHistory.addAll(ElementCollectorVisitor.getElements((LanguageObject)mapped, true));
                }
                ap.addElementHistory(newHistory);
            }
            Collections.sort(accessPatterns);
        }
    }

    static void convertNode(PlanNode node, GroupSymbol oldGroup, GroupSymbol newGroup, Map symbolMap, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        SingleElementSymbol mappedSymbol;
        ArrayList<SingleElementSymbol> newElements;
        List elements;
        Set groups = node.getGroups();
        List refs = (List)node.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES);
        if (refs != null) {
            for (Reference ref : refs) {
                Expression expr = ref.getExpression();
                Expression convertedExpr = FrameUtil.convertExpression(expr, symbolMap);
                ref.setExpression(convertedExpr);
            }
        }
        if (groups.size() == 0 && node.getType() == 13) {
            return;
        }
        boolean hasOld = groups.contains(oldGroup);
        if (hasOld) {
            groups.remove(oldGroup);
        } else if (node.getType() == 13) {
            return;
        }
        if (newGroup != null && (node.getType() != 19 || hasOld)) {
            groups.add(newGroup);
        }
        ArrayList newElementSymbols = new ArrayList();
        int type = node.getType();
        if (type == 13) {
            Criteria crit = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
            FrameUtil.convertCriteria(crit, symbolMap);
            ElementCollectorVisitor.getElements((LanguageObject)crit, newElementSymbols);
        } else if (type == 11) {
            elements = (List)node.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
            newElements = new ArrayList<SingleElementSymbol>(elements.size());
            for (SingleElementSymbol symbol : elements) {
                mappedSymbol = FrameUtil.convertSingleElementSymbol(symbol, symbolMap, true, metadata);
                newElements.add(mappedSymbol);
                ElementCollectorVisitor.getElements((LanguageObject)mappedSymbol, newElementSymbols);
            }
            node.setProperty((Object)NodeConstants.Info.PROJECT_COLS, newElements);
        } else if (type == 7) {
            List joinCrits = (List)node.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
            if (joinCrits != null && joinCrits.size() > 0) {
                for (Criteria crit : joinCrits) {
                    FrameUtil.convertCriteria(crit, symbolMap);
                    ElementCollectorVisitor.getElements((LanguageObject)crit, newElementSymbols);
                }
            }
            FrameUtil.convertAccessPatterns(symbolMap, node);
        } else if (type == 17) {
            elements = (List)node.getProperty((Object)NodeConstants.Info.SORT_ORDER);
            newElements = new ArrayList(elements.size());
            for (SingleElementSymbol symbol : elements) {
                mappedSymbol = FrameUtil.convertSingleElementSymbol(symbol, symbolMap, true, metadata);
                newElements.add(mappedSymbol);
                ElementCollectorVisitor.getElements((LanguageObject)mappedSymbol, newElementSymbols);
            }
            node.setProperty((Object)NodeConstants.Info.SORT_ORDER, newElements);
        } else if (type == 23) {
            List groupCols = (List)node.getProperty((Object)NodeConstants.Info.GROUP_COLS);
            if (groupCols != null) {
                ArrayList<SingleElementSymbol> newGroupCols = new ArrayList<SingleElementSymbol>(groupCols.size());
                HashMap<SingleElementSymbol, SingleElementSymbol> newMappedCols = new HashMap<SingleElementSymbol, SingleElementSymbol>();
                for (SingleElementSymbol groupCol : groupCols) {
                    SingleElementSymbol mappedCol = FrameUtil.convertSingleElementSymbol(groupCol, symbolMap, false, metadata);
                    newMappedCols.put(groupCol, mappedCol);
                    newGroupCols.add(mappedCol);
                    ElementCollectorVisitor.getElements((LanguageObject)mappedCol, newElementSymbols);
                }
                node.setProperty((Object)NodeConstants.Info.GROUP_COLS, newGroupCols);
                symbolMap.putAll(newMappedCols);
            }
        } else if (type == 19 || type == 3) {
            FrameUtil.convertAccessPatterns(symbolMap, node);
        }
        if (newElementSymbols.size() > 0) {
            for (ElementSymbol elem : newElementSymbols) {
                groups.add(elem.getGroupSymbol());
            }
        }
    }

    static SingleElementSymbol convertSingleElementSymbol(SingleElementSymbol symbol, Map symbolMap, boolean shouldAlias, QueryMetadataInterface metadata) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        String alias = metadata.getShortElementName(symbol.getName());
        boolean hasAlias = false;
        if (symbol instanceof AliasSymbol) {
            symbol = ((AliasSymbol)symbol).getSymbol();
            hasAlias = true;
        }
        Object mappedSymbol = null;
        if (symbol instanceof ElementSymbol) {
            Expression mappedExpression = FrameUtil.convertExpression((Expression)symbol, symbolMap);
            mappedSymbol = mappedExpression instanceof ElementSymbol ? (SingleElementSymbol)mappedExpression : new ExpressionSymbol(alias, mappedExpression);
        } else {
            ExpressionSymbol esymbol = (ExpressionSymbol)symbol;
            esymbol.setExpression(FrameUtil.convertExpression(esymbol.getExpression(), symbolMap));
            mappedSymbol = esymbol;
        }
        if (shouldAlias && hasAlias) {
            mappedSymbol = new AliasSymbol(alias, mappedSymbol);
        }
        return mappedSymbol;
    }

    static Expression convertExpression(Expression expression, Map symbolMap) throws QueryPlannerException {
        AggregateSymbol aggSymbol;
        SingleElementSymbol replacement;
        if (expression == null || expression instanceof Constant) {
            return expression;
        }
        if (expression instanceof ElementSymbol) {
            Expression mappedSymbol = (Expression)symbolMap.get(expression);
            if (mappedSymbol != null) {
                return mappedSymbol;
            }
            return expression;
        }
        if (expression instanceof AggregateSymbol && (replacement = (SingleElementSymbol)symbolMap.get(aggSymbol = (AggregateSymbol)expression)) != null) {
            return replacement;
        }
        ExpressionMappingVisitor.mapExpressions((LanguageObject)expression, symbolMap, true);
        return expression;
    }

    static Criteria convertCriteria(Criteria criteria, Map symbolMap) throws QueryPlannerException {
        ExpressionMappingVisitor.mapExpressions(criteria, symbolMap, false);
        try {
            return QueryRewriter.rewriteCriteria(criteria, null, null, null);
        }
        catch (QueryValidatorException e) {
            throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0023", (Object)criteria));
        }
    }

    static Set getNamesFromSymbols(Collection symbols) {
        HashSet<String> names = new HashSet<String>();
        for (GroupSymbol symbol : symbols) {
            names.add(symbol.getName());
        }
        return names;
    }

    public static GroupSymbol recontextSymbol(GroupSymbol oldSymbol, Set allGroupNames) {
        String tryName;
        String oldName = oldSymbol.getName();
        int dotIndex = oldName.lastIndexOf(".");
        if (dotIndex >= 0) {
            oldName = oldName.substring(dotIndex + 1);
        }
        int recontextNumber = 1;
        int recontextIndex = oldName.lastIndexOf(RECONTEXT_STRING);
        if (recontextIndex >= 0) {
            try {
                recontextNumber = Integer.parseInt(oldName.substring(recontextIndex + RECONTEXT_STRING.length())) + 1;
                oldName = oldName.substring(0, recontextIndex);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        HashSet<String> allUpperNames = new HashSet<String>();
        Iterator iter = allGroupNames.iterator();
        while (iter.hasNext()) {
            String upperName = ((String)iter.next()).toUpperCase();
            allUpperNames.add(upperName);
        }
        String newName = null;
        while (true) {
            if (!allUpperNames.contains((tryName = oldName + RECONTEXT_STRING + recontextNumber).toUpperCase())) break;
            ++recontextNumber;
        }
        newName = tryName;
        String newDefinition = null;
        newDefinition = oldSymbol.getDefinition() == null ? oldSymbol.getName() : oldSymbol.getDefinition();
        GroupSymbol newSymbol = new GroupSymbol(newName, newDefinition);
        newSymbol.setVirtualDatabaseName(oldSymbol.getVirtualDatabaseName());
        newSymbol.setMetadataID(oldSymbol.getMetadataID());
        return newSymbol;
    }

    public static Map buildSymbolMap(GroupSymbol oldGroup, GroupSymbol newGroup, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        String newGroupName = null;
        if (newGroup != null) {
            newGroupName = newGroup.getName();
        }
        HashMap<ElementSymbol, Constant> map = new HashMap<ElementSymbol, Constant>();
        List elements = null;
        try {
            elements = ResolverUtil.resolveElementsInGroup(oldGroup, metadata);
        }
        catch (QueryComponentException err) {
            throw new MetaMatrixComponentException((Throwable)err);
        }
        for (ElementSymbol oldElementSymbol : elements) {
            Constant symbol = null;
            if (newGroup != null) {
                String newFullName = metadata.getFullElementName(newGroupName, oldElementSymbol.getShortName());
                ElementSymbol newElementSymbol = new ElementSymbol(newFullName);
                newElementSymbol.setGroupSymbol(newGroup);
                newElementSymbol.setMetadataID(oldElementSymbol.getMetadataID());
                String elementType = metadata.getElementType(newElementSymbol.getMetadataID());
                newElementSymbol.setType(DataTypeManager.getDataTypeClass((String)elementType));
                symbol = newElementSymbol;
            } else {
                symbol = new Constant(null, oldElementSymbol.getType());
            }
            map.put(oldElementSymbol, symbol);
        }
        return map;
    }

    static boolean hasSubquery(PlanNode critNode) {
        Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        Collection subCrits = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)crit);
        return subCrits.size() > 0;
    }

    static PlanNode findOriginatingNode(PlanNode root, Set groups) {
        return FrameUtil.findOriginatingNode(root, groups, false);
    }

    static PlanNode findJoinSourceNode(PlanNode root) {
        return FrameUtil.findOriginatingNode(root, root.getGroups(), true);
    }

    private static PlanNode findOriginatingNode(PlanNode root, Set groups, boolean joinSource) {
        boolean containsGroups = false;
        if (root.getType() == 31 || root.getType() == 19 || root.getType() == 7 || root.getType() == 29 || joinSource && root.getType() == 3) {
            if (groups.isEmpty()) {
                return root;
            }
            containsGroups = root.getGroups().containsAll(groups);
            if (containsGroups && (root.getType() != 7 || joinSource || root.getGroups().size() == groups.size())) {
                return root;
            }
            if (root.getType() != 7 || joinSource || !containsGroups) {
                return null;
            }
        }
        List children = root.getChildren();
        for (PlanNode child : children) {
            PlanNode found = FrameUtil.findOriginatingNode(child, groups, joinSource);
            if (found == null) continue;
            return found;
        }
        if (root.getType() == 7 && containsGroups) {
            return root;
        }
        return null;
    }

    static Set getGroups(Criteria crit) {
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)crit, true);
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        for (ElementSymbol elementID : elements) {
            groups.add(elementID.getGroupSymbol());
        }
        return groups;
    }

    static QueryFrame findQueryFrame(PlanNode node) throws QueryPlannerException {
        PlanNode currentNode = node;
        while (currentNode.getParent() != null && currentNode.getParent().getType() != 19) {
            currentNode = currentNode.getParent();
        }
        ArrayList frames = new ArrayList();
        FrameUtil.findQueryFrames(currentNode, null, frames);
        QueryFrame frame = null;
        Iterator i = frames.iterator();
        while (i.hasNext() && !(frame = (QueryFrame)i.next()).containsNode(node)) {
        }
        Assertion.isNotNull(frame);
        return frame;
    }

    static void replaceWithNullNode(PlanNode node) {
        PlanNode nullNode = NodeFactory.getNewNode((int)31);
        PlanNode source = FrameUtil.findJoinSourceNode(node);
        if (source != null) {
            nullNode.addGroups((Collection)source.getGroups());
        }
        node.getChildren().clear();
        NodeEditor.replaceNode(node, nullNode);
        nullNode.setParent(node.getParent());
    }

    static ProcessorPlan getNestedPlan(PlanNode accessNode) {
        ProcessorPlan plan = null;
        PlanNode sourceNode = accessNode.getFirstChild();
        if (sourceNode.getType() != 19) {
            sourceNode = sourceNode.getFirstChild();
        }
        if (sourceNode.getType() == 19) {
            plan = (ProcessorPlan)sourceNode.getProperty((Object)NodeConstants.Info.PROCESSOR_PLAN);
        }
        return plan;
    }

    static Command getNonQueryCommand(PlanNode node) {
        Command command;
        if (node.getChildCount() == 0) {
            return null;
        }
        PlanNode sourceNode = node.getFirstChild();
        if (sourceNode.getType() != 19) {
            if (sourceNode.getChildCount() == 0) {
                return null;
            }
            sourceNode = sourceNode.getFirstChild();
        }
        if (sourceNode.getType() == 19 && !((command = (Command)sourceNode.getProperty((Object)NodeConstants.Info.VIRTUAL_COMMAND)) instanceof QueryCommand)) {
            return command;
        }
        return null;
    }

    static boolean isProcedure(PlanNode projectNode) {
        if (projectNode.getType() == 11 && projectNode.getChildCount() > 0) {
            PlanNode accessNode = projectNode.getFirstChild();
            Command command = FrameUtil.getNonQueryCommand(accessNode);
            return command instanceof StoredProcedure;
        }
        return false;
    }
}

