/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.IntegerIDFactory;
import com.metamatrix.core.id.ObjectIDFactory;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.optimizer.CommandPlanner;
import com.metamatrix.query.optimizer.CommandTreeNode;
import com.metamatrix.query.optimizer.CommandTreeProcessor;
import com.metamatrix.query.optimizer.batch.BatchedUpdatePlanner;
import com.metamatrix.query.optimizer.batch.PreparedBatchUpdatePlanner;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.proc.ProcedurePlanner;
import com.metamatrix.query.optimizer.relate.xml.XMLPlanner;
import com.metamatrix.query.optimizer.relational.MergeTreeNodeProcessor;
import com.metamatrix.query.optimizer.relational.PlanHints;
import com.metamatrix.query.optimizer.relational.RelationalCommandConstants;
import com.metamatrix.query.optimizer.relational.RelationalPlanner;
import com.metamatrix.query.optimizer.xquery.XQueryPlanner;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.PreparedBatchUpdate;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.ReferenceCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import com.metamatrix.query.util.RelateUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class QueryOptimizer {
    private static final CommandPlanner RELATIONAL_PLANNER = new RelationalPlanner();
    private static final CommandPlanner XML_PLANNER = new com.metamatrix.query.optimizer.xml.XMLPlanner();
    private static final CommandPlanner PROCEDURE_PLANNER = new ProcedurePlanner();
    private static final CommandPlanner XQUERY_PLANNER = new XQueryPlanner();
    private static final CommandPlanner BATCHED_UPDATE_PLANNER = new BatchedUpdatePlanner();
    private static final CommandPlanner PREPARED_BATCH_UPDATE_PLANNER = new PreparedBatchUpdatePlanner();
    private static final CommandTreeProcessor MERGE_TREE_NODE_PROCESSOR = new MergeTreeNodeProcessor();
    private static final CommandPlanner XML_RELATE_PLANNER = new XMLPlanner();

    private QueryOptimizer() {
    }

    public static ProcessorPlan optimizePlan(Command command, QueryMetadataInterface metadata, IDGenerator idGenerator, CapabilitiesFinder capabilitiesFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        boolean debug = analysisRecord.recordDebug();
        if (debug) {
            analysisRecord.println("\n============================================================================");
            analysisRecord.println("USER COMMAND:\n" + command);
            analysisRecord.println("\nINITIAL COMMAND STRUCTURE:\n" + command.printCommandTree());
        }
        CommandTreeNode root = new CommandTreeNode();
        QueryOptimizer.recursiveGenerateCanonical(root, command, metadata, analysisRecord, context);
        root = MERGE_TREE_NODE_PROCESSOR.process(root, metadata);
        if (debug) {
            analysisRecord.println("\n----------------------------------------------------------------------------");
            analysisRecord.println("COMMAND TREE after merging relational nodes: \n" + root);
        }
        if (idGenerator == null) {
            idGenerator = new IDGenerator();
            idGenerator.setDefaultFactory((ObjectIDFactory)new IntegerIDFactory());
        }
        ProcessorPlan plan = QueryOptimizer.recursiveOptimize(root, idGenerator, metadata, capabilitiesFinder, analysisRecord, context);
        if (debug) {
            analysisRecord.println("\n----------------------------------------------------------------------------");
            analysisRecord.println("OPTIMIZATION COMPLETE:");
            analysisRecord.println("PLAN TREE:\n" + root);
            analysisRecord.println("PROCESSOR PLAN:\n" + plan);
            analysisRecord.println("============================================================================");
        }
        return plan;
    }

    private static void recursiveGenerateCanonical(CommandTreeNode node, Command command, QueryMetadataInterface metadata, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        boolean debug = analysisRecord.recordDebug();
        if (debug) {
            analysisRecord.println("\n----------------------------------------------------------------------------");
            analysisRecord.println("GENERATE CANONICAL: \n" + command);
        }
        QueryOptimizer.makeCanonical(node, command, metadata, analysisRecord, context);
        if (debug) {
            analysisRecord.println("\nCANONICAL PLAN: \n" + node.getCanonicalPlan());
        }
        for (Command subcommand : command.getSubCommands()) {
            CommandTreeNode child = new CommandTreeNode();
            node.addLastChild(child);
            child.setParent(node);
            QueryOptimizer.recursiveGenerateCanonical(child, subcommand, metadata, analysisRecord, context);
            if (command == null || command.getType() != 7) continue;
            List references = null;
            if (subcommand != null) {
                references = ReferenceCollectorVisitor.getReferences((LanguageObject)subcommand);
            }
            if (references == null || references.size() <= 0) continue;
            child.setReferences(references);
        }
    }

    private static ProcessorPlan recursiveOptimize(CommandTreeNode node, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        boolean debug;
        for (CommandTreeNode child : node.getChildren()) {
            QueryOptimizer.recursiveOptimize(child, idGenerator, metadata, capFinder, analysisRecord, context);
        }
        QueryMetadataInterface optMetadata = metadata;
        Map commandMetadata = node.getCommand().getTemporaryMetadata();
        if (commandMetadata != null && commandMetadata.size() > 0) {
            optMetadata = new TempMetadataAdapter(metadata, new TempMetadataStore(commandMetadata));
        }
        if (debug = analysisRecord.recordDebug()) {
            analysisRecord.println("\n----------------------------------------------------------------------------");
            analysisRecord.println("OPTIMIZE: \n" + node.getCommand());
        }
        ProcessorPlan plan = QueryOptimizer.optimize(node, idGenerator, optMetadata, capFinder, analysisRecord, context);
        node.setProcessorPlan(plan);
        return plan;
    }

    private static ProcessorPlan optimize(CommandTreeNode node, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        ProcessorPlan result = null;
        if (node.getCommandType() == 2) {
            result = RELATIONAL_PLANNER.optimize(node, idGenerator, metadata, capFinder, analysisRecord, context);
        } else if (node.getCommandType() == 3) {
            result = QueryOptimizer.getXmlPlanner(node).optimize(node, idGenerator, metadata, capFinder, analysisRecord, context);
        } else if (node.getCommandType() == 4) {
            result = PROCEDURE_PLANNER.optimize(node, idGenerator, metadata, capFinder, analysisRecord, context);
        } else if (node.getCommandType() == 5) {
            result = XQUERY_PLANNER.optimize(node, idGenerator, metadata, capFinder, analysisRecord, context);
        } else if (node.getCommandType() == 6) {
            result = BATCHED_UPDATE_PLANNER.optimize(node, idGenerator, metadata, capFinder, analysisRecord, context);
        } else if (node.getCommandType() == 8) {
            result = PREPARED_BATCH_UPDATE_PLANNER.optimize(node, idGenerator, metadata, capFinder, analysisRecord, context);
        }
        return result;
    }

    private static void makeCanonical(CommandTreeNode node, Command command, QueryMetadataInterface metadata, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        GroupSymbol group;
        Collection groups;
        node.setCommand(command);
        QueryMetadataInterface optMetadata = metadata;
        Map tempMetadata = command.getTemporaryMetadata();
        if (tempMetadata != null && !tempMetadata.isEmpty()) {
            optMetadata = new TempMetadataAdapter(metadata, new TempMetadataStore(tempMetadata));
        }
        if (node.getParent() == null && command instanceof PreparedBatchUpdate && ((PreparedBatchUpdate)command).isBatchedUpdate()) {
            node.setCommandType(8);
            CommandTreeNode child = new CommandTreeNode();
            node.addLastChild(child);
            child.setParent(node);
            QueryOptimizer.recursiveGenerateCanonical(child, command, metadata, analysisRecord, context);
            return;
        }
        int commandType = command.getType();
        if (commandType == 9) {
            node.setCommandType(6);
            BATCHED_UPDATE_PLANNER.generateCanonical(node, optMetadata, analysisRecord, context);
            return;
        }
        if (commandType == 7) {
            node.setCommandType(4);
            PROCEDURE_PLANNER.generateCanonical(node, optMetadata, analysisRecord, context);
            return;
        }
        if (commandType == 8) {
            node.setCommandType(5);
            XQUERY_PLANNER.generateCanonical(node, optMetadata, analysisRecord, context);
            return;
        }
        if (commandType == 10) {
            node.setCommandType(7);
            return;
        }
        node.setCommandType(2);
        if (commandType == 1 && (groups = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)true)).size() == 1 && optMetadata.isXMLGroup((group = (GroupSymbol)groups.iterator().next()).getMetadataID())) {
            node.setCommandType(3);
        }
        if (node.getCommandType() == 2) {
            PlanHints hints = new PlanHints();
            node.setProperty(RelationalCommandConstants.HINTS, hints);
            RELATIONAL_PLANNER.generateCanonical(node, optMetadata, analysisRecord, context);
        } else {
            QueryOptimizer.getXmlPlanner(node).generateCanonical(node, optMetadata, analysisRecord, context);
        }
    }

    private static CommandPlanner getXmlPlanner(CommandTreeNode node) {
        Command command = node.getCommand();
        if (command != null && command.getType() == 1 && RelateUtil.findRelateFunction((Select)((Query)command).getSelect()) != null) {
            return XML_RELATE_PLANNER;
        }
        return XML_PLANNER;
    }
}

