/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.CriteriaEvaluationException;
import com.metamatrix.query.eval.CriteriaEvaluator;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.Delete;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.EvaluateExpressionVisitor;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class RelationalNodeUtil {
    private RelationalNodeUtil() {
    }

    private static boolean evaluateCriteria(Criteria criteria) throws MetaMatrixComponentException {
        if (criteria == null) {
            return true;
        }
        try {
            return CriteriaEvaluator.evaluate((Criteria)criteria, (Map)Collections.EMPTY_MAP, (List)Collections.EMPTY_LIST);
        }
        catch (CriteriaEvaluationException e) {
            throw new MetaMatrixComponentException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.006.0025", (Object)criteria));
        }
    }

    static boolean shouldExecute(Command command, boolean simplifyCriteria) throws MetaMatrixComponentException {
        int cmdType = command.getType();
        Criteria criteria = null;
        switch (cmdType) {
            case 1: {
                QueryCommand queryCommand = (QueryCommand)command;
                if (queryCommand instanceof SetQuery) {
                    SetQuery union = (SetQuery)queryCommand;
                    boolean shouldExecute = false;
                    Iterator iter = union.getQueries().iterator();
                    while (iter.hasNext()) {
                        QueryCommand innerQuery = (QueryCommand)iter.next();
                        boolean shouldInner = RelationalNodeUtil.shouldExecute((Command)innerQuery, simplifyCriteria);
                        if (!shouldInner) continue;
                        shouldExecute = true;
                        break;
                    }
                    return shouldExecute;
                }
                Query query = (Query)queryCommand;
                criteria = query.getCriteria();
                if (criteria == null) {
                    return true;
                }
                if (!EvaluateExpressionVisitor.isFullyEvaluatable((LanguageObject)criteria, true)) {
                    return true;
                }
                if (!RelationalNodeUtil.evaluateCriteria(criteria)) break;
                if (simplifyCriteria) {
                    query.setCriteria(null);
                }
                return true;
            }
            case 3: {
                Update update = (Update)command;
                criteria = update.getCriteria();
                if (ElementCollectorVisitor.getElements((LanguageObject)criteria, (boolean)true).size() > 0) {
                    return true;
                }
                if (!RelationalNodeUtil.evaluateCriteria(criteria)) break;
                if (simplifyCriteria) {
                    update.setCriteria(null);
                }
                return true;
            }
            case 4: {
                Delete delete = (Delete)command;
                criteria = delete.getCriteria();
                if (ElementCollectorVisitor.getElements((LanguageObject)criteria, (boolean)true).size() > 0) {
                    return true;
                }
                if (!RelationalNodeUtil.evaluateCriteria(criteria)) break;
                if (simplifyCriteria) {
                    delete.setCriteria(null);
                }
                return true;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    static boolean isUpdate(Command command) {
        int commandType = command.getType();
        return commandType == 2 || commandType == 3 || commandType == 4;
    }
}

