/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.mapping.relational.QueryNode;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.xml.XMLPlannerEnvironment;
import com.metamatrix.query.resolver.QueryResolver;
import com.metamatrix.query.resolver.util.ResolveCriteriaVisitor;
import com.metamatrix.query.resolver.util.ResolveElementsVisitor;
import com.metamatrix.query.resolver.util.ResolveFunctionsVisitor;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import java.util.Collection;
import java.util.List;

public class QueryUtil {
    static Command parseQuery(QueryNode queryNode, XMLPlannerEnvironment planEnv) throws QueryPlannerException {
        return QueryUtil.parseQuery(queryNode.getQuery(), queryNode.getGroupName(), planEnv);
    }

    static Command parseQuery(String queryStr, String resultSet, XMLPlannerEnvironment planEnv) throws QueryPlannerException {
        Command query = null;
        try {
            query = planEnv.getQueryParser().parseCommand(queryStr);
        }
        catch (QueryParserException e) {
            throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0054", new Object[]{resultSet, queryStr}));
        }
        return query;
    }

    static Criteria parseCriteria(String criteriaString, XMLPlannerEnvironment planEnv) throws QueryPlannerException {
        try {
            return planEnv.getQueryParser().parseCriteria(criteriaString);
        }
        catch (QueryParserException e) {
            throw new QueryPlannerException((Throwable)e, e.getMessage());
        }
    }

    static void resolveQuery(Command query, XMLPlannerEnvironment planEnv) throws MetaMatrixComponentException, QueryPlannerException {
        try {
            QueryResolver.resolveCommand((Command)query, (QueryMetadataInterface)planEnv.getGlobalMetadata());
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)e, e.getMessage());
        }
    }

    static void rewriteQuery(Command query, XMLPlannerEnvironment planEnv) throws QueryPlannerException {
        try {
            QueryRewriter.rewrite(query, null, planEnv.getGlobalMetadata(), planEnv.context);
        }
        catch (QueryValidatorException e) {
            throw new QueryPlannerException((Throwable)e, e.getMessage());
        }
    }

    static Criteria resolveCriteria(String criteriaString, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Criteria crit = null;
        try {
            crit = planEnv.getQueryParser().parseCriteria(criteriaString);
            QueryUtil.resolveCriteria(crit, null, planEnv);
        }
        catch (QueryParserException e) {
            throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0055", (Object)criteriaString));
        }
        return crit;
    }

    static void resolveCriteria(Criteria criteria, Collection groups, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        try {
            ResolveElementsVisitor.resolveElements((LanguageObject)criteria, (Collection)groups, (QueryMetadataInterface)planEnv.getGlobalMetadata());
            ResolveFunctionsVisitor.resolveFunctions((LanguageObject)criteria, planEnv.getGlobalMetadata());
            ResolveCriteriaVisitor.resolveCriteria((LanguageObject)criteria);
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0056", (Object)criteria));
        }
    }

    static ElementSymbol resolveBinding(String binding, XMLPlannerEnvironment planEnv) throws QueryPlannerException, MetaMatrixComponentException {
        ElementSymbol bindingSymbol = null;
        try {
            bindingSymbol = (ElementSymbol)planEnv.getQueryParser().parseExpression(binding);
        }
        catch (QueryParserException e) {
            throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0040", (Object)binding));
        }
        try {
            ResolveElementsVisitor.resolveElements((LanguageObject)bindingSymbol, (QueryMetadataInterface)planEnv.getGlobalMetadata());
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0041", (Object)bindingSymbol));
        }
        return bindingSymbol;
    }

    static List resolveElements(GroupSymbol group, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException, QueryPlannerException {
        try {
            return ResolverUtil.resolveElementsInGroup(group, metadata);
        }
        catch (QueryResolverException e) {
            throw new QueryPlannerException((Throwable)e, e.getMessage());
        }
    }
}

