/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relate.xml;

import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.visitor.ExpressionMappingVisitor;

public class RelateWrapperFunctionVisitor
extends ExpressionMappingVisitor {
    public static final short SOURCE = 0;
    public static final short TARGET = 1;
    public static final short NONE = 2;
    private boolean hasSourceWrapper = false;
    private boolean hasTargetWrapper = false;

    public RelateWrapperFunctionVisitor() {
        super(null);
    }

    public boolean hasSourceWrapper() {
        return this.hasSourceWrapper;
    }

    public boolean hasTargetWrapper() {
        return this.hasTargetWrapper;
    }

    public Expression replaceExpression(Expression expr) {
        if (expr instanceof Function) {
            Function function = (Function)expr;
            if (function.getName().equalsIgnoreCase("relatesource")) {
                expr = function.getArg(0);
                this.hasSourceWrapper = true;
            } else if (function.getName().equalsIgnoreCase("relatetarget")) {
                expr = function.getArg(0);
                this.hasTargetWrapper = true;
            }
        }
        return expr;
    }

    public static short removeWrappers(Criteria criteria) throws QueryPlannerException {
        RelateWrapperFunctionVisitor visitor = new RelateWrapperFunctionVisitor();
        PreOrderNavigator.doVisit((LanguageObject)criteria, (LanguageVisitor)visitor);
        if (visitor.hasSourceWrapper) {
            if (visitor.hasTargetWrapper) {
                throw new QueryPlannerException(QueryExecPlugin.Util.getString("RelatePlanner.mixed_wrappers", (Object)criteria));
            }
            return 0;
        }
        if (visitor.hasTargetWrapper) {
            return 1;
        }
        return 2;
    }
}

