/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.query.mapping.xml.ResultSetInfo;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.xml.DocumentInProgress;
import com.metamatrix.query.processor.xml.PlanExecutor;
import com.metamatrix.query.processor.xml.ProcessorInstruction;
import com.metamatrix.query.processor.xml.Program;
import com.metamatrix.query.processor.xml.RelationalPlanExecutor;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.util.CommandContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class XMLProcessorEnvironment {
    public static final String STRING_RESULT = "String";
    public static final String JDOM_DOCUMENT_RESULT = "JDOM Document";
    private Collection childPlans;
    private LinkedList programStack = new LinkedList();
    private Map loadedStagingTables = Collections.synchronizedMap(new HashMap());
    private DocumentInProgress documentInProgress;
    private String xmlFormat;
    private String xmlResultsForm;
    private GroupSymbol documentGroup;
    private ProcessorDataManager dataMgr;
    private BufferManager bufferMgr;
    private CommandContext commandContext;

    protected XMLProcessorEnvironment() {
    }

    public XMLProcessorEnvironment(Program mainProgram) {
        this.pushProgram(mainProgram);
    }

    public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
        this.dataMgr = dataMgr;
        this.bufferMgr = bufferMgr;
        this.commandContext = context;
    }

    public Program getCurrentProgram() {
        if (this.programStack.size() > 0) {
            ProgramState programState = (ProgramState)this.programStack.getFirst();
            return programState.program;
        }
        return null;
    }

    public boolean isRecursiveProgramInStack() {
        Iterator stackedPrograms = this.programStack.iterator();
        ProgramState programState = (ProgramState)stackedPrograms.next();
        while (programState.recursionCount == 0 && stackedPrograms.hasNext()) {
            programState = (ProgramState)stackedPrograms.next();
        }
        return programState.recursionCount > 0;
    }

    public void incrementCurrentProgramCounter() {
        ProgramState programState = (ProgramState)this.programStack.getFirst();
        programState.programCounter++;
        while (this.programStack.size() > 1 && programState.programCounter >= programState.program.getProcessorInstructions().size()) {
            this.programStack.removeFirst();
            if (LogManager.isMessageToBeRecorded((String)"XML_PLAN", (int)6)) {
                LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"Processor Environment popped program w/ recursion count " + programState.recursionCount, "; " + this.programStack.size(), " programs left."});
            }
            programState = (ProgramState)this.programStack.getFirst();
        }
    }

    public void pushProgram(Program program) {
        this.pushProgram(program, false);
    }

    public void pushProgram(Program program, boolean isRecursive) {
        ProgramState programState = new ProgramState();
        programState.program = program;
        if (isRecursive) {
            ProgramState previousState = this.getProgramState(program);
            if (previousState != null) {
                programState.recursionCount = previousState.recursionCount + 1;
            } else {
                programState.recursionCount = 1;
            }
            LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"Pushed recursive program w/ recursion count " + programState.recursionCount});
        } else {
            LogManager.logTrace((String)"XML_PLAN", (Object[])new Object[]{"Pushed non-recursive program w/ recursion count " + programState.recursionCount});
        }
        this.programStack.addFirst(programState);
    }

    public ProcessorInstruction getCurrentInstruction() {
        ProgramState programState = (ProgramState)this.programStack.getFirst();
        if (programState != null && programState.program.getProcessorInstructions().isEmpty()) {
            this.incrementCurrentProgramCounter();
            programState = (ProgramState)this.programStack.getFirst();
        }
        if (programState == null) {
            return null;
        }
        return programState.program.getInstructionAt(programState.programCounter);
    }

    public int getProgramRecursionCount(Program program) {
        ProgramState programState = this.getProgramState(program);
        if (programState == null) {
            return 0;
        }
        return programState.recursionCount;
    }

    private ProgramState getProgramState(Program program) {
        ProgramState result = null;
        Iterator stackedPrograms = this.programStack.iterator();
        while (stackedPrograms.hasNext()) {
            ProgramState programState = (ProgramState)stackedPrograms.next();
            Program stackedProgram = programState.program;
            if (stackedProgram != program) continue;
            result = programState;
            break;
        }
        return result;
    }

    public PlanExecutor createResultExecutor(String resultSetName, ResultSetInfo info) throws MetaMatrixComponentException {
        ResultSetInfo clone = (ResultSetInfo)info.clone();
        ProcessorPlan plan = (ProcessorPlan)clone.getPlan();
        plan = (ProcessorPlan)plan.clone();
        clone.setPlan(plan);
        return new RelationalPlanExecutor(clone, this.commandContext, this.dataMgr, this.bufferMgr);
    }

    public DocumentInProgress getDocumentInProgress() {
        return this.documentInProgress;
    }

    public void setDocumentInProgress(DocumentInProgress documentInProgress) {
        this.documentInProgress = documentInProgress;
    }

    public String getXMLFormat() {
        return this.xmlFormat;
    }

    public void setXMLFormat(String xmlFormat) {
        this.xmlFormat = xmlFormat;
    }

    public String getXMLResultsForm() {
        return this.xmlResultsForm;
    }

    public void setXMLResultsForm(String xmlResultsForm) {
        this.xmlResultsForm = xmlResultsForm;
    }

    public ProcessorDataManager getDataManager() {
        return this.dataMgr;
    }

    public CommandContext getProcessorContext() {
        return this.commandContext;
    }

    public Collection getChildPlans() {
        return this.childPlans;
    }

    public void setChildPlans(Collection childPlans) {
        this.childPlans = childPlans;
    }

    public Object clone() {
        XMLProcessorEnvironment clone = new XMLProcessorEnvironment();
        this.copyIntoClone(clone);
        return clone;
    }

    protected void copyIntoClone(XMLProcessorEnvironment clone) {
        ProgramState initialProgramState = (ProgramState)this.programStack.getLast();
        ProgramState newState = new ProgramState();
        newState.program = initialProgramState.program;
        newState.programCounter = 0;
        newState.recursionCount = 0;
        clone.programStack.addFirst(newState);
        clone.setXMLFormat(this.getXMLFormat());
        clone.setXMLResultsForm(this.getXMLResultsForm());
    }

    public GroupSymbol getDocumentGroup() {
        return this.documentGroup;
    }

    public void setDocumentGroup(GroupSymbol documentGroup) {
        this.documentGroup = documentGroup;
    }

    boolean isStagingTableLoaded(String tableName) {
        return Boolean.TRUE.equals(this.loadedStagingTables.get(tableName));
    }

    void markStagingTableAsLoaded(String tableName) {
        this.loadedStagingTables.put(tableName, Boolean.TRUE);
    }

    private static class ProgramState {
        private Program program;
        private int programCounter = 0;
        private int recursionCount = 0;
        private static final int NOT_RECURSIVE = 0;

        private ProgramState() {
        }

        public String toString() {
            return this.program.toString() + ", counter " + this.programCounter + ", recursionCount " + (this.recursionCount == 0 ? "not recursive" : "" + this.recursionCount);
        }
    }
}

