/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.server;

import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.socket.SocketLog;
import com.metamatrix.common.comm.platform.socket.server.ServerWorkItem;
import com.metamatrix.common.comm.platform.socket.server.SocketClientConnection;
import com.metamatrix.common.comm.service.ExceptionHolder;

public class ServerSynchronousWorkItem
extends ServerWorkItem {
    Integer synchRequestId;

    public ServerSynchronousWorkItem(SocketClientConnection clientConnection, Integer synchRequestId, Message message, SocketLog log, ServerListener serverListener) {
        super(clientConnection, message, log, serverListener);
        this.synchRequestId = synchRequestId;
    }

    void process() throws CommunicationException {
        try {
            if (this.log.isLogged("ServerSynchronousWorkItem.process", 5)) {
                this.log.logDetail("ServerSynchronousWorkItem.process", "forwarding message to listener:" + this.message);
            }
            Message result = this.serverListener.receive((ClientConnection)this.clientConnection, this.message);
            if (this.log.isLogged("ServerSynchronousWorkItem.process", 5)) {
                this.log.logDetail("ServerSynchronousWorkItem.process", "sessionID: " + this.clientConnection.getSessionId());
                this.log.logDetail("ServerSynchronousWorkItem.process", "message: " + this.message);
                this.log.logDetail("ServerSynchronousWorkItem.process", "sending response: " + result + " for request ID:" + this.synchRequestId);
            }
            this.clientConnection.sendSynchronousResponse(this.synchRequestId, result);
        }
        catch (ApplicationException e) {
            this.log.logError("ServerSynchronousWorkItem.process", e, e.getMessage());
            MessageHolder responseMessage = new MessageHolder();
            responseMessage.contents = new ExceptionHolder((Throwable)new ApplicationException(e.getMessage()));
            this.clientConnection.sendSynchronousResponse(this.synchRequestId, (Message)responseMessage);
        }
    }
}

