/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket.client;

import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.comm.api.ServerInstance;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.socket.ObjectSocketFactory;
import com.metamatrix.common.comm.platform.socket.SocketLog;
import com.metamatrix.common.comm.platform.socket.client.ServerInstanceFactory;
import com.metamatrix.common.comm.platform.socket.client.SocketServerInstanceImpl;
import com.metamatrix.common.queue.WorkerPool;

public class SocketServerInstanceFactory
implements ServerInstanceFactory {
    private WorkerPool workerPool = null;
    private SocketLog log = null;
    private long socketTimeout = -1L;
    private ClassLoader classLoader;
    private int inputBufferSize;
    private int outputBufferSize;
    private boolean conserveBandwidth;
    private ObjectSocketFactory objectSocketFactory;

    public SocketServerInstanceFactory(WorkerPool pool, SocketLog log, long timeout, ClassLoader classLoader, int inputBufferSize, int outputBufferSize, boolean conserveBandwidth, ObjectSocketFactory objectSocketFactory) {
        this.workerPool = pool;
        this.log = log;
        this.socketTimeout = timeout;
        this.classLoader = classLoader;
        this.inputBufferSize = inputBufferSize;
        this.outputBufferSize = outputBufferSize;
        this.conserveBandwidth = conserveBandwidth;
        this.objectSocketFactory = objectSocketFactory;
    }

    public ServerInstance createServerInstance(HostInfo host) throws CommunicationException {
        return new SocketServerInstanceImpl(host, this.workerPool, this.socketTimeout, this.log, this.classLoader, this.inputBufferSize, this.outputBufferSize, this.conserveBandwidth, this.objectSocketFactory);
    }
}

