/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.xml.wizards;

import com.metamatrix.core.log.Logger;
import com.metamatrix.modeler.core.validation.rules.CoreValidationRulesUtil;
import com.metamatrix.modeler.modelgenerator.xml.XmlImporterUiPlugin;
import com.metamatrix.modeler.modelgenerator.xml.model.UserSettings;
import com.metamatrix.modeler.schema.tools.model.schema.QName;
import com.metamatrix.modeler.schema.tools.model.schema.RootElement;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaModel;
import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.processing.RelationshipProcessor;
import com.metamatrix.modeler.schema.tools.processing.RelationshipProcessorFactory;
import com.metamatrix.modeler.schema.tools.processing.SchemaProcessor;
import com.metamatrix.modeler.schema.tools.processing.SchemaUtil;
import com.metamatrix.modeler.schema.tools.processing.internal.SchemaProcessorImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;

public class StateManager {
    protected Map xsds = new HashMap();
    private ResourceSet resourceSet;
    private SchemaModel schemaModel;
    private SchemaModel processedModel;
    private Collection selectedRoots;
    private SchemaProcessor processor;
    private RelationshipProcessor relationshipProcessor;
    private boolean schemasModified = false;
    private boolean rootsModified = true;
    private boolean modelDirty = true;
    UserSettings userSettings;
    int catalogType = 1;
    private String customCatalogName;
    private Logger logger;
    public static final int SOURCE_DOCUMENT = 0;
    public static final int SOURCE_HTTP_NO_PARAMS = 1;
    public static final int SOURCE_HTTP_PARAMS = 2;
    public static final int SOURCE_HTTP_REQUEST_DOC = 3;
    public static final int SOURCE_ACS = 4;
    private boolean acsMode = false;
    public static String globalNamespace = XmlImporterUiPlugin.getDefault().getPluginUtil().getString("XsdAsRelationalImportWizard.globalNamespace");

    public StateManager(UserSettings userSettings, Logger logger) {
        this.userSettings = userSettings;
        this.logger = logger;
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("wsdl", new XSDResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        this.resourceSet = new ResourceSetImpl();
    }

    public void addSchema(Object key, URI uri) {
        this.xsds.put(key, uri);
        this.schemasModified = true;
    }

    public Set getSchemaKeySet() {
        return this.xsds.keySet();
    }

    public int getSchemaCount() {
        return this.xsds.size();
    }

    public Object removeSchema(Object key) {
        return this.xsds.remove(key);
    }

    public List getSchemaURIs() {
        return new ArrayList(this.xsds.values());
    }

    public Collection getPotentialRoots() throws Exception {
        if (null == this.processor) {
            this.processor = new SchemaProcessorImpl(this.logger, UserSettings.getMergedChildSep());
        }
        if (null == this.schemaModel || this.schemasModified) {
            this.initSchemaModel();
            this.schemasModified = false;
        }
        if (null == this.selectedRoots) {
            this.selectedRoots = new HashSet();
        }
        List potentialRoots = this.schemaModel.getPotentialRootElements();
        Iterator iter = potentialRoots.iterator();
        while (iter.hasNext()) {
            RootElement elem = (RootElement)iter.next();
            if (!elem.isUseAsRoot()) continue;
            this.selectedRoots.add(elem);
        }
        return potentialRoots;
    }

    public void setSelectedRoots(Collection selectedRoots) {
        this.selectedRoots = selectedRoots;
        this.rootsModified = true;
        this.modelDirty = true;
    }

    public boolean isUserSelectedRoot(SchemaObject element) {
        Iterator iter = this.selectedRoots.iterator();
        while (iter.hasNext()) {
            RootElement root = (RootElement)iter.next();
            if (root.getKey() != element.getKey()) continue;
            return true;
        }
        return false;
    }

    private void initSchemaModel() throws Exception {
        List<Object> schemaUriList = Arrays.asList(this.xsds.values().toArray());
        ArrayList<XSDSchema> schemas = new ArrayList<XSDSchema>(schemaUriList.size());
        Iterator<Object> iter = schemaUriList.iterator();
        while (iter.hasNext()) {
            Resource res;
            URI uri = (URI)iter.next();
            File file = new File(uri.toString());
            if (uri.scheme() != null && uri.scheme().equals("ACSResponse") || uri.scheme() != null && uri.scheme().equals("ACSRequest")) {
                ByteArrayInputStream stream = new ByteArrayInputStream(uri.fragment().getBytes("UTF-8"));
                XSDResourceImpl acsResource = new XSDResourceImpl();
                acsResource.setURI(uri);
                this.resourceSet.getResources().add((Object)acsResource);
                acsResource.load((InputStream)stream, new HashMap());
                res = acsResource;
            } else {
                URI resourceUri = file.isFile() ? URI.createFileURI((String)file.getCanonicalPath().toString()) : uri;
                res = this.resourceSet.getResource(resourceUri, true);
            }
            schemas.add(((XSDResourceImpl)res).getSchema());
        }
        XSDSchema[] result = new XSDSchema[schemas.size()];
        schemas.toArray(result);
        this.processor.processSchemas(result);
        this.schemaModel = this.processor.getSchemaModel();
    }

    public SchemaModel getProcessedModel() {
        if (null == this.processedModel || !this.modelDirty) {
            if (null == this.relationshipProcessor) {
                this.relationshipProcessor = RelationshipProcessorFactory.getQueryOptimizingProcessor((int)this.userSettings.get_C_threshold(), (int)this.userSettings.get_P_threshold(), (int)this.userSettings.get_F_threshold());
            }
            this.processedModel = this.schemaModel.copy();
            HashSet roots = new HashSet(this.selectedRoots);
            this.processedModel.setSelectedRootElements(roots);
            this.relationshipProcessor.calculateRelationshipTypes(this.processedModel);
        }
        this.modelDirty = false;
        return this.processedModel;
    }

    public SchemaModel getSchemaModel() {
        return this.schemaModel;
    }

    public RelationshipProcessor getRelationshipProcessor() {
        return this.relationshipProcessor;
    }

    public List getCatalogs() {
        ArrayList<String> retVal = null;
        switch (this.getCatalogType()) {
            case 1: 
            case 2: {
                retVal = this.getDefaultNamespaces();
                break;
            }
            case 3: {
                retVal = this.getFileNames();
                break;
            }
            case 4: {
                retVal = new ArrayList(1);
                retVal.add(this.customCatalogName);
                break;
            }
            default: {
                retVal = new ArrayList<String>();
            }
        }
        return retVal;
    }

    private List getDefaultNamespaces() {
        return this.schemaModel.getDefaultNamespaces();
    }

    public int getCatalogType() {
        return this.catalogType;
    }

    public void setCatalogType(int catalogType) {
        this.catalogType = catalogType;
    }

    private List getFileNames() {
        ArrayList<String> retVal = new ArrayList<String>(this.xsds.size());
        Collection xsdValues = this.xsds.values();
        Iterator i = xsdValues.iterator();
        while (i.hasNext()) {
            URI uri = (URI)i.next();
            retVal.add(SchemaUtil.shortenFileName((String)SchemaProcessorImpl.getSchemaFromURI((URI)uri).getSchemaLocation()));
        }
        return retVal;
    }

    public void setCustomCatalogName(String name) {
        this.customCatalogName = name;
    }

    public String getCustomCatalogName() {
        return this.customCatalogName;
    }

    public boolean isUsingNoCatalog() {
        return this.catalogType == 1;
    }

    public boolean isUsingNamespaces() {
        return this.catalogType == 2;
    }

    public boolean isUsingFileNames() {
        return this.catalogType == 3;
    }

    public boolean isUsingCustom() {
        return this.catalogType == 4;
    }

    public Map getNamespaces() {
        return this.schemaModel.getNamespaces();
    }

    public String getFirstCatalog() {
        String catalog = "";
        Iterator resourceIter = this.xsds.values().iterator();
        while (resourceIter.hasNext()) {
            Object o = resourceIter.next();
            URI uri = (URI)o;
            catalog = SchemaProcessorImpl.getSchemaFromURI((URI)uri).getTargetNamespace();
        }
        return catalog;
    }

    public QName getRequestResponseTable() {
        String namespace;
        List catalogs = this.getCatalogs();
        int global = -1;
        int countExcludingGlobal = catalogs.size();
        for (int i = 0; i < catalogs.size(); ++i) {
            if (catalogs.get(i) != null && !catalogs.get(i).equals(globalNamespace)) continue;
            global = i;
            --countExcludingGlobal;
            break;
        }
        switch (countExcludingGlobal) {
            case 0: {
                namespace = globalNamespace;
                break;
            }
            case 1: {
                if (global == 0) {
                    namespace = (String)catalogs.get(1);
                    break;
                }
                namespace = (String)catalogs.get(0);
                break;
            }
            default: {
                if (global == -1) {
                    TreeSet treeSet = new TreeSet();
                    for (int i = 0; i < catalogs.size(); ++i) {
                        treeSet.add(catalogs.get(i));
                    }
                    namespace = (String)treeSet.first();
                    break;
                }
                namespace = (String)catalogs.get(global);
            }
        }
        return SchemaUtil.getQName((String)namespace, (String)this.userSettings.getRequestTableLocalName());
    }

    public Boolean isRequestOrResponseTable(QName qname) {
        if (0 == this.userSettings.getSourceType() || 1 == this.userSettings.getSourceType()) {
            return null;
        }
        boolean retval = qname.equals(this.getRequestResponseTable());
        return new Boolean(retval);
    }

    public String getCatalog(SchemaObject table) {
        String catalog = "";
        if (this.isUsingNamespaces() || this.isUsingNoCatalog()) {
            String namespace = table.getNamespace();
            catalog = namespace == null ? globalNamespace : CoreValidationRulesUtil.getValidString((String)namespace, null, (int)-1);
        }
        if (this.isUsingFileNames()) {
            catalog = table.getFileName();
        }
        if (this.isUsingCustom()) {
            catalog = (String)this.getCatalogs().get(0);
        }
        return catalog;
    }

    public void setACSMode(boolean acsMode) {
        this.acsMode = acsMode;
    }

    public boolean getACSMode() {
        return this.acsMode;
    }
}

