/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.xml.model;

import com.metamatrix.modeler.schema.tools.model.schema.SchemaObject;
import com.metamatrix.modeler.schema.tools.processing.SchemaUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.xsd.XSDSchema;

public class SchemaRepresentation {
    private List schemaURIs;
    private XSDSchema[] xsdSchemas;
    private Map m_namespaces;
    private List m_defaultNamespaces;
    private List elements;
    private int m_catalogType;
    private String m_customCatalogName;
    private Object syncObject;

    public SchemaRepresentation(Object syncObject) {
        this.syncObject = syncObject;
        this.setSchemaURIs(new ArrayList());
        this.m_catalogType = 1;
        this.m_customCatalogName = null;
        this.m_namespaces = new HashMap();
        this.m_defaultNamespaces = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchemaURIs(List schemaURIs) {
        Object object = this.syncObject;
        synchronized (object) {
            this.schemaURIs = schemaURIs;
            this.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getSchemaURIs() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.schemaURIs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCatalogs() {
        Object object = this.syncObject;
        synchronized (object) {
            ArrayList<String> retVal = null;
            switch (this.m_catalogType) {
                case 1: 
                case 2: {
                    retVal = this.getDefaultNamespaces();
                    break;
                }
                case 3: {
                    retVal = this.getFileNames();
                    break;
                }
                case 4: {
                    retVal = new ArrayList(1);
                    retVal.add(this.m_customCatalogName);
                    break;
                }
                default: {
                    retVal = new ArrayList<String>();
                }
            }
            return retVal;
        }
    }

    private List getDefaultNamespaces() {
        return this.m_defaultNamespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject[] getRootTables() {
        Object object = this.syncObject;
        synchronized (object) {
            ArrayList<SchemaObject> roots = new ArrayList<SchemaObject>();
            Iterator iter = this.elements.iterator();
            while (iter.hasNext()) {
                Object otable = iter.next();
                SchemaObject table = (SchemaObject)otable;
                if (!table.isCanBeRoot()) continue;
                roots.add(table);
            }
            SchemaObject[] retval = new SchemaObject[roots.size()];
            roots.toArray(retval);
            return retval;
        }
    }

    private void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getNamespaces() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.m_namespaces;
        }
    }

    private List getFileNames() {
        ArrayList<String> retVal = new ArrayList<String>(this.xsdSchemas.length);
        for (int i = 0; i < this.xsdSchemas.length; ++i) {
            retVal.add(SchemaUtil.shortenFileName((String)this.xsdSchemas[i].getSchemaLocation()));
        }
        return retVal;
    }

    public void setCustomCatalogName(String name) {
        this.m_customCatalogName = name;
    }

    public boolean addElement(SchemaObject element) {
        return this.elements.add(element);
    }
}

