/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.oracle.OracleImplStatement;
import com.metamatrix.jdbc.oracle.OracleInternalParameter;
import com.metamatrix.jdbc.oracle.OracleInternalParameterSet;
import com.metamatrix.jdbc.oracle.OracleVNU;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTDAPacket;
import com.metamatrix.jdbc.oracle.net8.TTIDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OALL8;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OLOBOPS;
import com.metamatrix.jdbc.oracle.net8.TTIOERDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIRXDDataPacket;
import com.metamatrix.util.UtilDataConversions;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class OracleImplClob
extends BaseImplClob {
    private static String footprint = "$Revision:   3.59.1.1  $";
    static final int MULTI_CHAR_BYTE = 6;
    static final int ENDIAN_BYTE = 7;
    static final byte MULTI_CHAR_INDICATOR = -128;
    static final byte LITTLE_ENDIAN_INDICATOR = 64;
    static final int ValueInLocatorOffset = 102;
    static final int ENCODING_LITTLEENDIANUNICODE = 0;
    static final int ENCODING_BIGENDIANUNICODE = 1;
    static final int ENCODING_INTARRAY = 2;
    static final int ENCODING_CHARSET = 3;
    private int m_encodingType;
    private int m_numCharsEmbeddedWithinLocator;
    private char[] m_charsEmbeddedWithinLocator;
    public byte[] cloblocator;
    public int ClobcharSetForm;
    public int ClobcharSet;
    private long cachedCurrentLength;
    private boolean cachedCurrentLengthIsCorrect;
    private OracleImplStatement implstmt;
    private OracleInternalParameterSet paramSet;

    public OracleImplClob(byte[] byArray, OracleImplStatement oracleImplStatement, int n) throws SQLException {
        super(oracleImplStatement.comm.exceptions);
        this.ClobcharSetForm = 0;
        this.ClobcharSet = 0;
        this.cachedCurrentLength = 0L;
        this.cachedCurrentLengthIsCorrect = false;
        this.paramSet = null;
        this.implstmt = oracleImplStatement;
        this.cachedCurrentLengthIsCorrect = false;
        this.ClobcharSet = n;
        this.setLocator(byArray);
    }

    protected void processLocatorForEmbeddedData() throws SQLException {
        if (this.implstmt.getSQL().hasForUpdate()) {
            this.m_numCharsEmbeddedWithinLocator = 0;
            this.m_charsEmbeddedWithinLocator = null;
            return;
        }
        if (this.cloblocator.length < 102) {
            this.m_numCharsEmbeddedWithinLocator = 0;
            this.m_charsEmbeddedWithinLocator = null;
            return;
        }
        if (this.cloblocator[101] != 1) {
            this.m_numCharsEmbeddedWithinLocator = 0;
            this.m_charsEmbeddedWithinLocator = null;
            return;
        }
        int n = (this.cloblocator[94] << 8) + (this.cloblocator[95] & 0xFF);
        UtilDebug.assert((String)"unexpected embedded LOB length", (n <= this.cloblocator.length - 102 ? 1 : 0) != 0);
        this.m_charsEmbeddedWithinLocator = new char[n];
        this.m_numCharsEmbeddedWithinLocator = this.processDataBytes(this.m_charsEmbeddedWithinLocator, 0, this.cloblocator, 102, n);
    }

    private int chooseEncoding() {
        if ((this.cloblocator[6] & 0xFFFFFF80) == -128) {
            if (this.implstmt.implConn.oracleServerVersion == 801070000L || this.implstmt.implConn.oracleServerVersion == 801060000L) {
                if (this.implstmt.implConn.byteOrder == 256) {
                    return 0;
                }
                return 1;
            }
            if (this.implstmt.implConn.oracleServerVersion < 1000000000L) {
                return 2;
            }
            if ((this.cloblocator[7] & 0x40) == 64) {
                return 0;
            }
            return 1;
        }
        return 3;
    }

    private void setLocator(byte[] byArray) throws SQLException {
        this.cloblocator = byArray;
        this.m_encodingType = this.chooseEncoding();
        this.processLocatorForEmbeddedData();
    }

    private int processDataBytes(char[] cArray, int n, byte[] byArray, int n2, int n3) throws SQLException {
        if (n3 > 0) {
            int n4 = 0;
            switch (this.m_encodingType) {
                case 2: {
                    int n5 = 0;
                    int n6 = n2 + n3;
                    while (n2 < n6) {
                        switch (byArray[n2++]) {
                            case 0: {
                                cArray[n + n5++] = '\u0000';
                                break;
                            }
                            case 1: {
                                cArray[n + n5++] = (char)(byArray[n2++] & 0xFF);
                                break;
                            }
                            case 2: {
                                try {
                                    cArray[n + n5++] = (char)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
                                    break;
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    System.out.println("Hello");
                                }
                            }
                        }
                    }
                    n4 = n5;
                    break;
                }
                case 0: {
                    UtilDataConversions.LittleEndianByteArrayToUCS2CharArray((byte[])byArray, (int)n2, (char[])cArray, (int)n, (int)n3);
                    n4 = n3 / 2;
                    break;
                }
                case 1: {
                    UtilDataConversions.ByteArrayToUCS2CharArray((byte[])byArray, (int)n2, (char[])cArray, (int)n, (int)n3);
                    n4 = n3 / 2;
                    break;
                }
                case 3: {
                    if (this.ClobcharSet == 2000) {
                        UtilDataConversions.ByteArrayToUCS2CharArray((byte[])byArray, (int)n2, (char[])cArray, (int)n, (int)n3);
                        n4 = n3 / 2;
                        break;
                    }
                    if (this.ClobcharSet == 31) {
                        UtilDataConversions.AsciiByteArrayToUCS2CharArray((byte[])byArray, (int)n2, (char[])cArray, (int)n, (int)n3);
                        n4 = n3;
                        break;
                    }
                    UtilTransliterator utilTransliterator = this.implstmt.implConn.comm.getReader().getTransliterator();
                    try {
                        n4 = utilTransliterator.decode(byArray, n2, n3, cArray, n);
                        break;
                    }
                    catch (Exception exception) {
                        throw this.implstmt.comm.exceptions.getException(exception);
                    }
                }
            }
            return n4;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public OracleImplClob(OracleImplStatement var1_1, BaseParameter var2_2, int var3_3, boolean var4_4, String var5_5, byte[] var6_6) throws SQLException {
        block8: {
            block7: {
                super(var1_1.comm.exceptions);
                this.ClobcharSetForm = 0;
                this.ClobcharSet = 0;
                this.cachedCurrentLength = 0L;
                this.cachedCurrentLengthIsCorrect = false;
                this.paramSet = null;
                this.implstmt = var1_1;
                var7_7 = this.implstmt.implConn.NSPTDAPacket;
                this.ClobcharSet = var3_3;
                this.cloblocator = new byte[86];
                this.cloblocator[1] = 84;
                var8_8 = new TTIFUN_OLOBOPS(272, this.implstmt.implConn);
                var8_8.SourceLobLocator = this.cloblocator;
                var8_8.SourceOffset = var4_4 != false ? 2 : 1;
                var8_8.DestinationOffset = 112;
                var8_8.DestinationLength = 10;
                var8_8.brequestLobamt = true;
                var8_8.LobAmt = 10L;
                var8_8.brequestIfnull = true;
                var8_8.CharSet = (short)var3_3;
                var7_7.appendTTISubPacket(var8_8);
                var7_7.sendRequest();
                var7_7.receiveReply();
                var9_9 = new TTIOERDataPacket(this.implstmt.implConn);
                this.implstmt.implConn.processReply(var8_8, var9_9);
                if (var9_9.retCode != 0) {
                    var10_10 = new String[]{var9_9.errMsg};
                    var11_12 = this.implstmt.comm.exceptions.getException(6001, var10_10, var9_9.getSQLState(), (int)var9_9.retCode);
                    throw var11_12;
                }
                this.setLocator(var8_8.SourceLobLocator);
                var10_11 = 1;
                if (var5_5 != null) break block7;
                var12_15 = var2_2.getType();
                if (var12_15 == 18) ** GOTO lbl-1000
                if (var12_15 == 10) ** GOTO lbl-1000
                if (var12_15 == 15) ** GOTO lbl-1000
                if (var12_15 == 2) ** GOTO lbl-1000
                if (var12_15 == 14) ** GOTO lbl-1000
                if (var12_15 == 17) ** GOTO lbl-1000
                if (var12_15 == 20) lbl-1000:
                // 7 sources

                {
                    var11_13 = var2_2.getCharacterStreamReader(-1, (BaseConnection)this.implstmt.implConn.connection, this.implstmt.comm.exceptions);
                } else {
                    var11_13 = new StringReader(var2_2.getString(-1, this.implstmt.comm.exceptions));
                }
                var13_16 = new char[(int)this.getMaxChunkSize()];
                var14_17 = 0;
                try {
                    while ((var14_17 = var11_13.read(var13_16)) > 0) {
                        this.mywriteData(var10_11, var13_16, 0, var14_17, null);
                        var10_11 += var14_17;
                    }
                }
                catch (IOException var15_18) {
                    var16_19 = this.implstmt.comm.exceptions.getException((Exception)var15_18);
                    throw var16_19;
                }
                this.cachedCurrentLengthIsCorrect = true;
                this.cachedCurrentLength = var10_11 - 1;
                break block8;
            }
            if (var5_5.length() != 0) {
                var11_14 = var5_5.toCharArray();
                this.mywriteData(var10_11, var11_14, 0, var11_14.length, var6_6);
                this.cachedCurrentLength = var10_11 - 1;
                this.cachedCurrentLengthIsCorrect = true;
            }
        }
    }

    public long getMaxChunkSize() {
        return 32512L;
    }

    public boolean supportsSearch() {
        return true;
    }

    public long find(String string, long l) throws SQLException {
        byte[] byArray;
        int n = (int)l;
        int n2 = string.length();
        try {
            byArray = this.ClobcharSet == 2000 ? string.getBytes("UTF-16BE") : this.implstmt.implConn.NSPTDAPacket.writer.getTransliterator().encode(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw this.implstmt.comm.exceptions.getException((Exception)((Object)new UtilException(1009)));
        }
        catch (UtilException utilException) {
            throw this.implstmt.comm.exceptions.getException((Exception)((Object)utilException));
        }
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this.implstmt.implConn);
        tTIFUN_OALL8.setOptions(1065);
        tTIFUN_OALL8.setCommandText("begin :rslt := dbms_lob.instr(:lctr,:ptrn,:offset,:occ); end;");
        tTIFUN_OALL8.setCursorID(this.implstmt.implConn.getCursorID());
        if (this.paramSet == null) {
            this.paramSet = new OracleInternalParameterSet();
        } else {
            this.paramSet.reset();
        }
        int n3 = 0;
        OracleInternalParameter oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(6, 0, 0, 16, 0, 0, this.implstmt.comm.transliterator);
        oracleInternalParameter.m_direction = 16;
        oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(112, 0, 0, this.cloblocator.length, 0, 0, this.implstmt.comm.transliterator);
        oracleInternalParameter.m_nativeDataIn = this.cloblocator;
        oracleInternalParameter.m_nativeDataInLength = this.cloblocator.length;
        oracleInternalParameter.m_direction = 32;
        int n4 = byArray.length > 4096 ? 4096 : byArray.length;
        oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(1, 0, 0, n4, 0, 0, this.implstmt.comm.transliterator);
        oracleInternalParameter.m_nativeDataIn = byArray;
        oracleInternalParameter.m_nativeDataInLength = n4;
        oracleInternalParameter.m_direction = 32;
        oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(6, 0, 0, 16, 0, 0, this.implstmt.comm.transliterator);
        byte[] byArray2 = new byte[22];
        n3 = OracleVNU.convertIntToVNU(byArray2, n);
        oracleInternalParameter.m_nativeDataIn = byArray2;
        oracleInternalParameter.m_nativeDataInLength = n3;
        oracleInternalParameter.m_direction = 32;
        oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(6, 0, 0, 16, 0, 0, this.implstmt.comm.transliterator);
        byte[] byArray3 = new byte[22];
        n3 = OracleVNU.convertIntToVNU(byArray3, 1);
        oracleInternalParameter.m_nativeDataIn = byArray3;
        oracleInternalParameter.m_nativeDataInLength = n3;
        oracleInternalParameter.m_direction = 32;
        tTIFUN_OALL8.setParameters(this.paramSet);
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
        TTIRXDDataPacket tTIRXDDataPacket = new TTIRXDDataPacket(this.implstmt.implConn);
        tTIRXDDataPacket.setParameters(this.paramSet);
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIRXDDataPacket);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        this.implstmt.implConn.processReply(null, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        oracleNet8NSPTDAPacket.getNextNextTTISubpacket(tTIRXDDataPacket);
        oracleInternalParameter = this.paramSet.paramSet[0];
        BaseExceptions baseExceptions = this.implstmt.comm.exceptions;
        long l2 = OracleVNU.convertVNUToLong(oracleInternalParameter.getSingleOutputValue(baseExceptions), oracleInternalParameter.getSingleOutputValueLength(baseExceptions), baseExceptions);
        return l2 == 0L ? -1L : l2;
    }

    public long getLength() throws SQLException {
        if (this.m_numCharsEmbeddedWithinLocator > 0) {
            return this.m_numCharsEmbeddedWithinLocator;
        }
        if (this.cachedCurrentLengthIsCorrect) {
            return this.cachedCurrentLength;
        }
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(1, this.cloblocator, this.implstmt.implConn);
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        this.cachedCurrentLength = tTIFUN_OLOBOPS.LobAmt;
        this.cachedCurrentLengthIsCorrect = true;
        return this.cachedCurrentLength;
    }

    public void close() throws SQLException {
    }

    public int readData(char[] cArray, int n, long l, int n2) throws SQLException {
        String[] stringArray;
        if (this.m_numCharsEmbeddedWithinLocator > 0) {
            System.arraycopy(this.m_charsEmbeddedWithinLocator, (int)l - 1, cArray, n, n2);
            return n2;
        }
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(2, this.cloblocator, this.implstmt.implConn);
        tTIFUN_OLOBOPS.SourceLobLocator = this.cloblocator;
        tTIFUN_OLOBOPS.brequestLobamt = true;
        tTIFUN_OLOBOPS.LobAmt = n2;
        tTIFUN_OLOBOPS.SourceOffset = (int)l;
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        int n3 = oracleNet8NSPTDAPacket.getNextTTCCode();
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray2 = new String[]{tTIOERDataPacket.errMsg};
            throw this.implstmt.comm.exceptions.getException(6001, stringArray2, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
        }
        byte[] byArray = null;
        int n4 = 0;
        if (n3 == 14) {
            stringArray = new TTIRXDDataPacket(this.implstmt.implConn);
            oracleNet8NSPTDAPacket.getNextNextTTISubpacket((TTIDataPacket)stringArray);
            stringArray.setBaseExceptions(this.exceptions);
            byArray = stringArray.readRXDDataWithoutIndicator(n2, this.exceptions);
            n4 = byArray.length;
        }
        this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            stringArray = new String[]{tTIOERDataPacket.errMsg};
            throw this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
        }
        return this.processDataBytes(cArray, n, byArray, 0, n4);
    }

    public void truncate(long l) throws SQLException {
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(32, this.cloblocator, this.implstmt.implConn);
        tTIFUN_OLOBOPS.brequestLobamt = true;
        tTIFUN_OLOBOPS.LobAmt = (int)l;
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            SQLException sQLException = this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
            throw sQLException;
        }
        this.setLocator(tTIFUN_OLOBOPS.SourceLobLocator);
        this.cachedCurrentLengthIsCorrect = false;
    }

    public int mywriteData(long l, char[] cArray, int n, int n2, byte[] byArray) throws SQLException {
        byte[] byArray2 = null;
        switch (this.m_encodingType) {
            case 2: {
                byArray2 = new byte[n2 * 3];
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    byArray2[n3++] = 2;
                    byArray2[n3++] = (byte)(cArray[n] >> 8 & 0xFF);
                    byArray2[n3++] = (byte)(cArray[n] & 0xFF);
                    ++n;
                }
                break;
            }
            case 0: {
                byArray2 = UtilDataConversions.UCS2CharArrayToLittleEndianByteArray((char[])cArray, (int)n, (int)n2);
                break;
            }
            case 1: {
                byArray2 = UtilDataConversions.UCS2CharArrayToByteArray((char[])cArray, (int)n, (int)n2);
                break;
            }
            case 3: {
                if (this.ClobcharSet == 2000) {
                    byArray2 = UtilDataConversions.UCS2CharArrayToByteArray((char[])cArray, (int)n, (int)n2);
                    break;
                }
                if (byArray == null) {
                    UtilTransliterator utilTransliterator = this.implstmt.implConn.comm.getReader().getTransliterator();
                    try {
                        byArray2 = utilTransliterator.encode(cArray, n, n2);
                        break;
                    }
                    catch (UtilException utilException) {
                        throw this.implstmt.comm.exceptions.getException((Exception)((Object)utilException));
                    }
                }
                byArray2 = byArray;
            }
        }
        OracleNet8NSPTDAPacket oracleNet8NSPTDAPacket = this.implstmt.implConn.NSPTDAPacket;
        TTIFUN_OLOBOPS tTIFUN_OLOBOPS = new TTIFUN_OLOBOPS(64, this.cloblocator, this.implstmt.implConn);
        tTIFUN_OLOBOPS.SourceLobLocator = this.cloblocator;
        tTIFUN_OLOBOPS.brequestLobamt = true;
        tTIFUN_OLOBOPS.LobAmt = n2;
        tTIFUN_OLOBOPS.SourceOffset = (int)l;
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOBOPS);
        if (this.paramSet == null) {
            this.paramSet = new OracleInternalParameterSet();
        } else {
            this.paramSet.reset();
        }
        OracleInternalParameter oracleInternalParameter = this.paramSet.getAvailableParameter();
        oracleInternalParameter.setInfo(23, 0, 0, 0, 0, 0, this.implstmt.comm.transliterator);
        oracleInternalParameter.m_nativeDataIn = byArray2;
        oracleInternalParameter.m_nativeDataInLength = byArray2.length;
        oracleInternalParameter.m_direction = 32;
        TTIRXDDataPacket tTIRXDDataPacket = new TTIRXDDataPacket(this.implstmt.implConn, 14);
        tTIRXDDataPacket.setParameters(this.paramSet);
        oracleNet8NSPTDAPacket.appendTTISubPacket(tTIRXDDataPacket);
        oracleNet8NSPTDAPacket.sendRequest();
        oracleNet8NSPTDAPacket.receiveReply();
        TTIOERDataPacket tTIOERDataPacket = new TTIOERDataPacket(this.implstmt.implConn);
        this.implstmt.implConn.processReply(tTIFUN_OLOBOPS, tTIOERDataPacket);
        if (tTIOERDataPacket.retCode != 0) {
            String[] stringArray = new String[]{tTIOERDataPacket.errMsg};
            throw this.implstmt.comm.exceptions.getException(6001, stringArray, tTIOERDataPacket.getSQLState(), (int)tTIOERDataPacket.retCode);
        }
        this.setLocator(tTIFUN_OLOBOPS.SourceLobLocator);
        this.cachedCurrentLengthIsCorrect = false;
        return (int)tTIFUN_OLOBOPS.LobAmt;
    }

    public int writeData(long l, char[] cArray, int n, int n2) throws SQLException {
        return this.mywriteData(l, cArray, n, n2, null);
    }
}

