/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.cache;

import com.metamatrix.connector.xml.CachingConnector;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.connector.xml.cache.Record;
import com.metamatrix.connector.xml.cache.RequestPartRecord;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import java.util.HashMap;
import java.util.Map;

public class RequestRecord
implements Record {
    CachingConnector connector;
    String requestID;
    Map requestParts;

    public RequestRecord(String requestID, CachingConnector connector) throws ConnectorException {
        if (null == requestID) {
            throw new ConnectorException("RequestRecord: RequestIDs cannot be null");
        }
        if (null == connector) {
            throw new ConnectorException("RequestRecord: The CachingConnector parameter cannot be null");
        }
        this.requestID = requestID;
        this.connector = connector;
        this.requestParts = new HashMap();
    }

    public void addRequestPart(String partID, String executionID, String sourceRequestID, String cacheKey, ConnectorLogger logger) {
        logger.logTrace("addRequestPart(" + partID + ", " + executionID + ", " + sourceRequestID + ", " + cacheKey + ", logger)");
        RequestPartRecord partRecord = (RequestPartRecord)this.requestParts.get(partID);
        if (null == partRecord) {
            logger.logTrace("Creating new RequestPartRecord for Request Part Identifier " + partID + " and Invocation Number " + sourceRequestID);
            partRecord = new RequestPartRecord(this, partID, executionID, sourceRequestID, cacheKey, logger);
            this.requestParts.put(partID, partRecord);
        } else {
            logger.logTrace("Adding new Source Request ID to existing RequestPartRecord: Invocation Number " + sourceRequestID);
            partRecord.addExecutionRecord(executionID, sourceRequestID, cacheKey, logger);
        }
    }

    public void deleteRequestPart(String partID, String executionID, ConnectorLogger logger) {
        RequestPartRecord partRecord = (RequestPartRecord)this.requestParts.get(partID);
        if (null != partRecord) {
            logger.logTrace("Deleting RequestPartRecord for Part Identifier " + partID);
            partRecord.deleteExecutionRecords(executionID, logger);
            this.requestParts.remove(partID);
        }
    }

    public boolean isEmpty() {
        return this.requestParts.isEmpty();
    }

    public IDocumentCache getCache() {
        return this.connector.getCache();
    }

    public String getID() {
        return this.requestID;
    }
}

