/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.cache;

import com.metamatrix.connector.xml.cache.CachedObjectRecord;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.connector.xml.cache.Record;
import com.metamatrix.data.api.ConnectorLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ExecutionRecord
implements Record {
    Record parent;
    String executionID;
    Map cacheRecords = new HashMap();

    public ExecutionRecord(Record parent, String executionID, String sourceRequestID, String cacheKey) {
        this.executionID = executionID;
        this.parent = parent;
        this.addCacheRecord(sourceRequestID, cacheKey);
    }

    public void addCacheRecord(String sourceRequestID, String cacheKey) {
        CachedObjectRecord record = (CachedObjectRecord)this.cacheRecords.get(this.executionID);
        if (null != record) {
            throw new RuntimeException("Error - Cannot add a CacheRecord to a RequestPartRecord with an existing key");
        }
        record = new CachedObjectRecord(this, sourceRequestID, cacheKey);
        this.cacheRecords.put(sourceRequestID, record);
    }

    public void deleteCacheItems(ConnectorLogger logger) {
        Collection records = this.cacheRecords.values();
        Iterator iter = records.iterator();
        while (iter.hasNext()) {
            CachedObjectRecord record = (CachedObjectRecord)iter.next();
            String cacheKey = record.getCacheKey();
            String id = this.getID();
            this.parent.getCache().release(cacheKey, id);
            logger.logTrace("Releasing cache item with key " + cacheKey + " and id " + id);
        }
        this.cacheRecords.clear();
    }

    public String getID() {
        return this.parent.getID() + this.executionID;
    }

    public IDocumentCache getCache() {
        return this.parent.getCache();
    }
}

