/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.proc;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateUpdateProcedureCommand
extends Command {
    private Block block;
    private Map symbolMap;
    private Command userCommand;
    private boolean isUpdateProcedure = true;
    private List projectedSymbols;
    private List parentProjectSymbols;
    private Command resultsCommand;

    public CreateUpdateProcedureCommand() {
    }

    public CreateUpdateProcedureCommand(Block block) {
        this.block = block;
    }

    public int getType() {
        return 7;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    public void setUserCommand(Command command) {
        this.userCommand = command;
    }

    public Command getUserCommand() {
        return this.userCommand;
    }

    public void setSymbolMap(Map symbolMap) {
        this.symbolMap = symbolMap;
    }

    public Map getSymbolMap() {
        return this.symbolMap;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        CreateUpdateProcedureCommand copy = new CreateUpdateProcedureCommand();
        if (this.tempGroupIDs != null) {
            copy.tempGroupIDs = new HashMap(this.tempGroupIDs);
        }
        copy.setIsResolved(this.isResolved());
        if (this.getOption() != null) {
            copy.setOption((Option)this.getOption().clone());
        }
        if (this.block != null) {
            copy.setBlock((Block)this.block.clone());
        }
        if (this.getSymbolMap() != null) {
            copy.setSymbolMap(new HashMap(this.getSymbolMap()));
        }
        if (this.getUserCommand() != null) {
            copy.setUserCommand((Command)this.getUserCommand().clone());
        }
        if (this.getVirtualGroup() != null) {
            copy.setVirtualGroup((GroupSymbol)this.getVirtualGroup().clone());
        }
        copy.setUpdateProcedure(this.isUpdateProcedure());
        if (this.projectedSymbols != null) {
            copy.setProjectedSymbols(new ArrayList(this.projectedSymbols));
        }
        if (this.getResultsCommand() != null) {
            copy.setResultsCommand((Command)this.getResultsCommand().clone());
        }
        if (this.parentProjectSymbols != null) {
            copy.parentProjectSymbols = new ArrayList(this.parentProjectSymbols);
        }
        this.copyMetadataState(copy);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return EquivalenceUtil.areEqual(this.getBlock(), ((CreateUpdateProcedureCommand)obj).getBlock());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, this.getBlock());
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public List getProjectedSymbols() {
        if (this.projectedSymbols != null) {
            return this.projectedSymbols;
        }
        if (!this.isUpdateProcedure) {
            if (this.resultsCommand == null) {
                return Collections.EMPTY_LIST;
            }
            this.setProjectedSymbols(this.resultsCommand.getProjectedSymbols());
            return this.projectedSymbols;
        }
        this.projectedSymbols = Command.getUpdateCommandSymbol();
        return this.projectedSymbols;
    }

    public boolean isUpdateProcedure() {
        return this.isUpdateProcedure;
    }

    public void setUpdateProcedure(boolean isUpdateProcedure) {
        this.isUpdateProcedure = isUpdateProcedure;
    }

    public void setProjectedSymbols(List projSymbols) {
        this.projectedSymbols = projSymbols;
    }

    public Command getResultsCommand() {
        return this.resultsCommand;
    }

    public void setResultsCommand(Command command) {
        this.resultsCommand = command;
    }

    public boolean areResultsCachable() {
        return !this.isUpdateProcedure();
    }

    public int updatingModelCount(QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        return this.getSubCommandsUpdatingModelCount(metadata);
    }

    public List getParentProjectSymbols() {
        return this.parentProjectSymbols;
    }

    public void setParentProjectSymbols(List parentProjectSymbols) {
        this.parentProjectSymbols = parentProjectSymbols;
    }
}

