/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.exception;

import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.exception.SourceFailureDetails;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class PartialResultsException
extends MetaMatrixProcessingException {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String EMPTY_STR = "";
    private Collection failureList = new ArrayList();

    public PartialResultsException() {
        super(EMPTY_STR);
    }

    public void addSourceFailure(SourceFailureDetails details) {
        this.failureList.add(details);
    }

    public Collection getSourceFailureDetails() {
        return this.failureList;
    }

    public String getMessage() {
        Iterator failureIter = this.failureList.iterator();
        StringBuffer warningBuf = new StringBuffer(DQPPlugin.Util.getString("PartialResultsException.WARNING__There_were_failures_while_processing_the_query"));
        warningBuf.append(NEW_LINE);
        while (failureIter.hasNext()) {
            SourceFailureDetails details = (SourceFailureDetails)failureIter.next();
            warningBuf.append(details);
            warningBuf.append(NEW_LINE);
        }
        return warningBuf.toString();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.failureList = (Collection)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.failureList);
    }
}

