/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.soap;

import com.metamatrix.connector.xml.base.Executor;
import com.metamatrix.connector.xml.base.XMLExecution;
import com.metamatrix.connector.xml.http.HTTPConnectorState;
import com.metamatrix.connector.xml.soap.SOAPExecutor;
import com.metamatrix.data.exception.ConnectorException;
import java.util.Properties;

public class SOAPConnectorState
extends HTTPConnectorState {
    private static final String SOAPACTION_PROPERTY_NAME = "SOAPAction";
    private static final String ENCODING_STYLE_PROPERTY_NAME = "EncodingStyle";
    private static final String RPC_ENC_STYLE = "RPC - Encoded";
    private static final String RPC_LITERAL_STYLE = "RPC - Literal";
    private static final String DOC_ENCODED_STYLE = "Document - Encoded";
    private static final String DOC_LITERAL_STYLE = "Document - Literal";
    private static final String USE_BASIC_AUTH_PROPERTY_NAME = "UseBasicAuth";
    private static final String BASIC_AUTH_USER_PROPERTY_NAME = "BasicAuthUserName";
    private static final String BASIC_AUTH_PASSWORD_PROPERTY_NAME = "BasicAuthPassword";
    private boolean m_encoded;
    private boolean m_RPC;
    private String m_soapAction;
    private boolean m_useBasicAuth;
    private String m_authUser;
    private String m_authPassword;

    public SOAPConnectorState() {
        this.setEncoded(true);
        this.setRPC(true);
        this.setSoapAction(new String());
        this.setUseBasicAuth(false);
        this.setAuthUser(new String());
        this.setAuthPassword(new String());
    }

    public SOAPConnectorState(Properties props) throws ConnectorException {
        this();
        this.setState(props);
    }

    public void setState(Properties props) throws ConnectorException {
        String enc;
        super.setState(props);
        String action = props.getProperty(SOAPACTION_PROPERTY_NAME);
        if (action != null) {
            this.setSoapAction(action);
        }
        if ((enc = props.getProperty(ENCODING_STYLE_PROPERTY_NAME)).equalsIgnoreCase(RPC_ENC_STYLE) || enc.equalsIgnoreCase(RPC_LITERAL_STYLE)) {
            this.setRPC(true);
        } else {
            this.setRPC(false);
        }
        if (enc.equalsIgnoreCase(RPC_ENC_STYLE) || enc.equalsIgnoreCase(DOC_ENCODED_STYLE)) {
            this.setEncoded(true);
        } else {
            this.setEncoded(false);
        }
        String strUseAuth = props.getProperty(USE_BASIC_AUTH_PROPERTY_NAME);
        boolean useAuth = Boolean.valueOf(strUseAuth);
        this.setUseBasicAuth(useAuth);
        if (useAuth) {
            String user = props.getProperty(BASIC_AUTH_USER_PROPERTY_NAME);
            this.setAuthUser(user);
            String pwd = props.getProperty(BASIC_AUTH_PASSWORD_PROPERTY_NAME);
            this.setAuthPassword(pwd);
        }
    }

    public Properties getState() {
        Properties props = super.getState();
        props.setProperty(SOAPACTION_PROPERTY_NAME, this.getSoapAction());
        String style = null;
        style = this.isRPC() ? (this.isEncoded() ? RPC_ENC_STYLE : RPC_LITERAL_STYLE) : (this.isEncoded() ? DOC_ENCODED_STYLE : DOC_LITERAL_STYLE);
        props.setProperty(ENCODING_STYLE_PROPERTY_NAME, style);
        props.setProperty(USE_BASIC_AUTH_PROPERTY_NAME, Boolean.toString(this.isUseBasicAuth()));
        props.setProperty(BASIC_AUTH_USER_PROPERTY_NAME, this.getAuthUser());
        props.setProperty(BASIC_AUTH_PASSWORD_PROPERTY_NAME, this.getAuthPassword());
        return props;
    }

    public Executor makeExecutor(XMLExecution info) {
        return new SOAPExecutor(this, info);
    }

    public void setEncoded(boolean encoded) {
        this.m_encoded = encoded;
    }

    public boolean isEncoded() {
        return this.m_encoded;
    }

    public void setRPC(boolean rpc) {
        this.m_RPC = rpc;
    }

    public boolean isRPC() {
        return this.m_RPC;
    }

    public void setSoapAction(String soapAction) {
        this.m_soapAction = soapAction;
    }

    public String getSoapAction() {
        return this.m_soapAction;
    }

    public void setUseBasicAuth(boolean basicAuth) {
        this.m_useBasicAuth = basicAuth;
    }

    public boolean isUseBasicAuth() {
        return this.m_useBasicAuth;
    }

    public void setAuthUser(String authUser) {
        this.m_authUser = authUser;
    }

    public String getAuthUser() {
        return this.m_authUser;
    }

    public void setAuthPassword(String authPassword) {
        this.m_authPassword = authPassword;
    }

    public String getAuthPassword() {
        return this.m_authPassword;
    }
}

