/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2ImplResultSet;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAParameter;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.jdbc.db2.drda.DRDAQueryStatementRequest;
import com.metamatrix.util.UtilDataConversions;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilTransliterator;
import java.sql.SQLException;

public class DB2ImplClob
extends BaseImplClob {
    private static String footprint = "$Revision:   3.12.1.0  $";
    private boolean isEmulatedClob = false;
    public UtilPagedTempBuffer clobData;
    private byte[] locator;
    public UtilTransliterator clobTransliterator;
    DB2ImplConnection con;
    DB2ImplResultSet results;

    public DB2ImplClob(byte[] byArray, DB2ImplConnection dB2ImplConnection, UtilTransliterator utilTransliterator) throws SQLException {
        super(dB2ImplConnection.exceptions);
        this.locator = byArray;
        this.con = dB2ImplConnection;
        this.clobTransliterator = utilTransliterator;
        this.initClobDataUsingLocator();
    }

    public DB2ImplClob(DB2ImplConnection dB2ImplConnection, UtilPagedTempBuffer utilPagedTempBuffer) throws SQLException {
        super(dB2ImplConnection.exceptions);
        this.locator = null;
        this.con = dB2ImplConnection;
        this.clobData = utilPagedTempBuffer;
    }

    private void initClobDataUsingLocator() throws SQLException {
        String string = "SELECT CAST (? AS CLOB(2147483647)) FROM SYSIBM.SYSDUMMY1 FOR FETCH ONLY";
        DRDAByteOrderedDataReader dRDAByteOrderedDataReader = this.con.comm.createReader();
        dRDAByteOrderedDataReader.interpretAsBigEndian = true;
        BaseParameters baseParameters = new BaseParameters(1, this.con.exceptions, (BaseConnection)this.con.db2Connection);
        BaseParameter baseParameter = new BaseParameter(2005, 2, (Object)this.locator, (BaseConnection)this.con.db2Connection);
        baseParameters.set(1, 1, baseParameter);
        DRDAParameter dRDAParameter = new DRDAParameter(baseParameter, 26, 4, 0, false);
        dRDAParameter.isLobLocator = true;
        int n = this.con.comm.packageManager.getAvailableSectionNumber(false, false);
        String string2 = this.con.comm.packageManager.getPackageName(false);
        DRDAPkgNamCsn dRDAPkgNamCsn = new DRDAPkgNamCsn(this.con.databaseName, this.con.collectionId, string2, n, null);
        DRDAQueryStatementRequest dRDAQueryStatementRequest = new DRDAQueryStatementRequest(this.con, this.con.comm, dRDAByteOrderedDataReader, this.con.dataWriter, dRDAPkgNamCsn);
        dRDAQueryStatementRequest.setParameters(baseParameters);
        dRDAQueryStatementRequest.chainCommit = false;
        dRDAQueryStatementRequest.lobLocParam = dRDAParameter;
        dRDAQueryStatementRequest.writePRPSQLSTT(string, true, false);
        dRDAQueryStatementRequest.openQuery(this.con.warnings, false, (short)2);
        dRDAQueryStatementRequest.submitRequest();
        dRDAQueryStatementRequest.processMode = 1;
        dRDAQueryStatementRequest.processReply(this.con.warnings);
        this.results = new DB2ImplResultSet(dRDAQueryStatementRequest, this.con.comm);
        this.results.request.useOUTOVRlob = false;
        this.results.fetchAtPosition(0);
        long l = this.results.getData(1, 5).getLong(this.con.exceptions);
        if (l == 0L) {
            this.clobData = new UtilPagedTempBuffer();
        } else {
            this.results.request.discardReplyBytes();
            this.results.request.continueQuery(this.con.warnings);
            dRDAQueryStatementRequest.submitRequest();
            dRDAQueryStatementRequest.processReply(this.con.warnings);
            this.clobData = dRDAQueryStatementRequest.lobBuffer;
        }
        dRDAQueryStatementRequest.discardReplyBytes();
        this.results.close();
        this.con.comm.packageManager.markThisSectionNumber(dRDAPkgNamCsn, -1);
    }

    public void setIsEmulatedClob(boolean bl) {
        this.isEmulatedClob = bl;
    }

    public boolean getIsEmulatedClob() {
        return this.isEmulatedClob;
    }

    public UtilPagedTempBuffer getData() {
        return this.clobData;
    }

    public long getLength() throws SQLException {
        return this.clobData.getSize() / 2L;
    }

    public void close() throws SQLException {
        try {
            this.clobData.truncate(true);
        }
        catch (UtilException utilException) {
            throw this.con.exceptions.getException((Exception)((Object)utilException));
        }
        this.clobData = null;
    }

    public int readData(char[] cArray, int n, long l, int n2) throws SQLException {
        try {
            byte[] byArray = new byte[n2 * 2];
            int n3 = this.clobData.read((l - 1L) * 2L, byArray, 0, n2 * 2);
            UtilDataConversions.ByteArrayToUCS2CharArray((byte[])byArray, (int)0, (char[])cArray, (int)n, (int)n3);
            return n3 / 2;
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
    }

    public int writeData(long l, char[] cArray, int n, int n2) throws SQLException {
        try {
            byte[] byArray = UtilDataConversions.UCS2CharArrayToByteArray((char[])cArray, (int)n, (int)n2);
            return this.clobData.write((l - 1L) * 2L, byArray, 0, byArray.length) / 2;
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public boolean supportsSearch() {
        return true;
    }

    public long find(String string, long l) throws SQLException {
        long l2 = this.getLength() * 2L;
        long l3 = (l - 1L) * 2L;
        long l4 = string.length();
        long l5 = 0L;
        byte[] byArray = new byte[2];
        long l6 = l3;
        try {
            while (l5 < l4) {
                if (l3 == l2) {
                    return -1L;
                }
                char c = string.charAt((int)l5++);
                this.clobData.read(l3, byArray, 0, 2);
                l3 += 2L;
                char c2 = (char)(((byArray[0] & 0xFF) << 8) + ((byArray[1] & 0xFF) << 0));
                if (c == c2) continue;
                l5 = 0L;
                c = string.charAt((int)l5++);
                l3 = l6 + 2L;
                do {
                    if (l3 >= l2) {
                        return -1L;
                    }
                    this.clobData.read(l3, byArray, 0, 2);
                    l3 += 2L;
                } while (c != (c2 = (char)(((byArray[0] & 0xFF) << 8) + ((byArray[1] & 0xFF) << 0))));
                l6 = l3 - 2L;
            }
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
        return l6 / 2L + 1L;
    }

    public void truncate(long l) throws SQLException {
        try {
            this.clobData.truncate(l * 2L);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException));
        }
    }
}

