/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.admin.apiimpl;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.admin.apiimpl.AdminHelper;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.SessionToken;

public class AdminAPIHelper {
    private static AdminHelper adminHelper;

    private static synchronized AdminHelper getAdminHelper() {
        if (adminHelper == null) {
            AdminAPIHelper.initialize();
        }
        return adminHelper;
    }

    private static synchronized void initialize() {
        try {
            adminHelper = new AdminHelper();
        }
        catch (MetaMatrixComponentException e) {
            throw new RuntimeException(PlatformPlugin.Util.getString("ERR.014.001.0004", (Object)e.getMessage()));
        }
    }

    public static void checkForRequiredRole(SessionToken adminToken, String roleName, String methodSignature) throws AuthorizationException, ComponentNotFoundException {
        AdminAPIHelper.getAdminHelper().checkForRequiredRole(adminToken, roleName, methodSignature);
    }

    public static SessionToken validateSession(MetaMatrixSessionID sessionID) throws InvalidSessionException, ComponentNotFoundException {
        return AdminAPIHelper.getAdminHelper().validateSession(sessionID);
    }
}

