/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseBlobInputStream;
import com.metamatrix.jdbc.base.BaseBlobOutputStream;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.jdbc.base.BaseImplBlobChunked;
import com.metamatrix.jdbc.base.BaseImplBlobSearchable;
import com.metamatrix.jdbc.base.BaseImplBlobService;
import com.metamatrix.jdbc.base.BaseInputStreamWrapper;
import com.metamatrix.util.UtilDebug;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BaseBlob
implements Blob {
    private static String footprint = "$Revision:   3.11.2.0  $";
    private BaseImplBlob implBlob;
    private InputStream lastInputStream;
    private OutputStream lastOutputStream;
    private boolean deferSearchEmulation;
    BaseConnection connection;
    Object synchronizer;
    BaseExceptions exceptions;

    public BaseBlob(BaseImplBlob baseImplBlob, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        this(baseImplBlob, baseConnection, true, baseExceptions);
        this.connection = baseConnection;
        this.synchronizer = baseConnection != null ? baseConnection : this;
    }

    public BaseBlob(BaseImplBlob baseImplBlob, BaseConnection baseConnection, boolean bl, BaseExceptions baseExceptions) throws SQLException {
        UtilDebug.assert((String)"Must supply a native Blob implementation", (baseImplBlob != null ? 1 : 0) != 0);
        UtilDebug.assert((String)"Must supply a BaseExceptions object", (baseExceptions != null ? 1 : 0) != 0);
        this.implBlob = baseImplBlob;
        this.deferSearchEmulation = bl;
        this.exceptions = baseExceptions;
        this.lastInputStream = null;
        this.lastOutputStream = null;
        this.connection = baseConnection;
        this.synchronizer = baseConnection != null ? baseConnection : this;
        this.chainInBlobServices();
    }

    public BaseImplBlob getNativeImplBlob() {
        BaseImplBlob baseImplBlob = this.implBlob;
        while (baseImplBlob instanceof BaseImplBlobService) {
            baseImplBlob = ((BaseImplBlobService)baseImplBlob).getChainedImplBlob();
        }
        return baseImplBlob;
    }

    void setConnection(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.synchronizer = baseConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.implBlob.getLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long l, int n) throws SQLException {
        if (l <= 0L || n < 0) {
            String[] stringArray = new String[]{"Blob.getBytes"};
            throw this.exceptions.getException(6069, stringArray);
        }
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            long l2 = this.length();
            if (l - 1L > l2) {
                throw this.exceptions.getException(6077);
            }
            if (l - 1L + (long)n > l2) {
                try {
                    n = new Long(l2 - (l - 1L)).intValue();
                }
                catch (Exception exception) {
                    this.exceptions.getException(6065);
                }
            }
            byte[] byArray = new byte[n];
            this.implBlob.readData(byArray, 0, l, n);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream() throws SQLException {
        BaseInputStreamWrapper baseInputStreamWrapper = null;
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseBlobInputStream baseBlobInputStream = new BaseBlobInputStream(this, this.implBlob, this.exceptions);
            baseBlobInputStream.closeImplBlobOnClose = this.implBlob.getCloseImplBlobOnBinaryStreamClose();
            BufferedInputStream bufferedInputStream = null;
            bufferedInputStream = (int)this.getNativeImplBlob().getMaxChunkSize() > 100 ? new BufferedInputStream(baseBlobInputStream, (int)this.getNativeImplBlob().getMaxChunkSize()) : new BufferedInputStream(baseBlobInputStream);
            long l = this.implBlob.getLength();
            baseInputStreamWrapper = new BaseInputStreamWrapper(bufferedInputStream, l, this.connection, this.exceptions);
            this.setLastInputStream(baseInputStreamWrapper);
            return this.lastInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(boolean bl) throws SQLException {
        BaseInputStreamWrapper baseInputStreamWrapper = null;
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseBlobInputStream baseBlobInputStream = new BaseBlobInputStream(this, this.implBlob, this.exceptions);
            baseBlobInputStream.closeImplBlobOnClose = bl;
            BufferedInputStream bufferedInputStream = null;
            bufferedInputStream = (int)this.getNativeImplBlob().getMaxChunkSize() > 100 ? new BufferedInputStream(baseBlobInputStream, (int)this.getNativeImplBlob().getMaxChunkSize()) : new BufferedInputStream(baseBlobInputStream);
            long l = this.implBlob.getLength();
            baseInputStreamWrapper = new BaseInputStreamWrapper(bufferedInputStream, l, this.connection, this.exceptions);
            this.setLastInputStream(baseInputStreamWrapper);
            return this.lastInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(byte[] byArray, long l) throws SQLException {
        if (byArray == null || l <= 0L) {
            String[] stringArray = new String[]{"Blob.position"};
            throw this.exceptions.getException(6069, stringArray);
        }
        if (l >= this.length()) {
            throw this.exceptions.getException(6077);
        }
        if (this.deferSearchEmulation) {
            this.deferSearchEmulation = false;
            this.chainInBlobServices();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.implBlob.find(byArray, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(Blob blob, long l) throws SQLException {
        if (blob == null || l <= 0L) {
            String[] stringArray = new String[]{"Blob.position"};
            throw this.exceptions.getException(6069, stringArray);
        }
        if (l >= this.length()) {
            throw this.exceptions.getException(6077);
        }
        if (this.deferSearchEmulation) {
            this.deferSearchEmulation = false;
            this.chainInBlobServices();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            int n;
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            try {
                n = new Long(blob.length()).intValue();
            }
            catch (Exception exception) {
                throw this.exceptions.getException(6064);
            }
            return this.implBlob.find(blob.getBytes(1L, n), l);
        }
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n2 == 0) {
                return 0;
            }
            if (l <= 0L || n < 0 || n + n2 > byArray.length) {
                String[] stringArray = new String[]{"setBytes"};
                throw this.exceptions.getException(6069, stringArray);
            }
            return this.implBlob.writeData(l, byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream setBinaryStream(long l) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (l <= 0L) {
                String[] stringArray = new String[]{"setBinaryStream"};
                throw this.exceptions.getException(6069, stringArray);
            }
            BaseBlobOutputStream baseBlobOutputStream = new BaseBlobOutputStream(this, this.implBlob, l, this.synchronizer, this.exceptions);
            this.setLastOutputStream(baseBlobOutputStream);
            return baseBlobOutputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long l) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (l < 0L || l > this.length()) {
                String[] stringArray = new String[]{"truncate"};
                throw this.exceptions.getException(6069, stringArray);
            }
            this.implBlob.truncate(l);
        }
    }

    private void close() throws SQLException {
        this.setLastInputStream(null);
        this.setLastOutputStream(null);
        this.implBlob.close();
    }

    private void chainInBlobServices() throws SQLException {
        int n = new Long(this.implBlob.getMaxChunkSize()).intValue();
        if (n > 0) {
            this.implBlob = new BaseImplBlobChunked(n, this.implBlob, this.exceptions);
        }
        if (!this.deferSearchEmulation && !this.implBlob.supportsSearch()) {
            this.implBlob = new BaseImplBlobSearchable(this.implBlob, this.exceptions);
        }
    }

    private void setLastInputStream(InputStream inputStream) {
        if (this.lastInputStream != null) {
            try {
                this.lastInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.lastInputStream = inputStream;
    }

    private void setLastOutputStream(OutputStream outputStream) {
        if (this.lastOutputStream != null) {
            try {
                this.lastOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.lastOutputStream = outputStream;
    }
}

