/**
 * 
 */
package org.mobicents.slee.container.component;

import java.util.List;


/**
 * @author martins
 *
 */
public interface SleeComponentWithUsageParametersInterface extends
		SleeComponent {

	/**
	 * Retrieves the usage parameters interface
	 * 
	 * @return
	 */
	public Class<?> getUsageParametersInterface();

	/**
	 * Sets the usage parameters interface
	 * 
	 * @param usageParametersInterface
	 */
	public void setUsageParametersInterface(Class<?> usageParametersInterface);

	/**
	 * Retrieves the concrete usage parameters class, generated by SLEE
	 * @return
	 */
	public Class<?> getUsageParametersConcreteClass();
	
	/**
	 * Sets the concrete usage parameters class, generated by SLEE
	 * @param usageParametersConcreteClass
	 */
	public void setUsageParametersConcreteClass(
			Class<?> usageParametersConcreteClass);
	
	/**
	 * Retrieves the concrete usage parameters mbean interface, generated by SLEE
	 * @return
	 */
	public Class<?> getUsageParametersMBeanConcreteInterface();
	
	/**
	 * Sets the concrete usage parameters mbean interface, generated by SLEE
	 * @param usageParametersMBeanConcreteInterface
	 */
	public void setUsageParametersMBeanConcreteInterface(
			Class<?> usageParametersMBeanConcreteInterface);
	
	/**
	 * Retrieves the concrete usage parameters mbean impl class, generated by SLEE
	 * @return
	 */
	public Class<?> getUsageParametersMBeanImplConcreteClass();
	
	/**
	 * Sets the concrete usage parameters mbean impl class, generated by SLEE
	 * @param usageParametersMBeanImplConcreteClass
	 */
	public void setUsageParametersMBeanImplConcreteClass(
			Class<?> usageParametersMBeanImplConcreteClass);
	
	/**
	 * Retrieves the concrete usage notification manager mbean interface, generated by SLEE
	 * @return
	 */
	public Class<?> getUsageNotificationManagerMBeanConcreteInterface();
	
	/**
	 * Sets the concrete usage notification manager mbean interface, generated by SLEE
	 * @param usageNotificationManagerMBeanConcreteInterface
	 */
	public void setUsageNotificationManagerMBeanConcreteInterface(
			Class<?> usageNotificationManagerMBeanConcreteInterface);
	
	/**
	 * Retrieves the concrete usage notification manager mbean impl class, generated by SLEE
	 * @return
	 */
	public Class<?> getUsageNotificationManagerMBeanImplConcreteClass();
	
	/**
	 * Sets the concrete usage notification manager mbean impl class, generated by SLEE
	 * @param usageNotificationManagerMBeanImplConcreteClass
	 */
	public void setUsageNotificationManagerMBeanImplConcreteClass(
			Class<?> usageNotificationManagerMBeanImplConcreteClass);

	/**
	 * 
	 * @return
	 */
	public List<UsageParameterDescriptor> getUsageParametersList();
}
