#############################################################
#
# rstatd
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
RSTATD_SOURCE:=rstatd.tar.gz
RSTATD_CAT:=zcat
endif

RSTATD_DIR:=$(BUILD_DIR)/rstatd
RSTATD_BINARY:=rstatd
RSTATD_TARGET_BINARY:=usr/sbin/rpc.rstatd

ifneq ($(USE_CVS),true)
rstatd-source: $(DL_DIR)/$(RSTATD_SOURCE)
else
rstatd-source:
endif

RSTATD_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d rstatd $(CVS_TAG) $(CVS_PREFIX)rstatd

rstatd-checkout:
	@$(RSTATD_CVSCO)

$(RSTATD_DIR)/.unpacked: $(DL_DIR)/$(RSTATD_SOURCE)
ifneq ($(USE_CVS),true)
	$(RSTATD_CAT) $(DL_DIR)/$(RSTATD_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(RSTATD_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(RSTATD_DIR)/
	touch $(RSTATD_DIR)/.unpacked

$(RSTATD_DIR)/.configured: $(RSTATD_DIR)/.unpacked
	(cd $(RSTATD_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS)  \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=$(STAGING_DIR)/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
	);
	touch  $(RSTATD_DIR)/.configured

$(RSTATD_DIR)/$(RSTATD_BINARY): $(RSTATD_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(RSTATD_DIR)

$(TARGET_DIR)/$(RSTATD_TARGET_BINARY): $(RSTATD_DIR)/$(RSTATD_BINARY)
	$(MAKE) \
		DESTDIR=$(TARGET_DIR) \
		-C $(RSTATD_DIR) \
		install
	$(STRIP) $(TARGET_DIR)/$(RSTATD_TARGET_BINARY) \
		$(TARGET_DIR)/usr/bin/rup \
		$(TARGET_DIR)/usr/bin/rsysinfo
	install -d $(DOC_DIR)/doc/rstatd
	@for f in COPYING README ; do \
		install -m0644 $(RSTATD_DIR)/$$f $(DOC_DIR)/doc/rstatd/$$f ;\
	done

rstatd: uclibc $(TARGET_DIR)/$(RSTATD_TARGET_BINARY)

rstatd-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(RSTATD_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/rstatd
	-$(MAKE) -C $(RSTATD_DIR) clean

rstatd-dirclean:
	rm -rf $(RSTATD_DIR)
endif

