/*
   (c) Copyright 2002-2003  Denis Oliver Kropp <dok@directfb.org>
   All rights reserved.

   XDirectFB is mainly based on XDarwin and
   also contains some KDrive, XFree and XWin code.
*/
/*
 * Id: kkeymap.h,v 1.1 1999/11/02 03:54:46 keithp Exp $
 *
 * Copyright  1999 Keith Packard
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Keith Packard not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Keith Packard makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
/* $XFree86: xc/programs/Xserver/hw/kdrive/kkeymap.h,v 1.3 2000/09/26 04:29:54 keithp Exp $ */
/*
 *  All global variables and functions pertaining to keyboard key mapping
 *  live in this header file.
 */

#ifndef _DIRECTFBKEYBOARD_H
#define _DIRECTFBKEYBOARD_H

#include "input.h"

/* Offset of MIN_SCANCODE to 8 (X minimum scancode value) */
#define DIRECTFB_KEY_OFFSET	(8 - directfbMinScanCode)

#define DIRECTFB_MIN_KEYCODE	8
#define DIRECTFB_MAX_KEYCODE	254
#define DIRECTFB_MAX_WIDTH	4
#define DIRECTFB_MAX_LENGTH	(DIRECTFB_MAX_KEYCODE - DIRECTFB_MIN_KEYCODE + 1)

extern int		directfbMinScanCode;
extern int		directfbMaxScanCode;
extern int		directfbMinKeyCode;
extern int		directfbMaxKeyCode;
extern int		directfbAsciiOffset;
extern int		directfbMinAscii;
extern int		directfbMaxAscii;
extern int		directfbKeymapWidth;

extern KeySym		directfbKeymap[DIRECTFB_MAX_LENGTH * DIRECTFB_MAX_WIDTH];

extern CARD8		directfbModMap[MAP_LENGTH];
    
extern KeySymsRec	directfbKeySyms;

typedef struct {
    KeySym  modsym;
    int	    modbit;
} DirectFBKeySymModsRec;


void XDirectFBKeyboardInit(DeviceIntPtr pDev);

#endif /* _DIRECTFBKEYBOARD_H */
