.TH XvGetStill 3X  __vendorversion__
.\" $XFree86: xc/doc/man/Xv/XvGetStill.man,v 1.4 1999/03/02 11:49:14 dawes Exp $
.SH Name
XvGetStill \- capture a single frame of video from a drawable
.\"
.SH Syntax
.B include "Xvlib.h"
.sp 1l
.B XvGetStill(\fIdpy, port, d, gc, vx, vy, vw, vh, dx, dy, dw, dh\fP)
.sp 1l
.B register 
.I Display 
.I *dpy;
.br
.B XvPortID 
.I port;
.br
.B Drawable 
.I d;
.br
.B GC 
.I gc;
.br
.B int 
.I vx, 
.I vy, 
.I dx, 
.I dy;
.br
.B unsigned int 
.I vw, 
.I vh;
.br
.B unsigned int 
.I dw, 
.I dh;
.sp 1l
.\"
.SH Arguments
.\"
.IP \fIdpy\fR 15
Specifies the display screen on which the
Xv Server is to accept requests from Xv clients.  If the
display option is not specified, Xv uses the display screen
specified by your DISPLAY environment variable.  The display
option has the format hostname:number.  Using two colons
(::) instead of one (:) indicates that DECnet is to be used
for transport.
.IP \fIport\fR 15
Defines the port to which the still is outputed.
.IP \fId\fR 15
Defines the drawable from which the still is to be captured.
Pixmaps are currently not supported.
.IP \fIgc\fR 15
Defines the graphical context.  GC components are: 
.I subwindow-mode, 
.I clip-x-origin, 
.I clip-y-origin,
and 
.I clip-mask.
.IP \fIvx,vy,vw,vh\fR 15
Define the location and size of the destination video region 
into which the still is to be written.  \fIvx\fP and \fIvy\fP define the 
.I x and
.I y
coordinates of the upper-left corner of the video region; 
.I vw and
.I vh
define the width and height, in pixels, of the video region.
.IP \fIdx,dy,dw,dh\fR 15
Define the location and size of the source drawable from which the
still image is to be captured.  
.I dx and
.I dy 
define the 
.I x and
.I y 
coordinates of the upper-left corner of the drawable region; 
.I dw and 
.I dh 
define the width and height, in pixels, of the drawable region.
.\"
.SH Description
.\"
.PN XvGetStill 
captures a single frame of video from a drawable.  The 
position and size of the destination (video) rectangle is specified by \fIvx,
vy, vw\fR, and \fIvh\fR.  The position and size of the 
source (drawable) rectangle is
specified by \fIdx, dy, dw\fR, and \fIdh\fR.  
.PP
Drawable data is clipped to the bounds of the drawable, scaled to the
requested video region size (or the closest size supported) and
clipped to the bounds of the video encoding.  The contents of any region
not updated with drawable data is undefined.
.PP
./" If the still is successfully captured an XvVideoNotify event with
./" detail XvStill is generated for the drawable.
./" [mhs]: Not in this universe
If the port is grabbed
by another client, this request is ignored, and an XvVideoNotify event
with detail XvBusy is generated for the drawable.
.SH Returned Values
.IP [Success] 8
Returned if XvGetStill(3X) completed successfully.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if XvGetStill(3X) failed to allocate memory to process
the request.
.SH Diagnostics
.IP [XvBadPort] 8
Generated if the requested port does not exist.
.IP [BadDrawable] 8
Generated if the requested drawable does not exist.
.IP [BadGC] 8
Generated if the requested graphics context does not exist.
.IP [BadAlloc] 8
Generated if there were insufficient resources to process the request.
.\"
.SH See Also
.\"
XvPutStill(3X), XvGetVideo(3X), XvPutVideo(3X), XvVideoNotify(3X)
.br




