/* Function descriptors. FR-V version.
   Copyright (C) 2004 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#include <sysdeps/generic/dl-fptr.h>

#ifndef dl_frv_fptr_h
#define dl_frv_fptr_h

#ifdef USE_TLS
struct tlsdesc {
  size_t modidoff;
  size_t modoff;
  void *gp;
  size_t gen_count;
} __attribute__((__aligned__(8)));

# ifdef SHARED
void *_dl_make_tlsdesc (struct link_map *map, size_t modoff, void *gp);
# endif
#endif

#endif /* !dl_frv_fptr_h */
