/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.Reapable;
import com.arjuna.ats.arjuna.coordinator.SynchronizationRecord;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.coordinator.TxStats;
import com.arjuna.ats.arjuna.logging.tsLogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;

public class TwoPhaseCoordinator
extends BasicAction
implements Reapable {
    private SortedSet _synchs;
    private SynchronizationRecord _currentRecord;
    private Throwable _deferredThrowable;
    private Object _syncLock = new Object();
    private boolean _beforeCalled = false;
    private boolean _afterCalled = false;

    public TwoPhaseCoordinator() {
    }

    public TwoPhaseCoordinator(Uid id) {
        super(id);
    }

    public int start() {
        return this.start(BasicAction.Current());
    }

    public int start(BasicAction parentAction) {
        if (parentAction != null) {
            parentAction.addChildAction(this);
        }
        return super.Begin(parentAction);
    }

    public int end(boolean report_heuristics) {
        if (this.parent() != null) {
            this.parent().removeChildAction(this);
        }
        boolean canEnd = true;
        if (this.status() != 3 || TxControl.isBeforeCompletionWhenRollbackOnly()) {
            canEnd = this.beforeCompletion();
        }
        int outcome = canEnd ? super.End(report_heuristics) : super.Abort();
        this.afterCompletion(outcome);
        return outcome;
    }

    @Override
    public int cancel() {
        if (TxControl.enableStatistics) {
            TxStats.incrementApplicationRollbacks();
        }
        if (this.parent() != null) {
            this.parent().removeChildAction(this);
        }
        int outcome = super.Abort();
        this.afterCompletion(outcome);
        return outcome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSynchronization(SynchronizationRecord sr) {
        if (sr == null) {
            return 3;
        }
        int result = 3;
        if (this.parent() != null) {
            return 3;
        }
        switch (this.status()) {
            case 0: {
                SynchronizationRecord c;
                Object object = this;
                synchronized (object) {
                    if (this._synchs == null) {
                        this._synchs = new TreeSet();
                    }
                }
                if (sr instanceof Comparable && this._currentRecord != null && (c = sr).compareTo(this._currentRecord) != 1) {
                    return 3;
                }
                object = this._synchs;
                synchronized (object) {
                    if (this._synchs.add(sr)) {
                        result = 2;
                    }
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public boolean running() {
        return this.status() == 0 || this.status() == 3;
    }

    @Override
    public String type() {
        return "/StateManager/BasicAction/AtomicAction/TwoPhaseCoordinator";
    }

    public Throwable getDeferredThrowable() {
        return this._deferredThrowable;
    }

    protected TwoPhaseCoordinator(int at) {
        super(at);
    }

    protected TwoPhaseCoordinator(Uid u, int at) {
        super(u, at);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean beforeCompletion() {
        boolean problem = false;
        Object object = this._syncLock;
        synchronized (object) {
            if (!this._beforeCalled) {
                this._beforeCalled = true;
                if (this._synchs != null) {
                    SynchronizationRecord[] copiedSynchs;
                    int lastIndexProcessed = -1;
                    SortedSet sortedSet = this._synchs;
                    synchronized (sortedSet) {
                        copiedSynchs = this._synchs.toArray(new SynchronizationRecord[0]);
                    }
                    while (lastIndexProcessed < this._synchs.size() - 1 && !problem) {
                        sortedSet = this._synchs;
                        synchronized (sortedSet) {
                            if (copiedSynchs.length != this._synchs.size()) {
                                copiedSynchs = this._synchs.toArray(new SynchronizationRecord[0]);
                            }
                        }
                        this._currentRecord = copiedSynchs[++lastIndexProcessed];
                        try {
                            problem = !this._currentRecord.beforeCompletion();
                        }
                        catch (Exception ex) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_2", new Object[]{this._currentRecord}, (Throwable)ex);
                            if (this._deferredThrowable == null) {
                                this._deferredThrowable = ex;
                            }
                            problem = true;
                        }
                        catch (Error er) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_2", new Object[]{this._currentRecord}, (Throwable)er);
                            if (this._deferredThrowable == null) {
                                this._deferredThrowable = er;
                            }
                            problem = true;
                        }
                    }
                    if (problem && !this.preventCommit()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_1");
                    }
                }
            }
        }
        return !problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean afterCompletion(int myStatus) {
        if (myStatus == 0) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_3");
            return false;
        }
        boolean problem = false;
        Object object = this._syncLock;
        synchronized (object) {
            if (!this._afterCalled) {
                this._afterCalled = true;
                if (this._synchs != null) {
                    Stack stack = new Stack();
                    Iterator iterator = this._synchs.iterator();
                    while (iterator.hasNext()) {
                        stack.push(iterator.next());
                    }
                    iterator = stack.iterator();
                    while (!stack.isEmpty()) {
                        SynchronizationRecord record = (SynchronizationRecord)stack.pop();
                        try {
                            if (record.afterCompletion(myStatus)) continue;
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_4", new Object[]{record});
                            problem = true;
                        }
                        catch (Exception ex) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_4a", new Object[]{record, ex});
                            problem = true;
                        }
                        catch (Error er) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator_4b", new Object[]{record, er});
                            problem = true;
                        }
                    }
                    SortedSet sortedSet = this._synchs;
                    synchronized (sortedSet) {
                        this._synchs.clear();
                    }
                }
            }
        }
        return !problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Uid, String> getSynchronizations() {
        HashMap<Uid, String> synchs = new HashMap<Uid, String>();
        TwoPhaseCoordinator twoPhaseCoordinator = this;
        synchronized (twoPhaseCoordinator) {
            if (this._synchs != null) {
                for (Object _synch : this._synchs) {
                    SynchronizationRecord synch = (SynchronizationRecord)_synch;
                    synchs.put(synch.get_uid(), synch.toString());
                }
            }
        }
        return synchs;
    }
}

