/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.injection.resolvers;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.jboss.wsf.common.injection.resolvers.AbstractReferenceResolver;

public final class ResourceReferenceResolver
extends AbstractReferenceResolver<Resource> {
    public ResourceReferenceResolver() {
        super(Resource.class);
    }

    @Override
    protected String resolveField(Field field) {
        String fallBackName = field.getName();
        String resourceName = field.getAnnotation(Resource.class).name();
        return ResourceReferenceResolver.getName(resourceName, fallBackName);
    }

    @Override
    protected String resolveMethod(Method method) {
        String fallBackName = ResourceReferenceResolver.convertToBeanName(method.getName());
        String resourceName = method.getAnnotation(Resource.class).name();
        return ResourceReferenceResolver.getName(resourceName, fallBackName);
    }

    private static String getName(String resourceName, String fallBackName) {
        return resourceName.length() > 0 ? resourceName : fallBackName;
    }

    private static String convertToBeanName(String methodName) {
        return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
    }
}

