/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.distdiff;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.zip.CRC32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileComparator
implements Comparator<File> {
    @Override
    public int compare(File left, File right) {
        return (int)(this.getCRC32(left) - this.getCRC32(right));
    }

    private long getCRC32(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            CRC32 crc = new CRC32();
            byte[] buffer = new byte[8192];
            while (-1 != fis.read(buffer)) {
                crc.update(buffer);
            }
            fis.close();
            return crc.getValue();
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file:" + file.getPath(), e);
        }
    }
}

