/*
 *    The sound core exports the following symbols to the rest of
 *      modulespace.
 *
 *      (C) Copyright 1997      Alan Cox, Licensed under the GNU GPL
 */

#include <linux/module.h>
#include "sound_config.h"
#define _MIDI_SYNTH_C_
#include "midi_synth.h"
#include <linux/notifier.h>
#include "sound_firmware.h"

extern struct notifier_block *sound_locker;
extern void sound_notifier_chain_register(struct notifier_block *);


struct symbol_table sound_symbols = {
#include <linux/symtab_begin.h>
	X(mixer_devs),
	X(audio_devs),
	X(num_mixers),
	X(num_audiodevs),

	X(note_to_freq),
	X(compute_finetune),
	X(seq_copy_to_input),
	X(sequencer_init),
	X(sequencer_timer),

	X(sound_install_audiodrv),
	X(sound_install_mixer),
	X(sound_alloc_dma),
	X(sound_free_dma),
	X(snd_set_irq_handler),
	X(snd_release_irq),
	X(sound_alloc_audiodev),
	X(sound_alloc_mididev),
	X(sound_alloc_mixerdev),
	X(sound_alloc_timerdev),
	X(sound_alloc_synthdev),
	X(sound_mem_blocks),
	X(sound_mem_sizes),
	X(sound_nblocks),
	X(sound_unload_audiodev),
	X(sound_unload_mididev),
	X(sound_unload_mixerdev),
	X(sound_unload_timerdev),
	X(sound_unload_synthdev),

	X(load_mixer_volumes),

	X(DMAbuf_start_dma),
	X(DMAbuf_open_dma),
	X(DMAbuf_close_dma),
	X(DMAbuf_inputintr),
	X(DMAbuf_outputintr),
	X(dma_ioctl),

	X(conf_printf),
	X(conf_printf2),

	X(sound_timer_init),
	X(sound_timer_interrupt),
	X(sound_timer_syncinterval),

/* Locking */
	X(sound_locker),
	X(sound_notifier_chain_register),

/* MIDI symbols */
	X(midi_devs),
	X(num_midis),
	X(synth_devs),
	X(num_synths),

	X(do_midi_msg),
	X(midi_synth_open),
	X(midi_synth_close),
	X(midi_synth_ioctl),
	X(midi_synth_kill_note),
	X(midi_synth_start_note),
	X(midi_synth_set_instr),
	X(midi_synth_reset),
	X(midi_synth_hw_control),
	X(midi_synth_aftertouch),
	X(midi_synth_controller),
	X(midi_synth_panning),
	X(midi_synth_setup_voice),
	X(midi_synth_send_sysex),
	X(midi_synth_bender),
	X(midi_synth_load_patch),

#include <linux/symtab_end.h>
};
