/* DB: Utility Record List View
 * Copyright (C) 1998  by Tom Dyas (tdyas@vger.rutgers.edu)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "enum.h"
#include "db.h"

static FieldPtr
GetFocusedField(void)
{
    FormPtr form;
    Word focus;
    FormObjectKind objType;

    form = FrmGetActiveForm();
    focus = FrmGetFocus(form);
    if (focus == noFocus)
	return NULL;

    objType = FrmGetObjectType(form, focus);
    if (objType == frmFieldObj)
	return FrmGetObjectPtr(form, focus);
    else if (objType == frmTableObj)
	return TblGetCurrentField(FrmGetObjectPtr(form, focus));
    else
	return NULL;
}

Boolean
HandleCommonMenuEvent(Word menuitemID)
{
    FieldPtr fld;

    if (menuitemID == menuitemID_KeyboardDialog) {
	SysKeyboardDialog(kbdDefault);
	return true;
    } else if (menuitemID == menuitemID_GraffitiHelp) {
	SysGraffitiReferenceDialog(referenceDefault);
	return true;
    } else {
	fld = GetFocusedField();
	if (!fld)
	    return false;

	switch (menuitemID) {
	case menuitemID_Undo:
	    FldUndo(fld);
	    break;
	case menuitemID_Cut:
	    FldCut(fld);
	    break;
	case menuitemID_Copy:
	    FldCopy(fld);
	    break;
	case menuitemID_Paste:
	    FldPaste(fld);
	    break;
	case menuitemID_SelectAll:
	    FldSetSelection(fld, 0, FldGetTextLength(fld));
	    break;
	default:
	    return false;
	}
	return true;
    }
}
