/* projects.c generated by valac 0.17.3.8-fd35, the Vala compiler
 * generated from projects.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
typedef struct _ProjectsPrivate ProjectsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_markup_parse_context_free0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))

#define TYPE_LATEXILA (latexila_get_type ())
#define LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA, Latexila))
#define LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA, LatexilaClass))
#define IS_LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA))
#define IS_LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA))
#define LATEXILA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA, LatexilaClass))

typedef struct _Latexila Latexila;
typedef struct _LatexilaClass LatexilaClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _ParamSpecProjects ParamSpecProjects;

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Projects {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ProjectsPrivate * priv;
};

struct _ProjectsClass {
	GTypeClass parent_class;
	void (*finalize) (Projects *self);
};

struct _ProjectsPrivate {
	GeeLinkedList* projects;
	gboolean modified;
};

struct _ParamSpecProjects {
	GParamSpec parent_instance;
};


static gpointer projects_parent_class = NULL;
static Projects* projects_instance;
static Projects* projects_instance = NULL;

GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
#define PROJECTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROJECTS, ProjectsPrivate))
enum  {
	PROJECTS_DUMMY_PROPERTY
};
static Projects* projects_new (void);
static Projects* projects_construct (GType object_type);
static GFile* projects_get_xml_file (Projects* self);
gchar* utils_load_file (GFile* file);
static void projects_parser_start (Projects* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _projects_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
static void projects_update_all_documents (Projects* self);
static void projects_update_all_menus (Projects* self);
Projects* projects_get_default (void);
Project* projects_get (Projects* self, gint id);
GeeIterator* projects_iterator (Projects* self);
GType latexila_get_type (void) G_GNUC_CONST;
Latexila* latexila_get_instance (void);
GType main_window_get_type (void) G_GNUC_CONST;
void main_window_update_config_project_sensitivity (MainWindow* self);
gboolean projects_add (Projects* self, Project* new_project, GFile** conflict_file);
static gboolean projects_conflict (Projects* self, GFile* dir1, GFile* dir2);
GType document_get_type (void) G_GNUC_CONST;
GeeList* latexila_get_documents (Latexila* self);
gint document_get_project_id (Document* self);
GFile* document_get_location (Document* self);
void document_set_project_id (Document* self, gint value);
gboolean projects_change_main_file (Projects* self, gint num, GFile* new_main_file);
void projects_delete (Projects* self, gint num);
void projects_clear_all (Projects* self);
void projects_save (Projects* self);
void utils_delete_file (GFile* file);
gboolean utils_save_file (GFile* file, const gchar* contents, gboolean make_backup);
static void projects_finalize (Projects* obj);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void project_copy (const Project* self, Project* dest) {
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	_tmp0_ = (*self).directory;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).directory);
	(*dest).directory = _tmp1_;
	_tmp2_ = (*self).main_file;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).main_file);
	(*dest).main_file = _tmp3_;
}


void project_destroy (Project* self) {
	_g_object_unref0 ((*self).directory);
	_g_object_unref0 ((*self).main_file);
}


Project* project_dup (const Project* self) {
	Project* dup;
	dup = g_new0 (Project, 1);
	project_copy (self, dup);
	return dup;
}


void project_free (Project* self) {
	project_destroy (self);
	g_free (self);
}


GType project_get_type (void) {
	static volatile gsize project_type_id__volatile = 0;
	if (g_once_init_enter (&project_type_id__volatile)) {
		GType project_type_id;
		project_type_id = g_boxed_type_register_static ("Project", (GBoxedCopyFunc) project_dup, (GBoxedFreeFunc) project_free);
		g_once_init_leave (&project_type_id__volatile, project_type_id);
	}
	return project_type_id__volatile;
}


static void _projects_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
	projects_parser_start (self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static Projects* projects_construct (GType object_type) {
	Projects* self = NULL;
	GeeLinkedList* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* contents;
	const gchar* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (Projects*) g_type_create_instance (object_type);
	_tmp0_ = gee_linked_list_new (TYPE_PROJECT, (GBoxedCopyFunc) project_dup, project_free, NULL);
	_g_object_unref0 (self->priv->projects);
	self->priv->projects = _tmp0_;
	_tmp1_ = projects_get_xml_file (self);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (!_tmp3_) {
		_g_object_unref0 (file);
		return self;
	}
	_tmp4_ = file;
	_tmp5_ = utils_load_file (_tmp4_);
	contents = _tmp5_;
	_tmp6_ = contents;
	if (_tmp6_ == NULL) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		return self;
	}
	{
		GMarkupParser _tmp7_ = {0};
		GMarkupParser parser;
		GMarkupParser _tmp8_;
		GMarkupParseContext* _tmp9_;
		GMarkupParseContext* context;
		GMarkupParseContext* _tmp10_;
		const gchar* _tmp11_;
		_tmp7_.start_element = _projects_parser_start_gmarkup_parser_start_element_func;
		_tmp7_.end_element = NULL;
		_tmp7_.text = NULL;
		_tmp7_.passthrough = NULL;
		_tmp7_.error = NULL;
		parser = _tmp7_;
		_tmp8_ = parser;
		_tmp9_ = g_markup_parse_context_new (&_tmp8_, 0, self, NULL);
		context = _tmp9_;
		_tmp10_ = context;
		_tmp11_ = contents;
		g_markup_parse_context_parse (_tmp10_, _tmp11_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_markup_parse_context_free0 (context);
			goto __catch55_g_error;
		}
		projects_update_all_documents (self);
		projects_update_all_menus (self);
		_g_markup_parse_context_free0 (context);
	}
	goto __finally55;
	__catch55_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("projects.vala:59: Impossible to load the projects: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally55:
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (contents);
	_g_object_unref0 (file);
	return self;
}


static Projects* projects_new (void) {
	return projects_construct (TYPE_PROJECTS);
}


static gpointer _projects_ref0 (gpointer self) {
	return self ? projects_ref (self) : NULL;
}


Projects* projects_get_default (void) {
	Projects* result = NULL;
	Projects* _tmp0_;
	Projects* _tmp2_;
	Projects* _tmp3_;
	_tmp0_ = projects_instance;
	if (_tmp0_ == NULL) {
		Projects* _tmp1_;
		_tmp1_ = projects_new ();
		_projects_unref0 (projects_instance);
		projects_instance = _tmp1_;
	}
	_tmp2_ = projects_instance;
	_tmp3_ = _projects_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


Project* projects_get (Projects* self, gint id) {
	Project* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp6_;
	GeeLinkedList* _tmp7_;
	gint _tmp8_;
	gpointer _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = id;
	if (_tmp1_ >= 0) {
		gint _tmp2_;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = id;
		_tmp3_ = self->priv->projects;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp2_ < _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	g_return_val_if_fail (_tmp6_, NULL);
	_tmp7_ = self->priv->projects;
	_tmp8_ = id;
	_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp8_);
	result = (Project*) _tmp9_;
	return result;
}


GeeIterator* projects_iterator (Projects* self) {
	GeeIterator* result = NULL;
	GeeLinkedList* _tmp0_;
	GeeIterator* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->projects;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERATOR, GeeIterator);
	return result;
}


static void projects_update_all_menus (Projects* self) {
	Latexila* _tmp0_ = NULL;
	Latexila* _tmp1_;
	GList* _tmp2_ = NULL;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_application_get_windows ((GtkApplication*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp3_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp4_;
			GtkWindow* window = NULL;
			_tmp4_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp4_;
			{
				GtkWindow* _tmp5_;
				MainWindow* _tmp6_;
				MainWindow* main_window;
				MainWindow* _tmp7_;
				_tmp5_ = window;
				_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp5_) : NULL);
				main_window = _tmp6_;
				_tmp7_ = main_window;
				main_window_update_config_project_sensitivity (_tmp7_);
				_g_object_unref0 (main_window);
				_g_object_unref0 (window);
			}
		}
	}
}


gboolean projects_add (Projects* self, Project* new_project, GFile** conflict_file) {
	GFile* _vala_conflict_file = NULL;
	gboolean result = FALSE;
	GeeLinkedList* _tmp22_;
	Project _tmp23_;
	Latexila* _tmp24_ = NULL;
	Latexila* _tmp25_;
	GeeList* _tmp26_ = NULL;
	GeeList* _tmp27_;
	GeeList* docs;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_project != NULL, FALSE);
	_g_object_unref0 (_vala_conflict_file);
	_vala_conflict_file = NULL;
	{
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _project_list;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _project_size;
		gint _project_index;
		_tmp0_ = self->priv->projects;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_project_list = _tmp1_;
		_tmp2_ = _project_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_project_size = _tmp4_;
		_project_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			Project* _tmp11_;
			Project _tmp12_ = {0};
			Project _tmp13_;
			Project project;
			Project _tmp14_;
			GFile* _tmp15_;
			Project _tmp16_;
			GFile* _tmp17_;
			gboolean _tmp18_ = FALSE;
			_tmp5_ = _project_index;
			_project_index = _tmp5_ + 1;
			_tmp6_ = _project_index;
			_tmp7_ = _project_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _project_list;
			_tmp9_ = _project_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			_tmp11_ = (Project*) _tmp10_;
			project_copy (_tmp11_, &_tmp12_);
			_tmp13_ = _tmp12_;
			_project_free0 (_tmp11_);
			project = _tmp13_;
			_tmp14_ = project;
			_tmp15_ = _tmp14_.directory;
			_tmp16_ = *new_project;
			_tmp17_ = _tmp16_.directory;
			_tmp18_ = projects_conflict (self, _tmp15_, _tmp17_);
			if (_tmp18_) {
				Project _tmp19_;
				GFile* _tmp20_;
				GFile* _tmp21_;
				_tmp19_ = project;
				_tmp20_ = _tmp19_.directory;
				_tmp21_ = _g_object_ref0 (_tmp20_);
				_g_object_unref0 (_vala_conflict_file);
				_vala_conflict_file = _tmp21_;
				result = FALSE;
				project_destroy (&project);
				_g_object_unref0 (_project_list);
				if (conflict_file) {
					*conflict_file = _vala_conflict_file;
				} else {
					_g_object_unref0 (_vala_conflict_file);
				}
				return result;
			}
			project_destroy (&project);
		}
		_g_object_unref0 (_project_list);
	}
	_tmp22_ = self->priv->projects;
	_tmp23_ = *new_project;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, &_tmp23_);
	self->priv->modified = TRUE;
	_tmp24_ = latexila_get_instance ();
	_tmp25_ = _tmp24_;
	_tmp26_ = latexila_get_documents (_tmp25_);
	_tmp27_ = _tmp26_;
	_g_object_unref0 (_tmp25_);
	docs = _tmp27_;
	{
		GeeList* _tmp28_;
		GeeList* _tmp29_;
		GeeList* _doc_list;
		GeeList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _doc_size;
		gint _doc_index;
		_tmp28_ = docs;
		_tmp29_ = _g_object_ref0 (_tmp28_);
		_doc_list = _tmp29_;
		_tmp30_ = _doc_list;
		_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_doc_size = _tmp32_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			GeeList* _tmp36_;
			gint _tmp37_;
			gpointer _tmp38_ = NULL;
			Document* doc;
			gboolean _tmp39_ = FALSE;
			Document* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gboolean _tmp46_;
			Document* _tmp47_;
			GFile* _tmp48_;
			GFile* _tmp49_;
			Project _tmp50_;
			GFile* _tmp51_;
			gboolean _tmp52_ = FALSE;
			_tmp33_ = _doc_index;
			_doc_index = _tmp33_ + 1;
			_tmp34_ = _doc_index;
			_tmp35_ = _doc_size;
			if (!(_tmp34_ < _tmp35_)) {
				break;
			}
			_tmp36_ = _doc_list;
			_tmp37_ = _doc_index;
			_tmp38_ = gee_list_get (_tmp36_, _tmp37_);
			doc = (Document*) _tmp38_;
			_tmp40_ = doc;
			_tmp41_ = document_get_project_id (_tmp40_);
			_tmp42_ = _tmp41_;
			if (_tmp42_ != (-1)) {
				_tmp39_ = TRUE;
			} else {
				Document* _tmp43_;
				GFile* _tmp44_;
				GFile* _tmp45_;
				_tmp43_ = doc;
				_tmp44_ = document_get_location (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp39_ = _tmp45_ == NULL;
			}
			_tmp46_ = _tmp39_;
			if (_tmp46_) {
				_g_object_unref0 (doc);
				continue;
			}
			_tmp47_ = doc;
			_tmp48_ = document_get_location (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = *new_project;
			_tmp51_ = _tmp50_.directory;
			_tmp52_ = g_file_has_prefix (_tmp49_, _tmp51_);
			if (_tmp52_) {
				Document* _tmp53_;
				GeeLinkedList* _tmp54_;
				gint _tmp55_;
				gint _tmp56_;
				_tmp53_ = doc;
				_tmp54_ = self->priv->projects;
				_tmp55_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp54_);
				_tmp56_ = _tmp55_;
				document_set_project_id (_tmp53_, _tmp56_ - 1);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	projects_update_all_menus (self);
	result = TRUE;
	_g_object_unref0 (docs);
	if (conflict_file) {
		*conflict_file = _vala_conflict_file;
	} else {
		_g_object_unref0 (_vala_conflict_file);
	}
	return result;
}


gboolean projects_change_main_file (Projects* self, gint num, GFile* new_main_file) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp6_;
	GeeLinkedList* _tmp7_;
	gint _tmp8_;
	gpointer _tmp9_ = NULL;
	Project* _tmp10_;
	Project _tmp11_ = {0};
	Project _tmp12_;
	Project project;
	GFile* _tmp13_;
	Project _tmp14_;
	GFile* _tmp15_;
	gboolean _tmp16_ = FALSE;
	GFile* _tmp17_;
	Project _tmp18_;
	GFile* _tmp19_;
	gboolean _tmp20_ = FALSE;
	GFile* _tmp21_;
	GFile* _tmp22_;
	GeeLinkedList* _tmp23_;
	gint _tmp24_;
	Project _tmp25_;
	Latexila* _tmp26_ = NULL;
	Latexila* _tmp27_;
	GeeList* _tmp28_ = NULL;
	GeeList* _tmp29_;
	GeeList* docs;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_main_file != NULL, FALSE);
	_tmp1_ = num;
	if (_tmp1_ >= 0) {
		gint _tmp2_;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = num;
		_tmp3_ = self->priv->projects;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp2_ < _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	g_return_val_if_fail (_tmp6_, FALSE);
	_tmp7_ = self->priv->projects;
	_tmp8_ = num;
	_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp8_);
	_tmp10_ = (Project*) _tmp9_;
	project_copy (_tmp10_, &_tmp11_);
	_tmp12_ = _tmp11_;
	_project_free0 (_tmp10_);
	project = _tmp12_;
	_tmp13_ = new_main_file;
	_tmp14_ = project;
	_tmp15_ = _tmp14_.main_file;
	_tmp16_ = g_file_equal (_tmp13_, _tmp15_);
	if (_tmp16_) {
		result = FALSE;
		project_destroy (&project);
		return result;
	}
	_tmp17_ = new_main_file;
	_tmp18_ = project;
	_tmp19_ = _tmp18_.directory;
	_tmp20_ = g_file_has_prefix (_tmp17_, _tmp19_);
	g_return_if_fail (_tmp20_);
	_tmp21_ = new_main_file;
	_tmp22_ = _g_object_ref0 (_tmp21_);
	_g_object_unref0 (project.main_file);
	project.main_file = _tmp22_;
	_tmp23_ = self->priv->projects;
	_tmp24_ = num;
	_tmp25_ = project;
	gee_abstract_list_set ((GeeAbstractList*) _tmp23_, _tmp24_, &_tmp25_);
	self->priv->modified = TRUE;
	_tmp26_ = latexila_get_instance ();
	_tmp27_ = _tmp26_;
	_tmp28_ = latexila_get_documents (_tmp27_);
	_tmp29_ = _tmp28_;
	_g_object_unref0 (_tmp27_);
	docs = _tmp29_;
	{
		GeeList* _tmp30_;
		GeeList* _tmp31_;
		GeeList* _doc_list;
		GeeList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _doc_size;
		gint _doc_index;
		_tmp30_ = docs;
		_tmp31_ = _g_object_ref0 (_tmp30_);
		_doc_list = _tmp31_;
		_tmp32_ = _doc_list;
		_tmp33_ = gee_collection_get_size ((GeeCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_doc_size = _tmp34_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			GeeList* _tmp38_;
			gint _tmp39_;
			gpointer _tmp40_ = NULL;
			Document* doc;
			Document* _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			_tmp35_ = _doc_index;
			_doc_index = _tmp35_ + 1;
			_tmp36_ = _doc_index;
			_tmp37_ = _doc_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _doc_list;
			_tmp39_ = _doc_index;
			_tmp40_ = gee_list_get (_tmp38_, _tmp39_);
			doc = (Document*) _tmp40_;
			_tmp41_ = doc;
			_tmp42_ = document_get_project_id (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = num;
			if (_tmp43_ == _tmp44_) {
				Document* _tmp45_;
				gint _tmp46_;
				_tmp45_ = doc;
				_tmp46_ = num;
				document_set_project_id (_tmp45_, _tmp46_);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	result = TRUE;
	_g_object_unref0 (docs);
	project_destroy (&project);
	return result;
}


void projects_delete (Projects* self, gint num) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp6_;
	GeeLinkedList* _tmp7_;
	gint _tmp8_;
	gpointer _tmp9_ = NULL;
	Project* _tmp10_;
	Latexila* _tmp11_ = NULL;
	Latexila* _tmp12_;
	GeeList* _tmp13_ = NULL;
	GeeList* _tmp14_;
	GeeList* docs;
	g_return_if_fail (self != NULL);
	_tmp1_ = num;
	if (_tmp1_ >= 0) {
		gint _tmp2_;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = num;
		_tmp3_ = self->priv->projects;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp2_ < _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	g_return_if_fail (_tmp6_);
	_tmp7_ = self->priv->projects;
	_tmp8_ = num;
	_tmp9_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp7_, _tmp8_);
	_tmp10_ = (Project*) _tmp9_;
	_project_free0 (_tmp10_);
	self->priv->modified = TRUE;
	_tmp11_ = latexila_get_instance ();
	_tmp12_ = _tmp11_;
	_tmp13_ = latexila_get_documents (_tmp12_);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp12_);
	docs = _tmp14_;
	{
		GeeList* _tmp15_;
		GeeList* _tmp16_;
		GeeList* _doc_list;
		GeeList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _doc_size;
		gint _doc_index;
		_tmp15_ = docs;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		_doc_list = _tmp16_;
		_tmp17_ = _doc_list;
		_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_doc_size = _tmp19_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			GeeList* _tmp23_;
			gint _tmp24_;
			gpointer _tmp25_ = NULL;
			Document* doc;
			Document* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			_tmp20_ = _doc_index;
			_doc_index = _tmp20_ + 1;
			_tmp21_ = _doc_index;
			_tmp22_ = _doc_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _doc_list;
			_tmp24_ = _doc_index;
			_tmp25_ = gee_list_get (_tmp23_, _tmp24_);
			doc = (Document*) _tmp25_;
			_tmp26_ = doc;
			_tmp27_ = document_get_project_id (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = num;
			if (_tmp28_ == _tmp29_) {
				Document* _tmp30_;
				_tmp30_ = doc;
				document_set_project_id (_tmp30_, -1);
			} else {
				Document* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				_tmp31_ = doc;
				_tmp32_ = document_get_project_id (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = num;
				if (_tmp33_ > _tmp34_) {
					Document* _tmp35_;
					gint _tmp36_;
					gint _tmp37_;
					_tmp35_ = doc;
					_tmp36_ = document_get_project_id (_tmp35_);
					_tmp37_ = _tmp36_;
					document_set_project_id (_tmp35_, _tmp37_ - 1);
				}
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	projects_update_all_menus (self);
	_g_object_unref0 (docs);
}


void projects_clear_all (Projects* self) {
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->projects;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	self->priv->modified = TRUE;
	projects_update_all_documents (self);
	projects_update_all_menus (self);
}


static void projects_update_all_documents (Projects* self) {
	Latexila* _tmp0_ = NULL;
	Latexila* _tmp1_;
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_;
	GeeList* docs;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = latexila_get_documents (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	docs = _tmp3_;
	{
		GeeList* _tmp4_;
		GeeList* _tmp5_;
		GeeList* _doc_list;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _doc_size;
		gint _doc_index;
		_tmp4_ = docs;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_doc_list = _tmp5_;
		_tmp6_ = _doc_list;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_doc_size = _tmp8_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			Document* doc;
			Document* _tmp15_;
			Document* _tmp16_;
			GFile* _tmp17_;
			GFile* _tmp18_;
			_tmp9_ = _doc_index;
			_doc_index = _tmp9_ + 1;
			_tmp10_ = _doc_index;
			_tmp11_ = _doc_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _doc_list;
			_tmp13_ = _doc_index;
			_tmp14_ = gee_list_get (_tmp12_, _tmp13_);
			doc = (Document*) _tmp14_;
			_tmp15_ = doc;
			document_set_project_id (_tmp15_, -1);
			_tmp16_ = doc;
			_tmp17_ = document_get_location (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ == NULL) {
				_g_object_unref0 (doc);
				continue;
			}
			{
				gint i;
				i = 0;
				{
					gboolean _tmp19_;
					_tmp19_ = TRUE;
					while (TRUE) {
						gboolean _tmp20_;
						gint _tmp22_;
						GeeLinkedList* _tmp23_;
						gint _tmp24_;
						gint _tmp25_;
						Document* _tmp26_;
						GFile* _tmp27_;
						GFile* _tmp28_;
						GeeLinkedList* _tmp29_;
						gint _tmp30_;
						gpointer _tmp31_ = NULL;
						Project* _tmp32_;
						GFile* _tmp33_;
						gboolean _tmp34_ = FALSE;
						gboolean _tmp35_;
						_tmp20_ = _tmp19_;
						if (!_tmp20_) {
							gint _tmp21_;
							_tmp21_ = i;
							i = _tmp21_ + 1;
						}
						_tmp19_ = FALSE;
						_tmp22_ = i;
						_tmp23_ = self->priv->projects;
						_tmp24_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp23_);
						_tmp25_ = _tmp24_;
						if (!(_tmp22_ < _tmp25_)) {
							break;
						}
						_tmp26_ = doc;
						_tmp27_ = document_get_location (_tmp26_);
						_tmp28_ = _tmp27_;
						_tmp29_ = self->priv->projects;
						_tmp30_ = i;
						_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _tmp30_);
						_tmp32_ = (Project*) _tmp31_;
						_tmp33_ = (*_tmp32_).directory;
						_tmp34_ = g_file_has_prefix (_tmp28_, _tmp33_);
						_tmp35_ = _tmp34_;
						_project_free0 (_tmp32_);
						if (_tmp35_) {
							Document* _tmp36_;
							gint _tmp37_;
							_tmp36_ = doc;
							_tmp37_ = i;
							document_set_project_id (_tmp36_, _tmp37_);
							break;
						}
					}
				}
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	_g_object_unref0 (docs);
}


static void projects_parser_start (Projects* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("projects")))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("project")))) {
		switch (0) {
			default:
			{
				Project project = {0};
				GeeLinkedList* _tmp32_;
				Project _tmp33_;
				memset (&project, 0, sizeof (Project));
				{
					gint i;
					i = 0;
					{
						gboolean _tmp4_;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_;
							gint _tmp7_;
							gchar** _tmp8_;
							gint _tmp8__length1;
							gchar** _tmp9_;
							gint _tmp9__length1;
							gint _tmp10_;
							const gchar* _tmp11_;
							const gchar* _tmp12_;
							GQuark _tmp14_ = 0U;
							static GQuark _tmp13_label0 = 0;
							static GQuark _tmp13_label1 = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = i;
								i = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = i;
							_tmp8_ = attr_names;
							_tmp8__length1 = attr_names_length1;
							if (!(_tmp7_ < _tmp8__length1)) {
								break;
							}
							_tmp9_ = attr_names;
							_tmp9__length1 = attr_names_length1;
							_tmp10_ = i;
							_tmp11_ = _tmp9_[_tmp10_];
							_tmp12_ = _tmp11_;
							_tmp14_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
							if (_tmp14_ == ((0 != _tmp13_label0) ? _tmp13_label0 : (_tmp13_label0 = g_quark_from_static_string ("directory")))) {
								switch (0) {
									default:
									{
										gchar** _tmp15_;
										gint _tmp15__length1;
										gint _tmp16_;
										const gchar* _tmp17_;
										GFile* _tmp18_ = NULL;
										_tmp15_ = attr_values;
										_tmp15__length1 = attr_values_length1;
										_tmp16_ = i;
										_tmp17_ = _tmp15_[_tmp16_];
										_tmp18_ = g_file_new_for_uri (_tmp17_);
										_g_object_unref0 (project.directory);
										project.directory = _tmp18_;
										break;
									}
								}
							} else if (_tmp14_ == ((0 != _tmp13_label1) ? _tmp13_label1 : (_tmp13_label1 = g_quark_from_static_string ("main_file")))) {
								switch (0) {
									default:
									{
										gchar** _tmp19_;
										gint _tmp19__length1;
										gint _tmp20_;
										const gchar* _tmp21_;
										GFile* _tmp22_ = NULL;
										_tmp19_ = attr_values;
										_tmp19__length1 = attr_values_length1;
										_tmp20_ = i;
										_tmp21_ = _tmp19_[_tmp20_];
										_tmp22_ = g_file_new_for_uri (_tmp21_);
										_g_object_unref0 (project.main_file);
										project.main_file = _tmp22_;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar** _tmp23_;
										gint _tmp23__length1;
										gint _tmp24_;
										const gchar* _tmp25_;
										gchar* _tmp26_;
										gchar* _tmp27_;
										gchar* _tmp28_;
										gchar* _tmp29_;
										GError* _tmp30_;
										GError* _tmp31_;
										_tmp23_ = attr_names;
										_tmp23__length1 = attr_names_length1;
										_tmp24_ = i;
										_tmp25_ = _tmp23_[_tmp24_];
										_tmp26_ = g_strconcat ("unknown attribute \"", _tmp25_, NULL);
										_tmp27_ = _tmp26_;
										_tmp28_ = g_strconcat (_tmp27_, "\"", NULL);
										_tmp29_ = _tmp28_;
										_tmp30_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp29_);
										_tmp31_ = _tmp30_;
										_g_free0 (_tmp29_);
										_g_free0 (_tmp27_);
										_inner_error_ = _tmp31_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											project_destroy (&project);
											return;
										} else {
											project_destroy (&project);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				_tmp32_ = self->priv->projects;
				_tmp33_ = project;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, &_tmp33_);
				project_destroy (&project);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				GError* _tmp39_;
				GError* _tmp40_;
				_tmp34_ = name;
				_tmp35_ = g_strconcat ("unknown element \"", _tmp34_, NULL);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_strconcat (_tmp36_, "\"", NULL);
				_tmp38_ = _tmp37_;
				_tmp39_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp38_);
				_tmp40_ = _tmp39_;
				_g_free0 (_tmp38_);
				_g_free0 (_tmp36_);
				_inner_error_ = _tmp40_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static GFile* projects_get_xml_file (Projects* self) {
	GFile* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path;
	GFile* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "latexila", "projects.xml", NULL, NULL);
	path = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	result = _tmp2_;
	_g_free0 (path);
	return result;
}


void projects_save (Projects* self) {
	gboolean _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp6_;
	gchar* content;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	GFile* _tmp35_;
	const gchar* _tmp36_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->modified;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = projects_get_xml_file (self);
	file = _tmp1_;
	_tmp2_ = self->priv->projects;
	_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		GFile* _tmp5_;
		_tmp5_ = file;
		utils_delete_file (_tmp5_);
		_g_object_unref0 (file);
		return;
	}
	_tmp6_ = g_strdup ("<projects>\n");
	content = _tmp6_;
	{
		GeeLinkedList* _tmp7_;
		GeeLinkedList* _tmp8_;
		GeeLinkedList* _project_list;
		GeeLinkedList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _project_size;
		gint _project_index;
		_tmp7_ = self->priv->projects;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_project_list = _tmp8_;
		_tmp9_ = _project_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_project_size = _tmp11_;
		_project_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			GeeLinkedList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_ = NULL;
			Project* _tmp18_;
			Project _tmp19_ = {0};
			Project _tmp20_;
			Project project;
			const gchar* _tmp21_;
			Project _tmp22_;
			GFile* _tmp23_;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			Project _tmp26_;
			GFile* _tmp27_;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_;
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp12_ = _project_index;
			_project_index = _tmp12_ + 1;
			_tmp13_ = _project_index;
			_tmp14_ = _project_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _project_list;
			_tmp16_ = _project_index;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
			_tmp18_ = (Project*) _tmp17_;
			project_copy (_tmp18_, &_tmp19_);
			_tmp20_ = _tmp19_;
			_project_free0 (_tmp18_);
			project = _tmp20_;
			_tmp21_ = content;
			_tmp22_ = project;
			_tmp23_ = _tmp22_.directory;
			_tmp24_ = g_file_get_uri (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = project;
			_tmp27_ = _tmp26_.main_file;
			_tmp28_ = g_file_get_uri (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strdup_printf ("  <project directory=\"%s\" main_file=\"%s\" />\n", _tmp25_, _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strconcat (_tmp21_, _tmp31_, NULL);
			_g_free0 (content);
			content = _tmp32_;
			_g_free0 (_tmp31_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp25_);
			project_destroy (&project);
		}
		_g_object_unref0 (_project_list);
	}
	_tmp33_ = content;
	_tmp34_ = g_strconcat (_tmp33_, "</projects>\n", NULL);
	_g_free0 (content);
	content = _tmp34_;
	_tmp35_ = file;
	_tmp36_ = content;
	utils_save_file (_tmp35_, _tmp36_, FALSE);
	_g_free0 (content);
	_g_object_unref0 (file);
}


static gboolean projects_conflict (Projects* self, GFile* dir1, GFile* dir2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp8_;
	gboolean _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dir1 != NULL, FALSE);
	g_return_val_if_fail (dir2 != NULL, FALSE);
	_tmp2_ = dir1;
	_tmp3_ = dir2;
	_tmp4_ = g_file_has_prefix (_tmp2_, _tmp3_);
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		GFile* _tmp5_;
		GFile* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = dir2;
		_tmp6_ = dir1;
		_tmp7_ = g_file_has_prefix (_tmp5_, _tmp6_);
		_tmp1_ = _tmp7_;
	}
	_tmp8_ = _tmp1_;
	if (_tmp8_) {
		_tmp0_ = TRUE;
	} else {
		GFile* _tmp9_;
		GFile* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = dir1;
		_tmp10_ = dir2;
		_tmp11_ = g_file_equal (_tmp9_, _tmp10_);
		_tmp0_ = _tmp11_;
	}
	_tmp12_ = _tmp0_;
	result = _tmp12_;
	return result;
}


static void value_projects_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_projects_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		projects_unref (value->data[0].v_pointer);
	}
}


static void value_projects_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = projects_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_projects_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_projects_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Projects* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = projects_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_projects_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Projects** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = projects_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecProjects* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PROJECTS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_projects (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS), NULL);
	return value->data[0].v_pointer;
}


void value_set_projects (GValue* value, gpointer v_object) {
	Projects* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROJECTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		projects_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		projects_unref (old);
	}
}


void value_take_projects (GValue* value, gpointer v_object) {
	Projects* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROJECTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		projects_unref (old);
	}
}


static void projects_class_init (ProjectsClass * klass) {
	projects_parent_class = g_type_class_peek_parent (klass);
	PROJECTS_CLASS (klass)->finalize = projects_finalize;
	g_type_class_add_private (klass, sizeof (ProjectsPrivate));
}


static void projects_instance_init (Projects * self) {
	self->priv = PROJECTS_GET_PRIVATE (self);
	self->priv->modified = FALSE;
	self->ref_count = 1;
}


static void projects_finalize (Projects* obj) {
	Projects * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROJECTS, Projects);
	_g_object_unref0 (self->priv->projects);
}


GType projects_get_type (void) {
	static volatile gsize projects_type_id__volatile = 0;
	if (g_once_init_enter (&projects_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_projects_init, value_projects_free_value, value_projects_copy_value, value_projects_peek_pointer, "p", value_projects_collect_value, "p", value_projects_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ProjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) projects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Projects), 0, (GInstanceInitFunc) projects_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType projects_type_id;
		projects_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Projects", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&projects_type_id__volatile, projects_type_id);
	}
	return projects_type_id__volatile;
}


gpointer projects_ref (gpointer instance) {
	Projects* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void projects_unref (gpointer instance) {
	Projects* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PROJECTS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



