/* file_browser.c generated by valac 0.17.3.8-fd35, the Vala compiler
 * generated from file_browser.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtksourceview/gtksource.h>
#include <pango/pango.h>
#include <gdk/gdk.h>


#define TYPE_FILE_BROWSER (file_browser_get_type ())
#define FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_BROWSER, FileBrowser))
#define FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_BROWSER, FileBrowserClass))
#define IS_FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_BROWSER))
#define IS_FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_BROWSER))
#define FILE_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_BROWSER, FileBrowserClass))

typedef struct _FileBrowser FileBrowser;
typedef struct _FileBrowserClass FileBrowserClass;
typedef struct _FileBrowserPrivate FileBrowserPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define FILE_BROWSER_TYPE_PARENT_DIR_COLUMN (file_browser_parent_dir_column_get_type ())

#define FILE_BROWSER_TYPE_FILE_COLUMN (file_browser_file_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block32Data Block32Data;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

struct _FileBrowser {
	GtkGrid parent_instance;
	FileBrowserPrivate * priv;
};

struct _FileBrowserClass {
	GtkGridClass parent_class;
};

struct _FileBrowserPrivate {
	MainWindow* _main_window;
	GtkListStore* _parent_dir_store;
	GtkListStore* _list_store;
	GtkTreeView* _list_view;
	GtkComboBox* _combo_box;
	GFile* _current_directory;
	GtkButton* _parent_button;
	GSettings* _settings;
	GSettings* _latex_settings;
	guint _timeout_id;
};

typedef enum  {
	FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF,
	FILE_BROWSER_PARENT_DIR_COLUMN_NAME,
	FILE_BROWSER_PARENT_DIR_COLUMN_FILE,
	FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS
} FileBrowserParentDirColumn;

typedef enum  {
	FILE_BROWSER_FILE_COLUMN_PIXBUF,
	FILE_BROWSER_FILE_COLUMN_NAME,
	FILE_BROWSER_FILE_COLUMN_IS_DIR,
	FILE_BROWSER_FILE_COLUMN_N_COLUMNS
} FileBrowserFileColumn;

struct _Block32Data {
	int _ref_count_;
	FileBrowser * self;
	GtkButton* jump_button;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};


static gpointer file_browser_parent_class = NULL;

GType file_browser_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define FILE_BROWSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FILE_BROWSER, FileBrowserPrivate))
enum  {
	FILE_BROWSER_DUMMY_PROPERTY
};
static GType file_browser_parent_dir_column_get_type (void) G_GNUC_UNUSED;
static GType file_browser_file_column_get_type (void) G_GNUC_UNUSED;
FileBrowser* file_browser_new (MainWindow* main_window);
FileBrowser* file_browser_construct (GType object_type, MainWindow* main_window);
static void file_browser_init_toolbar (FileBrowser* self);
static void file_browser_init_combo_box (FileBrowser* self);
static void file_browser_init_list (FileBrowser* self);
static void file_browser_init_settings (FileBrowser* self);
static void file_browser_fill_stores_with_dir (FileBrowser* self, GFile* dir);
void file_browser_refresh (FileBrowser* self);
static void _file_browser_refresh_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void file_browser_on_refresh (FileBrowser* self);
static void _file_browser_on_refresh_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static gboolean __lambda34_ (FileBrowser* self);
static gboolean ___lambda34__gsource_func (gpointer self);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
GtkButton* utils_get_toolbar_button (const gchar* stock_id);
static void __lambda27_ (FileBrowser* self);
static void ___lambda27__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda28_ (FileBrowser* self);
static void ___lambda28__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda29_ (FileBrowser* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_get_active_tab (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
static void ___lambda29__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda30_ (Block32Data* _data32_);
static void file_browser_update_jump_button_sensitivity (FileBrowser* self, GtkButton* jump_button);
static void ___lambda31_ (Block32Data* _data32_);
static void ____lambda31__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ___lambda30__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _file_browser_refresh_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda32_ (FileBrowser* self);
static void ___lambda32__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static gint file_browser_on_sort (FileBrowser* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b);
static gint _file_browser_on_sort_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
static void __lambda33_ (FileBrowser* self, GtkTreePath* path);
gchar* utils_get_extension (const gchar* path);
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
static void ___lambda33__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
void file_browser_refresh_for_document (FileBrowser* self, Document* doc);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
Project* document_get_project (Document* self);
static void file_browser_insert_file (FileBrowser* self, gboolean is_dir, const gchar* pixbuf, const gchar* basename);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void file_browser_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType file_browser_parent_dir_column_get_type (void) {
	static volatile gsize file_browser_parent_dir_column_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_parent_dir_column_type_id__volatile)) {
		static const GEnumValue values[] = {{FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, "FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF", "pixbuf"}, {FILE_BROWSER_PARENT_DIR_COLUMN_NAME, "FILE_BROWSER_PARENT_DIR_COLUMN_NAME", "name"}, {FILE_BROWSER_PARENT_DIR_COLUMN_FILE, "FILE_BROWSER_PARENT_DIR_COLUMN_FILE", "file"}, {FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS, "FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType file_browser_parent_dir_column_type_id;
		file_browser_parent_dir_column_type_id = g_enum_register_static ("FileBrowserParentDirColumn", values);
		g_once_init_leave (&file_browser_parent_dir_column_type_id__volatile, file_browser_parent_dir_column_type_id);
	}
	return file_browser_parent_dir_column_type_id__volatile;
}


static GType file_browser_file_column_get_type (void) {
	static volatile gsize file_browser_file_column_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_file_column_type_id__volatile)) {
		static const GEnumValue values[] = {{FILE_BROWSER_FILE_COLUMN_PIXBUF, "FILE_BROWSER_FILE_COLUMN_PIXBUF", "pixbuf"}, {FILE_BROWSER_FILE_COLUMN_NAME, "FILE_BROWSER_FILE_COLUMN_NAME", "name"}, {FILE_BROWSER_FILE_COLUMN_IS_DIR, "FILE_BROWSER_FILE_COLUMN_IS_DIR", "is-dir"}, {FILE_BROWSER_FILE_COLUMN_N_COLUMNS, "FILE_BROWSER_FILE_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType file_browser_file_column_type_id;
		file_browser_file_column_type_id = g_enum_register_static ("FileBrowserFileColumn", values);
		g_once_init_leave (&file_browser_file_column_type_id__volatile, file_browser_file_column_type_id);
	}
	return file_browser_file_column_type_id__volatile;
}


FileBrowser* file_browser_construct (GType object_type, MainWindow* main_window) {
	FileBrowser * self = NULL;
	MainWindow* _tmp0_;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (FileBrowser*) g_object_new (object_type, NULL);
	_tmp0_ = main_window;
	self->priv->_main_window = _tmp0_;
	gtk_grid_set_row_spacing ((GtkGrid*) self, 5);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	file_browser_init_toolbar (self);
	file_browser_init_combo_box (self);
	file_browser_init_list (self);
	file_browser_init_settings (self);
	gtk_widget_show_all ((GtkWidget*) self);
	file_browser_fill_stores_with_dir (self, NULL);
	return self;
}


FileBrowser* file_browser_new (MainWindow* main_window) {
	return file_browser_construct (TYPE_FILE_BROWSER, main_window);
}


static void _file_browser_refresh_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	file_browser_refresh (self);
}


static void _file_browser_on_refresh_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	file_browser_on_refresh (self);
}


static void file_browser_init_settings (FileBrowser* self) {
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.file-browser");
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	_tmp1_ = self->priv->_settings;
	g_signal_connect_object (_tmp1_, "changed::show-all-files", (GCallback) _file_browser_refresh_g_settings_changed, self, 0);
	_tmp2_ = self->priv->_settings;
	g_signal_connect_object (_tmp2_, "changed::show-all-files-except", (GCallback) _file_browser_refresh_g_settings_changed, self, 0);
	_tmp3_ = self->priv->_settings;
	g_signal_connect_object (_tmp3_, "changed::show-hidden-files", (GCallback) _file_browser_refresh_g_settings_changed, self, 0);
	_tmp4_ = self->priv->_settings;
	g_signal_connect_object (_tmp4_, "changed::file-extensions", (GCallback) _file_browser_on_refresh_g_settings_changed, self, 0);
	_tmp5_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	_g_object_unref0 (self->priv->_latex_settings);
	self->priv->_latex_settings = _tmp5_;
	_tmp6_ = self->priv->_latex_settings;
	g_signal_connect_object (_tmp6_, "changed::clean-extensions", (GCallback) _file_browser_on_refresh_g_settings_changed, self, 0);
}


static gboolean __lambda34_ (FileBrowser* self) {
	gboolean result = FALSE;
	self->priv->_timeout_id = (guint) 0;
	file_browser_refresh (self);
	result = FALSE;
	return result;
}


static gboolean ___lambda34__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda34_ (self);
	return result;
}


static void file_browser_on_refresh (FileBrowser* self) {
	guint _tmp0_;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_timeout_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->_timeout_id;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ___lambda34__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->_timeout_id = _tmp2_;
}


static Block32Data* block32_data_ref (Block32Data* _data32_) {
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}


static void block32_data_unref (void * _userdata_) {
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		FileBrowser * self;
		self = _data32_->self;
		_g_object_unref0 (_data32_->jump_button);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}


static void __lambda27_ (FileBrowser* self) {
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* home_dir;
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	home_dir = _tmp1_;
	file_browser_fill_stores_with_dir (self, home_dir);
	_g_object_unref0 (home_dir);
}


static void ___lambda27__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda27_ (self);
}


static void __lambda28_ (FileBrowser* self) {
	GFile* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* parent;
	_tmp0_ = self->priv->_current_directory;
	_tmp1_ = g_file_get_parent (_tmp0_);
	parent = _tmp1_;
	g_return_if_fail (parent != NULL);
	file_browser_fill_stores_with_dir (self, parent);
	_g_object_unref0 (parent);
}


static void ___lambda28__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda28_ (self);
}


static void __lambda29_ (FileBrowser* self) {
	gboolean _tmp0_ = FALSE;
	MainWindow* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentTab* _tmp3_;
	gboolean _tmp9_;
	MainWindow* _tmp10_;
	Document* _tmp11_;
	Document* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_ = NULL;
	GFile* _tmp16_;
	_tmp1_ = self->priv->_main_window;
	_tmp2_ = main_window_get_active_tab (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		MainWindow* _tmp4_;
		Document* _tmp5_;
		Document* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		_tmp4_ = self->priv->_main_window;
		_tmp5_ = main_window_get_active_document (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = document_get_location (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ == NULL;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		return;
	}
	_tmp10_ = self->priv->_main_window;
	_tmp11_ = main_window_get_active_document (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = document_get_location (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_file_get_parent (_tmp14_);
	_tmp16_ = _tmp15_;
	file_browser_fill_stores_with_dir (self, _tmp16_);
	_g_object_unref0 (_tmp16_);
}


static void ___lambda29__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda29_ (self);
}


static void ___lambda31_ (Block32Data* _data32_) {
	FileBrowser * self;
	self = _data32_->self;
	file_browser_update_jump_button_sensitivity (self, _data32_->jump_button);
}


static void ____lambda31__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda31_ (self);
}


static void __lambda30_ (Block32Data* _data32_) {
	FileBrowser * self;
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	self = _data32_->self;
	file_browser_update_jump_button_sensitivity (self, _data32_->jump_button);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_document (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		MainWindow* _tmp3_;
		Document* _tmp4_;
		Document* _tmp5_;
		_tmp3_ = self->priv->_main_window;
		_tmp4_ = main_window_get_active_document (_tmp3_);
		_tmp5_ = _tmp4_;
		g_signal_connect_data ((GObject*) _tmp5_, "notify::location", (GCallback) ____lambda31__g_object_notify, block32_data_ref (_data32_), (GClosureNotify) block32_data_unref, 0);
	}
}


static void ___lambda30__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda30_ (self);
}


static void _file_browser_refresh_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	file_browser_refresh (self);
}


static void file_browser_init_toolbar (FileBrowser* self) {
	Block32Data* _data32_;
	GtkGrid* _tmp0_;
	GtkGrid* grid;
	GtkButton* _tmp1_ = NULL;
	GtkButton* home_button;
	GtkButton* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkButton* refresh_button;
	const gchar* _tmp5_ = NULL;
	GtkButton* _tmp6_;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	MainWindow* _tmp12_;
	g_return_if_fail (self != NULL);
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_data32_->self = g_object_ref (self);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	gtk_orientable_set_orientation ((GtkOrientable*) grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_homogeneous (grid, TRUE);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	_tmp1_ = utils_get_toolbar_button (GTK_STOCK_HOME);
	home_button = _tmp1_;
	_tmp2_ = utils_get_toolbar_button (GTK_STOCK_GO_UP);
	_g_object_unref0 (self->priv->_parent_button);
	self->priv->_parent_button = _tmp2_;
	_tmp3_ = utils_get_toolbar_button (GTK_STOCK_JUMP_TO);
	_data32_->jump_button = _tmp3_;
	_tmp4_ = utils_get_toolbar_button (GTK_STOCK_REFRESH);
	refresh_button = _tmp4_;
	_tmp5_ = _ ("Go to the home directory");
	gtk_widget_set_tooltip_text ((GtkWidget*) home_button, _tmp5_);
	_tmp6_ = self->priv->_parent_button;
	_tmp7_ = _ ("Go to the parent directory");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _tmp7_);
	_tmp8_ = _ ("Go to the active document directory");
	gtk_widget_set_tooltip_text ((GtkWidget*) _data32_->jump_button, _tmp8_);
	_tmp9_ = _ ("Refresh");
	gtk_widget_set_tooltip_text ((GtkWidget*) refresh_button, _tmp9_);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) home_button);
	_tmp10_ = self->priv->_parent_button;
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) _tmp10_);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) _data32_->jump_button);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) refresh_button);
	g_signal_connect_object (home_button, "clicked", (GCallback) ___lambda27__gtk_button_clicked, self, 0);
	_tmp11_ = self->priv->_parent_button;
	g_signal_connect_object (_tmp11_, "clicked", (GCallback) ___lambda28__gtk_button_clicked, self, 0);
	g_signal_connect_object (_data32_->jump_button, "clicked", (GCallback) ___lambda29__gtk_button_clicked, self, 0);
	_tmp12_ = self->priv->_main_window;
	g_signal_connect_data ((GObject*) _tmp12_, "notify::active-document", (GCallback) ___lambda30__g_object_notify, block32_data_ref (_data32_), (GClosureNotify) block32_data_unref, 0);
	g_signal_connect_object (refresh_button, "clicked", (GCallback) _file_browser_refresh_gtk_button_clicked, self, 0);
	_g_object_unref0 (refresh_button);
	_g_object_unref0 (home_button);
	_g_object_unref0 (grid);
	block32_data_unref (_data32_);
	_data32_ = NULL;
}


static void file_browser_update_jump_button_sensitivity (FileBrowser* self, GtkButton* jump_button) {
	gboolean _tmp0_ = FALSE;
	MainWindow* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentTab* _tmp3_;
	GtkButton* _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (jump_button != NULL);
	_tmp1_ = self->priv->_main_window;
	_tmp2_ = main_window_get_active_tab (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		MainWindow* _tmp4_;
		Document* _tmp5_;
		Document* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		_tmp4_ = self->priv->_main_window;
		_tmp5_ = main_window_get_active_document (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = document_get_location (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = jump_button;
	_tmp10_ = _tmp0_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, _tmp10_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda32_ (FileBrowser* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->_combo_box;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		GtkComboBox* _tmp3_;
		GtkTreeModel* _tmp4_ = NULL;
		GtkTreeModel* _tmp5_;
		GtkTreeModel* model;
		GFile* file = NULL;
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp3_ = self->priv->_combo_box;
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		model = _tmp5_;
		_tmp6_ = model;
		_tmp7_ = iter;
		gtk_tree_model_get (_tmp6_, &_tmp7_, FILE_BROWSER_PARENT_DIR_COLUMN_FILE, &file, -1, -1);
		_tmp8_ = file;
		_tmp9_ = self->priv->_current_directory;
		_tmp10_ = g_file_equal (_tmp8_, _tmp9_);
		if (!_tmp10_) {
			GFile* _tmp11_;
			_tmp11_ = file;
			file_browser_fill_stores_with_dir (self, _tmp11_);
		}
		_g_object_unref0 (file);
		_g_object_unref0 (model);
	}
}


static void ___lambda32__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	__lambda32_ (self);
}


static void file_browser_init_combo_box (FileBrowser* self) {
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GtkComboBox* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkCellRendererPixbuf* _tmp4_;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkComboBox* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkCellRendererText* _tmp7_;
	GtkCellRendererText* text_renderer;
	GtkComboBox* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkComboBox* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_FILE);
	_g_object_unref0 (self->priv->_parent_dir_store);
	self->priv->_parent_dir_store = _tmp0_;
	_tmp1_ = self->priv->_parent_dir_store;
	_tmp2_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->_combo_box);
	self->priv->_combo_box = _tmp2_;
	_tmp3_ = self->priv->_combo_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp4_);
	pixbuf_renderer = _tmp4_;
	_tmp5_ = self->priv->_combo_box;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp5_, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	_tmp6_ = self->priv->_combo_box;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp6_, (GtkCellRenderer*) pixbuf_renderer, "stock-id", FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, NULL, NULL);
	_tmp7_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp7_);
	text_renderer = _tmp7_;
	_tmp8_ = self->priv->_combo_box;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp8_, (GtkCellRenderer*) text_renderer, TRUE);
	_tmp9_ = self->priv->_combo_box;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp9_, (GtkCellRenderer*) text_renderer, "text", FILE_BROWSER_PARENT_DIR_COLUMN_NAME, NULL, NULL);
	g_object_set (text_renderer, "ellipsize-set", TRUE, NULL);
	g_object_set (text_renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp10_ = self->priv->_combo_box;
	g_signal_connect_object (_tmp10_, "changed", (GCallback) ___lambda32__gtk_combo_box_changed, self, 0);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
}


static gint _file_browser_on_sort_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self) {
	gint result;
	result = file_browser_on_sort (self, model, a, b);
	return result;
}


static void __lambda33_ (FileBrowser* self, GtkTreePath* path) {
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gchar* basename = NULL;
	gboolean is_dir = FALSE;
	GtkTreeModel* _tmp6_;
	GtkTreeIter _tmp7_;
	GFile* _tmp8_;
	const gchar* _tmp9_;
	GFile* _tmp10_ = NULL;
	GFile* file;
	gboolean _tmp11_;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* extension;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_;
	gboolean _tmp19_;
	gboolean _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->_list_store;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GTK_TYPE_TREE_MODEL, GtkTreeModel));
	model = _tmp1_;
	_tmp2_ = model;
	_tmp3_ = path;
	_tmp5_ = gtk_tree_model_get_iter (_tmp2_, &_tmp4_, _tmp3_);
	iter = _tmp4_;
	if (!_tmp5_) {
		_g_object_unref0 (model);
		return;
	}
	_tmp6_ = model;
	_tmp7_ = iter;
	gtk_tree_model_get (_tmp6_, &_tmp7_, FILE_BROWSER_FILE_COLUMN_NAME, &basename, FILE_BROWSER_FILE_COLUMN_IS_DIR, &is_dir, -1, -1);
	_tmp8_ = self->priv->_current_directory;
	_tmp9_ = basename;
	_tmp10_ = g_file_get_child (_tmp8_, _tmp9_);
	file = _tmp10_;
	_tmp11_ = is_dir;
	if (_tmp11_) {
		GFile* _tmp12_;
		_tmp12_ = file;
		file_browser_fill_stores_with_dir (self, _tmp12_);
		_g_object_unref0 (file);
		_g_free0 (basename);
		_g_object_unref0 (model);
		return;
	}
	_tmp13_ = basename;
	_tmp14_ = utils_get_extension (_tmp13_);
	extension = _tmp14_;
	_tmp17_ = extension;
	if (g_strcmp0 (_tmp17_, ".dvi") != 0) {
		const gchar* _tmp18_;
		_tmp18_ = extension;
		_tmp16_ = g_strcmp0 (_tmp18_, ".pdf") != 0;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp19_ = _tmp16_;
	if (_tmp19_) {
		const gchar* _tmp20_;
		_tmp20_ = extension;
		_tmp15_ = g_strcmp0 (_tmp20_, ".ps") != 0;
	} else {
		_tmp15_ = FALSE;
	}
	_tmp21_ = _tmp15_;
	if (_tmp21_) {
		MainWindow* _tmp22_;
		GFile* _tmp23_;
		DocumentTab* _tmp24_ = NULL;
		DocumentTab* _tmp25_;
		_tmp22_ = self->priv->_main_window;
		_tmp23_ = file;
		_tmp24_ = main_window_open_document (_tmp22_, _tmp23_, TRUE);
		_tmp25_ = _tmp24_;
		_g_object_unref0 (_tmp25_);
		_g_free0 (extension);
		_g_object_unref0 (file);
		_g_free0 (basename);
		_g_object_unref0 (model);
		return;
	}
	{
		GdkScreen* _tmp26_ = NULL;
		GFile* _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		_tmp26_ = gtk_widget_get_screen ((GtkWidget*) self);
		_tmp27_ = file;
		_tmp28_ = g_file_get_uri (_tmp27_);
		_tmp29_ = _tmp28_;
		gtk_show_uri (_tmp26_, _tmp29_, (guint32) GDK_CURRENT_TIME, &_inner_error_);
		_g_free0 (_tmp29_);
		if (_inner_error_ != NULL) {
			goto __catch56_g_error;
		}
	}
	goto __finally56;
	__catch56_g_error:
	{
		GError* e = NULL;
		GFile* _tmp30_;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
		GError* _tmp33_;
		const gchar* _tmp34_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = file;
		_tmp31_ = g_file_get_uri (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		g_warning ("file_browser.vala:271: Impossible to open the file '%s': %s", _tmp32_, _tmp34_);
		_g_free0 (_tmp32_);
		_g_error_free0 (e);
	}
	__finally56:
	if (_inner_error_ != NULL) {
		_g_free0 (extension);
		_g_object_unref0 (file);
		_g_free0 (basename);
		_g_object_unref0 (model);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (extension);
	_g_object_unref0 (file);
	_g_free0 (basename);
	_g_object_unref0 (model);
}


static void ___lambda33__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	__lambda33_ (self, path);
}


static void file_browser_init_list (FileBrowser* self) {
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GtkListStore* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeView* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkTreeViewColumn* _tmp6_;
	GtkTreeViewColumn* column;
	GtkTreeView* _tmp7_;
	GtkCellRendererPixbuf* _tmp8_;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* _tmp9_;
	GtkCellRendererText* text_renderer;
	GtkTreeView* _tmp10_;
	GtkWidget* _tmp11_ = NULL;
	GtkWidget* sw;
	GtkTreeView* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) FILE_BROWSER_FILE_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
	_g_object_unref0 (self->priv->_list_store);
	self->priv->_list_store = _tmp0_;
	_tmp1_ = self->priv->_list_store;
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) _tmp1_, 0, _file_browser_on_sort_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	_tmp2_ = self->priv->_list_store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp2_, 0, GTK_SORT_ASCENDING);
	_tmp3_ = self->priv->_list_store;
	_tmp4_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->_list_view);
	self->priv->_list_view = _tmp4_;
	_tmp5_ = self->priv->_list_view;
	gtk_tree_view_set_headers_visible (_tmp5_, FALSE);
	_tmp6_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp6_);
	column = _tmp6_;
	_tmp7_ = self->priv->_list_view;
	gtk_tree_view_append_column (_tmp7_, column);
	_tmp8_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp8_);
	pixbuf_renderer = _tmp8_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) pixbuf_renderer, "stock-id", FILE_BROWSER_FILE_COLUMN_PIXBUF, NULL, NULL);
	_tmp9_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp9_);
	text_renderer = _tmp9_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) text_renderer, "text", FILE_BROWSER_FILE_COLUMN_NAME, NULL, NULL);
	_tmp10_ = self->priv->_list_view;
	_tmp11_ = utils_add_scrollbar ((GtkWidget*) _tmp10_);
	sw = _tmp11_;
	g_object_set (sw, "expand", TRUE, NULL);
	gtk_container_add ((GtkContainer*) self, sw);
	_tmp12_ = self->priv->_list_view;
	g_signal_connect_object (_tmp12_, "row-activated", (GCallback) ___lambda33__gtk_tree_view_row_activated, self, 0);
	_g_object_unref0 (sw);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
}


void file_browser_refresh (FileBrowser* self) {
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_directory;
	file_browser_fill_stores_with_dir (self, _tmp0_);
}


void file_browser_refresh_for_document (FileBrowser* self, Document* doc) {
	Document* _tmp0_;
	Project* _tmp1_ = NULL;
	Project* project;
	Project* _tmp2_;
	Project* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	GFile* project_dir;
	gboolean _tmp18_ = FALSE;
	GFile* _tmp19_;
	GFile* _tmp20_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = doc;
	_tmp1_ = document_get_project (_tmp0_);
	project = _tmp1_;
	_tmp2_ = project;
	if (_tmp2_ == NULL) {
		gboolean _tmp3_ = FALSE;
		Document* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		gboolean _tmp14_;
		_tmp4_ = doc;
		_tmp5_ = document_get_location (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != NULL) {
			GFile* _tmp7_;
			Document* _tmp8_;
			GFile* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_ = NULL;
			GFile* _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp7_ = self->priv->_current_directory;
			_tmp8_ = doc;
			_tmp9_ = document_get_location (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_file_get_parent (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_file_equal (_tmp7_, _tmp12_);
			_tmp3_ = _tmp13_;
			_g_object_unref0 (_tmp12_);
		} else {
			_tmp3_ = FALSE;
		}
		_tmp14_ = _tmp3_;
		if (_tmp14_) {
			file_browser_refresh (self);
		}
		_project_free0 (project);
		return;
	}
	_tmp15_ = project;
	_tmp16_ = (*_tmp15_).directory;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	project_dir = _tmp17_;
	_tmp19_ = self->priv->_current_directory;
	_tmp20_ = project_dir;
	_tmp21_ = g_file_equal (_tmp19_, _tmp20_);
	if (_tmp21_) {
		_tmp18_ = TRUE;
	} else {
		GFile* _tmp22_;
		GFile* _tmp23_;
		gboolean _tmp24_ = FALSE;
		_tmp22_ = self->priv->_current_directory;
		_tmp23_ = project_dir;
		_tmp24_ = g_file_has_prefix (_tmp22_, _tmp23_);
		_tmp18_ = _tmp24_;
	}
	_tmp25_ = _tmp18_;
	if (_tmp25_) {
		file_browser_refresh (self);
	}
	_g_object_unref0 (project_dir);
	_project_free0 (project);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void file_browser_fill_stores_with_dir (FileBrowser* self, GFile* dir) {
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GtkTreeView* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* directory;
	GFile* _tmp5_;
	GList* parent_dirs;
	GFile* _tmp109_;
	GFile* _tmp110_;
	GFile* _tmp111_;
	GFile* _tmp112_;
	GFile* current_dir;
	GtkTreeIter _tmp120_ = {0};
	GtkTreeIter iter;
	gint i;
	GList* _tmp121_;
	GFile* _tmp145_;
	GFile* _tmp146_;
	GSettings* _tmp147_;
	GFile* _tmp148_;
	gchar* _tmp149_ = NULL;
	gchar* _tmp150_;
	GtkComboBox* _tmp151_;
	GtkTreeIter _tmp152_;
	GtkButton* _tmp153_;
	GFile* _tmp154_;
	GFile* _tmp155_ = NULL;
	GFile* _tmp156_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_list_store;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = self->priv->_parent_dir_store;
	gtk_list_store_clear (_tmp1_);
	_tmp2_ = self->priv->_list_view;
	gtk_tree_view_columns_autosize (_tmp2_);
	_tmp3_ = dir;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	directory = _tmp4_;
	_tmp5_ = directory;
	if (_tmp5_ == NULL) {
		GSettings* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* uri;
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp9_;
		gboolean _tmp13_;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		const gchar* _tmp18_;
		gboolean _tmp22_;
		gboolean _tmp25_;
		_tmp6_ = self->priv->_settings;
		_tmp7_ = g_settings_get_string (_tmp6_, "current-directory");
		uri = _tmp7_;
		_tmp9_ = uri;
		if (_tmp9_ != NULL) {
			const gchar* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_tmp10_ = uri;
			_tmp11_ = strlen (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp8_ = _tmp12_ > 0;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp13_ = _tmp8_;
		if (_tmp13_) {
			const gchar* _tmp14_;
			GFile* _tmp15_ = NULL;
			_tmp14_ = uri;
			_tmp15_ = g_file_new_for_uri (_tmp14_);
			_g_object_unref0 (directory);
			directory = _tmp15_;
		}
		_tmp18_ = uri;
		if (_tmp18_ == NULL) {
			_tmp17_ = TRUE;
		} else {
			const gchar* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			_tmp19_ = uri;
			_tmp20_ = strlen (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp17_ = _tmp21_ == 0;
		}
		_tmp22_ = _tmp17_;
		if (_tmp22_) {
			_tmp16_ = TRUE;
		} else {
			GFile* _tmp23_;
			gboolean _tmp24_ = FALSE;
			_tmp23_ = directory;
			_tmp24_ = g_file_query_exists (_tmp23_, NULL);
			_tmp16_ = !_tmp24_;
		}
		_tmp25_ = _tmp16_;
		if (_tmp25_) {
			const gchar* _tmp26_ = NULL;
			GFile* _tmp27_ = NULL;
			_tmp26_ = g_get_home_dir ();
			_tmp27_ = g_file_new_for_path (_tmp26_);
			_g_object_unref0 (directory);
			directory = _tmp27_;
		}
		_g_free0 (uri);
	}
	{
		GFile* _tmp28_;
		GFileEnumerator* _tmp29_ = NULL;
		GFileEnumerator* enumerator;
		GSettings* _tmp30_;
		gboolean _tmp31_ = FALSE;
		gboolean show_all;
		GSettings* _tmp32_;
		gboolean _tmp33_ = FALSE;
		gboolean show_all_except;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_;
		gboolean _tmp38_;
		gboolean show_hidden;
		GSettings* _tmp39_;
		gchar* _tmp40_ = NULL;
		gchar* exts;
		const gchar* _tmp41_;
		gchar** _tmp42_;
		gchar** _tmp43_ = NULL;
		gchar** extensions;
		gint extensions_length1;
		gint _extensions_size_;
		GSettings* _tmp44_;
		gchar* _tmp45_ = NULL;
		const gchar* _tmp46_;
		gchar** _tmp47_;
		gchar** _tmp48_ = NULL;
		gchar** clean_extensions;
		gint clean_extensions_length1;
		gint _clean_extensions_size_;
		GtkListStore* _tmp98_;
		_tmp28_ = directory;
		_tmp29_ = g_file_enumerate_children (_tmp28_, "standard::type,standard::display-name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		enumerator = _tmp29_;
		if (_inner_error_ != NULL) {
			goto __catch57_g_error;
		}
		_tmp30_ = self->priv->_settings;
		_tmp31_ = g_settings_get_boolean (_tmp30_, "show-all-files");
		show_all = _tmp31_;
		_tmp32_ = self->priv->_settings;
		_tmp33_ = g_settings_get_boolean (_tmp32_, "show-all-files-except");
		show_all_except = _tmp33_;
		_tmp35_ = show_all;
		if (_tmp35_) {
			GSettings* _tmp36_;
			gboolean _tmp37_ = FALSE;
			_tmp36_ = self->priv->_settings;
			_tmp37_ = g_settings_get_boolean (_tmp36_, "show-hidden-files");
			_tmp34_ = _tmp37_;
		} else {
			_tmp34_ = FALSE;
		}
		_tmp38_ = _tmp34_;
		show_hidden = _tmp38_;
		_tmp39_ = self->priv->_settings;
		_tmp40_ = g_settings_get_string (_tmp39_, "file-extensions");
		exts = _tmp40_;
		_tmp41_ = exts;
		_tmp43_ = _tmp42_ = g_strsplit (_tmp41_, " ", 0);
		extensions = _tmp43_;
		extensions_length1 = _vala_array_length (_tmp42_);
		_extensions_size_ = extensions_length1;
		_tmp44_ = self->priv->_latex_settings;
		_tmp45_ = g_settings_get_string (_tmp44_, "clean-extensions");
		_g_free0 (exts);
		exts = _tmp45_;
		_tmp46_ = exts;
		_tmp48_ = _tmp47_ = g_strsplit (_tmp46_, " ", 0);
		clean_extensions = _tmp48_;
		clean_extensions_length1 = _vala_array_length (_tmp47_);
		_clean_extensions_size_ = clean_extensions_length1;
		{
			GFileEnumerator* _tmp49_;
			GFileInfo* _tmp50_ = NULL;
			GFileInfo* info;
			_tmp49_ = enumerator;
			_tmp50_ = g_file_enumerator_next_file (_tmp49_, NULL, &_inner_error_);
			info = _tmp50_;
			if (_inner_error_ != NULL) {
				clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
				extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (exts);
				_g_object_unref0 (enumerator);
				goto __catch57_g_error;
			}
			{
				gboolean _tmp51_;
				_tmp51_ = TRUE;
				while (TRUE) {
					gboolean _tmp52_;
					GFileInfo* _tmp56_;
					GFileInfo* _tmp57_;
					const gchar* _tmp58_ = NULL;
					gchar* _tmp59_;
					gchar* basename;
					gboolean _tmp60_ = FALSE;
					const gchar* _tmp61_;
					gchar _tmp62_ = '\0';
					gboolean _tmp64_;
					GFileInfo* _tmp65_;
					GFileType _tmp66_ = 0;
					GFileType type;
					GFileType _tmp67_;
					const gchar* _tmp69_;
					gchar* _tmp70_ = NULL;
					gchar* extension;
					gboolean _tmp71_ = FALSE;
					gboolean _tmp72_ = FALSE;
					gboolean _tmp73_ = FALSE;
					gboolean _tmp74_;
					gboolean _tmp76_;
					gboolean _tmp82_;
					gboolean _tmp85_;
					_tmp52_ = _tmp51_;
					if (!_tmp52_) {
						GFileEnumerator* _tmp53_;
						GFileInfo* _tmp54_ = NULL;
						GFileInfo* _tmp55_;
						_tmp53_ = enumerator;
						_tmp54_ = g_file_enumerator_next_file (_tmp53_, NULL, &_inner_error_);
						_tmp55_ = _tmp54_;
						if (_inner_error_ != NULL) {
							_g_object_unref0 (info);
							clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
							extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (exts);
							_g_object_unref0 (enumerator);
							goto __catch57_g_error;
						}
						_g_object_unref0 (info);
						info = _tmp55_;
					}
					_tmp51_ = FALSE;
					_tmp56_ = info;
					if (!(_tmp56_ != NULL)) {
						break;
					}
					_tmp57_ = info;
					_tmp58_ = g_file_info_get_display_name (_tmp57_);
					_tmp59_ = g_strdup (_tmp58_);
					basename = _tmp59_;
					_tmp61_ = basename;
					_tmp62_ = string_get (_tmp61_, (glong) 0);
					if (_tmp62_ == '.') {
						gboolean _tmp63_;
						_tmp63_ = show_hidden;
						_tmp60_ = !_tmp63_;
					} else {
						_tmp60_ = FALSE;
					}
					_tmp64_ = _tmp60_;
					if (_tmp64_) {
						_g_free0 (basename);
						continue;
					}
					_tmp65_ = info;
					_tmp66_ = g_file_info_get_file_type (_tmp65_);
					type = _tmp66_;
					_tmp67_ = type;
					if (_tmp67_ == G_FILE_TYPE_DIRECTORY) {
						const gchar* _tmp68_;
						_tmp68_ = basename;
						file_browser_insert_file (self, TRUE, GTK_STOCK_DIRECTORY, _tmp68_);
						_g_free0 (basename);
						continue;
					}
					_tmp69_ = basename;
					_tmp70_ = utils_get_extension (_tmp69_);
					extension = _tmp70_;
					_tmp74_ = show_all;
					if (_tmp74_) {
						gboolean _tmp75_;
						_tmp75_ = show_all_except;
						_tmp73_ = !_tmp75_;
					} else {
						_tmp73_ = FALSE;
					}
					_tmp76_ = _tmp73_;
					if (_tmp76_) {
						_tmp72_ = TRUE;
					} else {
						gboolean _tmp77_ = FALSE;
						gboolean _tmp78_;
						gboolean _tmp81_;
						_tmp78_ = show_all;
						if (_tmp78_) {
							const gchar* _tmp79_;
							gchar** _tmp80_;
							gint _tmp80__length1;
							_tmp79_ = extension;
							_tmp80_ = clean_extensions;
							_tmp80__length1 = clean_extensions_length1;
							_tmp77_ = !_vala_string_array_contains (_tmp80_, _tmp80__length1, _tmp79_);
						} else {
							_tmp77_ = FALSE;
						}
						_tmp81_ = _tmp77_;
						_tmp72_ = _tmp81_;
					}
					_tmp82_ = _tmp72_;
					if (_tmp82_) {
						_tmp71_ = TRUE;
					} else {
						const gchar* _tmp83_;
						gchar** _tmp84_;
						gint _tmp84__length1;
						_tmp83_ = extension;
						_tmp84_ = extensions;
						_tmp84__length1 = extensions_length1;
						_tmp71_ = _vala_string_array_contains (_tmp84_, _tmp84__length1, _tmp83_);
					}
					_tmp85_ = _tmp71_;
					if (_tmp85_) {
						gchar* pixbuf = NULL;
						const gchar* _tmp86_;
						const gchar* _tmp87_;
						GQuark _tmp89_ = 0U;
						static GQuark _tmp88_label0 = 0;
						static GQuark _tmp88_label1 = 0;
						static GQuark _tmp88_label2 = 0;
						static GQuark _tmp88_label3 = 0;
						static GQuark _tmp88_label4 = 0;
						static GQuark _tmp88_label5 = 0;
						static GQuark _tmp88_label6 = 0;
						static GQuark _tmp88_label7 = 0;
						static GQuark _tmp88_label8 = 0;
						static GQuark _tmp88_label9 = 0;
						static GQuark _tmp88_label10 = 0;
						static GQuark _tmp88_label11 = 0;
						const gchar* _tmp96_;
						const gchar* _tmp97_;
						_tmp86_ = extension;
						_tmp87_ = _tmp86_;
						_tmp89_ = (NULL == _tmp87_) ? 0 : g_quark_from_string (_tmp87_);
						if (_tmp89_ == ((0 != _tmp88_label0) ? _tmp88_label0 : (_tmp88_label0 = g_quark_from_static_string (".tex")))) {
							switch (0) {
								default:
								{
									gchar* _tmp90_;
									_tmp90_ = g_strdup (GTK_STOCK_EDIT);
									_g_free0 (pixbuf);
									pixbuf = _tmp90_;
									break;
								}
							}
						} else if (_tmp89_ == ((0 != _tmp88_label1) ? _tmp88_label1 : (_tmp88_label1 = g_quark_from_static_string (".pdf")))) {
							switch (0) {
								default:
								{
									gchar* _tmp91_;
									_tmp91_ = g_strdup ("view_pdf");
									_g_free0 (pixbuf);
									pixbuf = _tmp91_;
									break;
								}
							}
						} else if (_tmp89_ == ((0 != _tmp88_label2) ? _tmp88_label2 : (_tmp88_label2 = g_quark_from_static_string (".dvi")))) {
							switch (0) {
								default:
								{
									gchar* _tmp92_;
									_tmp92_ = g_strdup ("view_dvi");
									_g_free0 (pixbuf);
									pixbuf = _tmp92_;
									break;
								}
							}
						} else if ((_tmp89_ == ((0 != _tmp88_label3) ? _tmp88_label3 : (_tmp88_label3 = g_quark_from_static_string (".ps")))) || (_tmp89_ == ((0 != _tmp88_label4) ? _tmp88_label4 : (_tmp88_label4 = g_quark_from_static_string (".eps"))))) {
							switch (0) {
								default:
								{
									gchar* _tmp93_;
									_tmp93_ = g_strdup ("view_ps");
									_g_free0 (pixbuf);
									pixbuf = _tmp93_;
									break;
								}
							}
						} else if (((((((_tmp89_ == ((0 != _tmp88_label5) ? _tmp88_label5 : (_tmp88_label5 = g_quark_from_static_string (".png")))) || (_tmp89_ == ((0 != _tmp88_label6) ? _tmp88_label6 : (_tmp88_label6 = g_quark_from_static_string (".jpg"))))) || (_tmp89_ == ((0 != _tmp88_label7) ? _tmp88_label7 : (_tmp88_label7 = g_quark_from_static_string (".jpeg"))))) || (_tmp89_ == ((0 != _tmp88_label8) ? _tmp88_label8 : (_tmp88_label8 = g_quark_from_static_string (".gif"))))) || (_tmp89_ == ((0 != _tmp88_label9) ? _tmp88_label9 : (_tmp88_label9 = g_quark_from_static_string (".bmp"))))) || (_tmp89_ == ((0 != _tmp88_label10) ? _tmp88_label10 : (_tmp88_label10 = g_quark_from_static_string (".tif"))))) || (_tmp89_ == ((0 != _tmp88_label11) ? _tmp88_label11 : (_tmp88_label11 = g_quark_from_static_string (".tiff"))))) {
							switch (0) {
								default:
								{
									gchar* _tmp94_;
									_tmp94_ = g_strdup ("image");
									_g_free0 (pixbuf);
									pixbuf = _tmp94_;
									break;
								}
							}
						} else {
							switch (0) {
								default:
								{
									gchar* _tmp95_;
									_tmp95_ = g_strdup (GTK_STOCK_FILE);
									_g_free0 (pixbuf);
									pixbuf = _tmp95_;
									break;
								}
							}
						}
						_tmp96_ = pixbuf;
						_tmp97_ = basename;
						file_browser_insert_file (self, FALSE, _tmp96_, _tmp97_);
						_g_free0 (pixbuf);
					}
					_g_free0 (extension);
					_g_free0 (basename);
				}
			}
			_g_object_unref0 (info);
		}
		_tmp98_ = self->priv->_list_store;
		gtk_tree_sortable_sort_column_changed ((GtkTreeSortable*) _tmp98_);
		clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
		extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (exts);
		_g_object_unref0 (enumerator);
	}
	goto __finally57;
	__catch57_g_error:
	{
		GError* e = NULL;
		GError* _tmp99_;
		const gchar* _tmp100_;
		MainWindow* _tmp101_;
		const gchar* _tmp102_ = NULL;
		GtkMessageDialog* _tmp103_;
		GtkMessageDialog* dialog;
		GtkMessageDialog* _tmp104_;
		GError* _tmp105_;
		const gchar* _tmp106_;
		GtkMessageDialog* _tmp107_;
		GtkMessageDialog* _tmp108_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp99_ = e;
		_tmp100_ = _tmp99_->message;
		g_warning ("file_browser.vala:409: %s", _tmp100_);
		_tmp101_ = self->priv->_main_window;
		_tmp102_ = _ ("File Browser");
		_tmp103_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp101_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_CLOSE, "%s", _tmp102_);
		g_object_ref_sink (_tmp103_);
		dialog = _tmp103_;
		_tmp104_ = dialog;
		_tmp105_ = e;
		_tmp106_ = _tmp105_->message;
		gtk_message_dialog_format_secondary_text (_tmp104_, "%s", _tmp106_);
		_tmp107_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp107_);
		_tmp108_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp108_);
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
		_g_object_unref0 (directory);
		return;
	}
	__finally57:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (directory);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	parent_dirs = NULL;
	_tmp109_ = directory;
	_tmp110_ = _g_object_ref0 (_tmp109_);
	parent_dirs = g_list_prepend (parent_dirs, _tmp110_);
	_tmp111_ = directory;
	_tmp112_ = _g_object_ref0 (_tmp111_);
	current_dir = _tmp112_;
	while (TRUE) {
		GFile* _tmp113_;
		GFile* _tmp114_ = NULL;
		GFile* parent;
		GFile* _tmp115_;
		GFile* _tmp116_;
		GFile* _tmp117_;
		GFile* _tmp118_;
		GFile* _tmp119_;
		_tmp113_ = current_dir;
		_tmp114_ = g_file_get_parent (_tmp113_);
		parent = _tmp114_;
		_tmp115_ = parent;
		if (_tmp115_ == NULL) {
			_g_object_unref0 (parent);
			break;
		}
		_tmp116_ = parent;
		_tmp117_ = _g_object_ref0 (_tmp116_);
		parent_dirs = g_list_prepend (parent_dirs, _tmp117_);
		_tmp118_ = parent;
		_tmp119_ = _g_object_ref0 (_tmp118_);
		_g_object_unref0 (current_dir);
		current_dir = _tmp119_;
		_g_object_unref0 (parent);
	}
	iter = _tmp120_;
	i = 0;
	_tmp121_ = parent_dirs;
	{
		GList* current_collection = NULL;
		GList* current_it = NULL;
		current_collection = _tmp121_;
		for (current_it = current_collection; current_it != NULL; current_it = current_it->next) {
			GFile* _tmp122_;
			GFile* current = NULL;
			_tmp122_ = _g_object_ref0 ((GFile*) current_it->data);
			current = _tmp122_;
			{
				gchar* basename = NULL;
				gint _tmp123_;
				gchar* pixbuf = NULL;
				gint _tmp128_;
				GtkListStore* _tmp137_;
				GtkTreeIter _tmp138_ = {0};
				GtkListStore* _tmp139_;
				GtkTreeIter _tmp140_;
				GFile* _tmp141_;
				const gchar* _tmp142_;
				const gchar* _tmp143_;
				gint _tmp144_;
				_tmp123_ = i;
				if (_tmp123_ == 0) {
					const gchar* _tmp124_ = NULL;
					gchar* _tmp125_;
					_tmp124_ = _ ("File System");
					_tmp125_ = g_strdup (_tmp124_);
					_g_free0 (basename);
					basename = _tmp125_;
				} else {
					GFile* _tmp126_;
					gchar* _tmp127_ = NULL;
					_tmp126_ = current;
					_tmp127_ = g_file_get_basename (_tmp126_);
					_g_free0 (basename);
					basename = _tmp127_;
				}
				_tmp128_ = i;
				if (_tmp128_ == 0) {
					gchar* _tmp129_;
					_tmp129_ = g_strdup (GTK_STOCK_HARDDISK);
					_g_free0 (pixbuf);
					pixbuf = _tmp129_;
				} else {
					const gchar* _tmp130_ = NULL;
					GFile* _tmp131_;
					gchar* _tmp132_ = NULL;
					gchar* _tmp133_;
					gboolean _tmp134_;
					_tmp130_ = g_get_home_dir ();
					_tmp131_ = current;
					_tmp132_ = g_file_get_path (_tmp131_);
					_tmp133_ = _tmp132_;
					_tmp134_ = g_strcmp0 (_tmp130_, _tmp133_) == 0;
					_g_free0 (_tmp133_);
					if (_tmp134_) {
						gchar* _tmp135_;
						_tmp135_ = g_strdup (GTK_STOCK_HOME);
						_g_free0 (pixbuf);
						pixbuf = _tmp135_;
					} else {
						gchar* _tmp136_;
						_tmp136_ = g_strdup (GTK_STOCK_DIRECTORY);
						_g_free0 (pixbuf);
						pixbuf = _tmp136_;
					}
				}
				_tmp137_ = self->priv->_parent_dir_store;
				gtk_list_store_append (_tmp137_, &_tmp138_);
				iter = _tmp138_;
				_tmp139_ = self->priv->_parent_dir_store;
				_tmp140_ = iter;
				_tmp141_ = current;
				_tmp142_ = basename;
				_tmp143_ = pixbuf;
				gtk_list_store_set (_tmp139_, &_tmp140_, FILE_BROWSER_PARENT_DIR_COLUMN_FILE, _tmp141_, FILE_BROWSER_PARENT_DIR_COLUMN_NAME, _tmp142_, FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, _tmp143_, -1, -1);
				_tmp144_ = i;
				i = _tmp144_ + 1;
				_g_free0 (pixbuf);
				_g_free0 (basename);
				_g_object_unref0 (current);
			}
		}
	}
	_tmp145_ = directory;
	_tmp146_ = _g_object_ref0 (_tmp145_);
	_g_object_unref0 (self->priv->_current_directory);
	self->priv->_current_directory = _tmp146_;
	_tmp147_ = self->priv->_settings;
	_tmp148_ = directory;
	_tmp149_ = g_file_get_uri (_tmp148_);
	_tmp150_ = _tmp149_;
	g_settings_set_string (_tmp147_, "current-directory", _tmp150_);
	_g_free0 (_tmp150_);
	_tmp151_ = self->priv->_combo_box;
	_tmp152_ = iter;
	gtk_combo_box_set_active_iter (_tmp151_, &_tmp152_);
	_tmp153_ = self->priv->_parent_button;
	_tmp154_ = directory;
	_tmp155_ = g_file_get_parent (_tmp154_);
	_tmp156_ = _tmp155_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp153_, _tmp156_ != NULL);
	_g_object_unref0 (_tmp156_);
	_g_object_unref0 (current_dir);
	__g_list_free__g_object_unref0_0 (parent_dirs);
	_g_object_unref0 (directory);
}


static void file_browser_insert_file (FileBrowser* self, gboolean is_dir, const gchar* pixbuf, const gchar* basename) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	g_return_if_fail (basename != NULL);
	_tmp0_ = self->priv->_list_store;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = self->priv->_list_store;
	_tmp3_ = iter;
	_tmp4_ = is_dir;
	_tmp5_ = pixbuf;
	_tmp6_ = basename;
	gtk_list_store_set (_tmp2_, &_tmp3_, FILE_BROWSER_FILE_COLUMN_IS_DIR, _tmp4_, FILE_BROWSER_FILE_COLUMN_PIXBUF, _tmp5_, FILE_BROWSER_FILE_COLUMN_NAME, _tmp6_, -1, -1);
}


static gint file_browser_on_sort (FileBrowser* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b) {
	gint result = 0;
	gboolean a_is_dir = FALSE;
	gboolean b_is_dir = FALSE;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp13_ = 0;
	gboolean _tmp14_;
	gint _tmp15_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = model;
	_tmp1_ = *a;
	gtk_tree_model_get (_tmp0_, &_tmp1_, FILE_BROWSER_FILE_COLUMN_IS_DIR, &a_is_dir, -1, -1);
	_tmp2_ = model;
	_tmp3_ = *b;
	gtk_tree_model_get (_tmp2_, &_tmp3_, FILE_BROWSER_FILE_COLUMN_IS_DIR, &b_is_dir, -1, -1);
	_tmp4_ = a_is_dir;
	_tmp5_ = b_is_dir;
	if (_tmp4_ == _tmp5_) {
		gchar* a_name = NULL;
		gchar* b_name = NULL;
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
		GtkTreeModel* _tmp8_;
		GtkTreeIter _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_ = 0;
		_tmp6_ = model;
		_tmp7_ = *a;
		gtk_tree_model_get (_tmp6_, &_tmp7_, FILE_BROWSER_FILE_COLUMN_NAME, &a_name, -1, -1);
		_tmp8_ = model;
		_tmp9_ = *b;
		gtk_tree_model_get (_tmp8_, &_tmp9_, FILE_BROWSER_FILE_COLUMN_NAME, &b_name, -1, -1);
		_tmp10_ = a_name;
		_tmp11_ = b_name;
		_tmp12_ = g_utf8_collate (_tmp10_, _tmp11_);
		result = _tmp12_;
		_g_free0 (b_name);
		_g_free0 (a_name);
		return result;
	}
	_tmp14_ = a_is_dir;
	if (_tmp14_) {
		_tmp13_ = -1;
	} else {
		_tmp13_ = +1;
	}
	_tmp15_ = _tmp13_;
	result = _tmp15_;
	return result;
}


static void file_browser_class_init (FileBrowserClass * klass) {
	file_browser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FileBrowserPrivate));
	G_OBJECT_CLASS (klass)->finalize = file_browser_finalize;
}


static void file_browser_instance_init (FileBrowser * self) {
	self->priv = FILE_BROWSER_GET_PRIVATE (self);
	self->priv->_timeout_id = (guint) 0;
}


static void file_browser_finalize (GObject* obj) {
	FileBrowser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_BROWSER, FileBrowser);
	_g_object_unref0 (self->priv->_parent_dir_store);
	_g_object_unref0 (self->priv->_list_store);
	_g_object_unref0 (self->priv->_list_view);
	_g_object_unref0 (self->priv->_combo_box);
	_g_object_unref0 (self->priv->_current_directory);
	_g_object_unref0 (self->priv->_parent_button);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_latex_settings);
	G_OBJECT_CLASS (file_browser_parent_class)->finalize (obj);
}


GType file_browser_get_type (void) {
	static volatile gsize file_browser_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FileBrowserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_browser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileBrowser), 0, (GInstanceInitFunc) file_browser_instance_init, NULL };
		GType file_browser_type_id;
		file_browser_type_id = g_type_register_static (GTK_TYPE_GRID, "FileBrowser", &g_define_type_info, 0);
		g_once_init_leave (&file_browser_type_id__volatile, file_browser_type_id);
	}
	return file_browser_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



