#include "GridLayout.h"


GridLayout::GridLayout(Widget *parent, int nRows, int nCols, int border=0,
	   int autoBorder=-1, const char* name=0)
{
  if(parent)
    setLayout(new QGridLayout(parent->widget, nRows, nCols, border, autoBorder,
			      name));
  else
    printf("GridLayout: MUST HAVE WIDGET!\n");
	      
}

GridLayout::GridLayout(int nRows, int nCols, int autoBorder=-1,
	   const char* name=0)
{
  setLayout(new QGridLayout(nRows, nCols, autoBorder, name));
}


GridLayout::~GridLayout()
{
 
}

void GridLayout::addWidget(Widget *w, int row, int col, int align=0)
{
  if(w)
    gridlayout->addWidget(w->widget, row, col, align);
  else
    gridlayout->addWidget(NULL, row, col, align);
}

void GridLayout::addMultiCellWidget(Widget *w, int fromRow, int toRow,
			int fromCol, int toCol, int align=0)
{
  if(w)
    gridlayout->addMultiCellWidget(w->widget,fromRow, toRow, 
				   fromCol, toCol, align);
  else
    gridlayout->addMultiCellWidget(NULL,fromRow,toRow,fromCol,toCol,align);
}

void GridLayout::addLayout(Layout *layout, int row, int col)
{
  gridlayout->addLayout(layout->layout,row,col);
}

void GridLayout::setRowStretch(int row, int stretch)
{
  gridlayout->setRowStretch(row,stretch);
}

void GridLayout::setColStretch(int col, int stretch)
{
  gridlayout->setColStretch(col,stretch);
}

void GridLayout::setLayout(QGridLayout *gl)
{
  gridlayout = gl;
  Layout::setLayout((QLayout*)gl);
}
