/*
 * This file is part of the DOM implementation for KDE.
 *
 * Copyright 2003 Lars Knoll (knoll@kde.org)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file is mostly data generated by flex. Unfortunately flex
   can't handle 16bit strings directly, so we just copy the part of
   the code we need and modify it to our needs.

   Most of the defines below are to make sure we can easily use the
   flex generated code, using as little editing as possible.

   The flex syntax to generate the lexer are more or less directly
   copied from the CSS2.1 specs, with some fixes for comments and
   the important symbol.

   To regenerate, run flex on tokenizer.flex. After this, copy the
   data tables and the YY_DECL method over to this file. Remove the
   init code from YY_DECL and change the YY_END_OF_BUFFER to only call
   yyterminate().

*/

// --------- begin generated code -------------------


#include "parser.h"

#define INITIAL 0
#define mediaquery 1
#define at_rule 2
#define block 3

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */
#define YY_NUM_RULES 66
#define YY_END_OF_BUFFER 67
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[409] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,   67,   65,
        2,    2,   65,   65,   65,   65,   65,   65,   65,   65,
       65,   65,   51,   65,   65,   14,   14,   14,   65,   65,
       59,   65,   65,   65,   51,   64,   14,   14,   14,   63,
       61,   60,   65,   62,    2,    0,    0,    0,   13,    0,
        0,   17,    0,    8,    0,    0,    9,    0,   15,    0,
       14,   14,    0,   52,    0,   50,    0,    0,   51,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   15,   49,
       49,   44,    0,   49,    0,    0,    0,    0,    0,    0,
        0,    0,   56,   14,    0,    0,    0,   14,   14,    0,

       14,   14,   14,    7,    6,    5,   52,    0,   51,   49,
       14,   14,   14,    0,   17,    0,    0,    0,   13,    0,
        0,   17,    0,   17,   17,    0,    0,   13,    0,    0,
        4,    0,    0,   49,    0,   33,   35,   49,   30,   32,
       49,   45,   37,   49,   36,   43,   49,   39,   38,   34,
       49,   49,   49,   49,    0,    0,    0,    0,    0,    0,
        0,    0,   14,   14,    0,   15,   14,   14,   57,   57,
       14,   14,   49,   12,   10,   14,    0,   17,    0,    0,
        0,   17,   17,   17,    0,    0,    0,    1,   49,   49,
       40,   49,   48,   15,   41,   49,   49,    3,    0,    0,

        0,    0,    0,    0,    0,   14,   53,    0,   57,   57,
       57,   56,   14,   49,   46,   11,   16,   16,    0,    0,
       17,   17,    0,    0,    0,   49,   42,   49,   49,    0,
        0,    0,    0,    0,    0,   19,   14,   58,   57,   57,
       57,   57,    0,    0,    0,    0,   55,    0,   14,   47,
        0,   17,    0,    0,   17,   17,    0,   49,   49,   31,
        0,    0,    0,    0,   20,    0,   14,   58,   57,   57,
       57,   57,   57,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   55,    0,    0,   14,    0,   17,    0,    0,
       17,   17,    0,   49,   49,    0,    0,    0,   18,    0,

       14,   58,   57,   57,   57,   57,   57,   57,    0,   54,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,   14,   16,   16,    0,    0,   17,   17,    0,   49,
       49,    0,   22,    0,    0,   14,   58,   57,   57,   57,
       57,   57,   57,   57,    0,   54,    0,    0,    0,   54,
        0,    0,    0,    0,   17,   49,    0,    0,    0,    0,
        0,    0,    0,   58,    0,    0,    0,   29,    0,    0,
        0,    0,    0,   21,   23,   58,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   24,
        0,    0,    0,    0,   25,    0,    0,   26,    0,    0,

        0,    0,    0,    0,    0,   27,   28,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    4,    5,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    7,    8,    9,   10,   11,   12,   13,   14,
       15,   16,   17,   12,   18,   19,   20,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   12,   22,   23,
       24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
       34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
       44,   45,   46,   47,   48,   49,   37,   50,   51,   52,
       12,   53,   12,   54,   55,   12,   56,   29,   57,   58,

       59,   60,   61,   62,   63,   37,   64,   65,   66,   67,
       68,   69,   70,   71,   72,   73,   74,   75,   37,   76,
       77,   78,   79,   80,   81,   82,    1,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,

       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   83
    } ;

static yyconst flex_int32_t yy_meta[84] =
    {   0,
        1,    2,    3,    3,    3,    4,    4,    4,    4,    4,
        4,    4,    4,    5,    4,    4,    4,    6,    4,    4,
        7,    4,    4,    4,    4,    8,    4,    9,    9,    9,
        9,    9,    9,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,    4,   10,    9,    9,    9,    9,    9,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,    4,    4,
        4,    4,   10
    } ;

static yyconst flex_int16_t yy_base[442] =
    {   0,
        0,    0,   65,   69,   63,   67,   83,   86, 1236, 2814,
       96,  110,  124,   86,   78, 1191,   90, 1183,   83,   99,
     1185, 1189,  177, 1184,  243,   94,  260,  254,  259, 1166,
     2814, 1152, 1151, 1140,  132, 2814,  104,  318,  108, 2814,
     2814, 2814,  369, 2814,  174,  291,   69,  115, 2814,  428,
      101, 1107,  309, 2814,  121,  487, 2814,  117,  341, 1120,
      141,  371,  351,  329, 1127, 2814, 1073, 1103,    0, 1033,
      381,  138,  232,  128,  300,  350,  384,  398,  507,  422,
      203, 1003,  473,  130, 1037,  118,  124,  233,  265,  297,
      113,  144, 2814,  341,  506,  550,  567,  572,  392, 1000,

      401,  400,  624, 2814, 2814, 2814,  564, 1004,  560,  555,
      468,  537,  409,  611,  664,  349,  470,  261,  273,  723,
      782,  961,  630,  920,  841,  546,  298,  351,  900,  959,
     2814,  938,  173,  884,  677,  883,  881,  359,  871,  870,
      427,  867,  834,  389,  797,  795,  697,  784,  766,  765,
      549,  748, 1018,  550,  778,  299,  407,  409,  428,  483,
      456,  548,  454, 1077,  644,  742,  536,  544,  331,  721,
      547,  683,  735,  582,  619,  716,  795,  801,  569,  611,
      835,  626, 1136,  886,  621,  919,  662, 2814,  623, 1195,
      620,  715,  613,  342,  564,  972,  713, 2814,  685,  693,

      701,  707,  726,  738,  745,  978, 2814, 1031,  387,  580,
      578,  873, 1037,  754,  548,  622, 1071, 1090,  746, 1123,
     1181, 1201, 1214,  576,  596, 1235,  495, 1248,  755,  842,
      837,  524,  839,  663,  839, 2814, 1254, 1268,  595,  502,
      467,  451, 1327, 1341,  749,  746, 2814, 1393, 1329,  309,
     1399, 1412,  849, 1433, 1446, 1452, 1466, 1486, 1499,  280,
      873,  746,  776,  892, 2814,  898, 1519, 1532,  597,  278,
      244,  241,  232,  979,  753, 1038, 1591,  747, 1650, 1362,
     1603, 1623, 1662, 1714, 1773, 1733, 1779, 1792,  899, 1813,
     1826, 1832, 1846, 1866, 1879,  239,  922,  940, 2814,  942,

     1899, 1912,  948,  178,  177,  176,  175,  166, 1110, 2814,
     1155,  872, 1683, 1971, 2030, 1338,  836, 1983, 2089, 2148,
     2207, 1984, 2814, 1990,  930, 2047, 2106, 1168, 2167, 2213,
     2226, 2247, 2814,  956,  997, 1182, 2269,   87, 2814, 2814,
     2814, 2814, 2814, 2814, 2306,  882, 1064, 2309, 2330, 1020,
     1032, 2342, 2356, 1130, 1215, 1313, 1025, 1100, 1130, 1130,
     1234, 1277, 1289, 2375, 2389, 2408, 2422, 2814, 1322, 1324,
     1298, 1335, 1337, 2814, 2814, 2814, 2441, 2455, 2474, 1339,
     1347, 1352, 1358, 1344, 2488, 2507, 2521, 1347, 1325, 2814,
     1379, 1380, 1531, 1746, 2814, 1390, 1494, 2814, 1506, 1529,

     1454, 1527, 1529, 1541, 1553, 2814, 2814, 2814, 2580, 2585,
     2594, 2599, 2605, 2612, 2621, 2626, 2633, 2642, 2652, 2654,
     2659, 2666, 2673, 2677, 2683, 2693, 2700, 2705, 2714, 2719,
     2727, 2737, 2742, 2750, 2759, 2768, 2773, 2781, 2790, 2795,
     2803
    } ;

static yyconst flex_int16_t yy_def[442] =
    {   0,
      408,    1,    1,    1,    1,    1,    1,    1,  408,  408,
      408,  408,  408,  409,  410,  408,  411,  408,  408,  412,
      408,  408,  408,  408,  408,  413,  413,  413,  414,  408,
      408,  408,  408,  408,   23,  408,  413,  413,  413,  408,
      408,  408,  410,  408,  408,  408,  408,  409,  408,  415,
      410,  416,  417,  408,  411,  418,  408,  408,  408,  408,
      413,  413,  414,   23,  419,  408,  420,  408,   23,  421,
      421,  421,  421,  421,  421,  421,  421,  421,  421,  421,
      421,  421,  422,  421,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  413,  423,  408,  408,  413,  413,  424,

      413,  413,  413,  408,  408,  408,   23,  408,   23,  421,
      413,  413,  413,  408,  416,  408,  409,  409,  409,  409,
      415,  416,  425,  416,  115,  411,  411,  411,  411,  418,
      408,  419,  426,  421,  427,  421,  421,  421,  421,  421,
      421,  421,  421,  421,  421,  421,  421,  421,  421,  421,
      421,  421,  421,  421,  408,  408,  408,  408,  408,  408,
      408,  408,  413,  103,  408,  408,  413,  413,  428,  408,
      413,  103,  421,  413,  413,  413,  408,  115,  408,  409,
      120,  416,  115,  125,  411,  129,  429,  408,  421,  153,
      421,  421,  421,  421,  421,  153,  421,  408,  408,  408,

      408,  408,  408,  408,  408,  164,  408,  408,  430,  408,
      408,  431,  103,  421,  421,  413,  408,  115,  408,  120,
      183,  125,  129,  429,  432,  190,  421,  153,  421,  408,
      408,  408,  408,  408,  408,  408,  164,  408,  433,  408,
      408,  408,  431,  431,  434,  435,  408,  436,  103,  421,
      408,  115,  408,  120,  183,  125,  129,  190,  153,  421,
      408,  408,  408,  408,  408,  408,  164,  408,  437,  408,
      408,  408,  408,  408,  434,  408,  438,  435,  439,  431,
      431,  431,  431,  431,  436,  249,  408,  115,  408,  120,
      183,  125,  129,  190,  153,  408,  408,  408,  408,  408,

      164,  408,  440,  408,  408,  408,  408,  408,  408,  408,
      434,  434,  434,  434,  438,  435,  435,  435,  435,  441,
      431,  286,  408,  115,  408,  120,  183,  324,  129,  190,
      153,  408,  408,  408,  408,  322,  408,  408,  408,  408,
      408,  408,  408,  408,  434,  434,  434,  314,  435,  435,
      435,  319,  321,  408,  324,  331,  408,  408,  408,  408,
      408,  408,  408,  408,  314,  319,  321,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  314,  319,  321,  408,
      408,  408,  408,  408,  314,  319,  321,  408,  408,  408,
      408,  408,  434,  435,  408,  408,  408,  408,  408,  408,

      408,  408,  408,  408,  408,  408,  408,    0,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408
    } ;

static yyconst flex_int16_t yy_nxt[2898] =
    {   0,
       10,   11,   12,   11,   11,   11,   13,   14,   15,   16,
       10,   10,   17,   10,   10,   18,   19,   20,   21,   22,
       23,   10,   24,   10,   10,   10,   25,   26,   26,   26,
       26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
       27,   26,   26,   26,   26,   26,   26,   28,   26,   26,
       26,   26,   29,   30,   26,   26,   26,   26,   26,   26,
       26,   26,   26,   26,   26,   26,   27,   26,   26,   26,
       26,   26,   26,   28,   26,   26,   26,   26,   31,   32,
       10,   33,   26,   34,   41,   35,   36,   34,   41,   35,
       36,   43,   37,   49,   43,   51,   37,   45,   45,   45,

       45,   45,   49,   58,  208,   38,   39,   93,  116,   38,
       39,   45,   45,   45,   45,   45,   60,   93,  408,   58,
       37,   93,   49,   59,   37,   46,   46,   46,   46,   46,
       53,   38,   39,   49,  116,   38,   39,   58,   50,   62,
      161,   42,   56,   40,  111,   42,   95,   40,  113,   59,
      108,   63,  109,   53,   93,  156,   95,   59,  157,   47,
       95,   10,  110,   44,   10,   62,   44,   50,  161,  138,
      111,  162,  141,   56,  113,   45,   45,   45,   45,   45,
      135,  156,  135,   59,  154,  157,   47,   66,  133,  110,
      135,  344,  188,   95,   67,   68,  138,   69,  141,  162,

      343,  342,  341,  340,   70,   70,   71,   72,   73,   70,
       74,   75,   76,   70,   77,   70,   78,   79,   70,   80,
       70,   81,   82,   70,   70,   70,   70,   70,   70,   83,
      151,   84,   70,   71,   72,   73,   70,   74,   75,   76,
       77,   70,   78,   79,   70,   80,   70,   81,   82,   70,
       70,   70,   70,   70,   70,  135,  332,  308,  151,   70,
       86,   96,   96,   96,   96,   96,  307,   93,   49,  306,
      100,  139,   87,   93,  158,   88,   97,   98,   89,  103,
       49,  140,   90,   91,  135,   92,  103,  103,  103,  103,
      103,  103,   46,   46,   46,   46,   46,  139,  101,   87,

      158,   99,   88,  305,  159,   89,   95,  140,   90,   91,
       49,   92,   95,   50,  103,  103,  103,  103,  103,   96,
       96,   96,   96,   96,  101,   50,   47,   99,  160,  125,
      159,   93,  135,  199,   97,   98,  125,  125,  125,  125,
      125,  125,   96,   96,   96,   96,   96,  408,  208,   64,
       56,  142,  135,   47,   93,  160,  210,   97,   97,  112,
      199,  135,  194,   49,  125,  125,  125,  125,  125,   70,
       95,  103,   96,   96,   96,   96,   96,  142,  103,  103,
      103,  103,  103,  103,   93,  112,   51,   97,   98,  114,
      143,  179,  191,   95,  135,   70,  115,  115,  115,  115,

      115,  115,  135,   56,  208,   93,  103,  103,  103,  103,
      103,  135,  240,   93,   93,  136,  143,  179,  144,  191,
      137,   53,   93,   95,  115,  115,  115,  115,  115,   48,
       48,   48,  117,  135,  200,  119,  135,  145,  168,  171,
      193,  135,  136,  146,   95,  144,  137,  176,  120,  201,
      135,  148,   95,   95,  192,  120,  120,  120,  120,  120,
      120,   95,  200,  145,  168,  171,  193,   93,  149,  146,
      202,  150,   48,  176,  135,  201,  273,   49,  148,  135,
      121,   93,  192,  120,  120,  120,  120,  120,   55,   55,
       55,  126,  272,  153,  149,  204,  202,  150,  174,  128,

      153,  153,  153,  153,  153,  153,   95,  129,   96,   96,
       96,   96,   96,  203,  129,  129,  129,  129,  129,  129,
       95,  204,   50,   97,  147,  174,  164,  271,  153,  153,
      153,  153,  153,  164,  164,  164,  164,  164,  164,  130,
      203,  263,  129,  129,  129,  129,  129,  135,   55,   93,
       93,   96,   96,   96,   96,   96,  167,  207,   49,  135,
      212,  164,  164,  164,  164,  164,   97,   97,  165,  165,
      165,  165,  165,  165,  165,  165,  165,  165,  108,  195,
      109,  205,  408,  175,  107,   93,  138,  166,   95,   95,
      110,  225,  167,  197,  110,   93,   95,  173,   56,   95,

      135,  135,  135,  242,   70,  241,  195,  135,  205,  175,
      219,  225,  208,  138,  208,  188,  135,  110,   49,  197,
      270,  110,  304,  173,   95,  102,  102,  102,  102,  102,
       70,  177,  207,   49,   95,   93,  219,   93,  177,  177,
      177,  177,  177,  177,  172,  165,  165,  165,  165,  165,
      183,  172,  172,  172,  172,  172,  172,  183,  183,  183,
      183,  183,  183,   50,  166,  135,  177,  177,  177,  177,
      177,   95,  135,   56,   95,  135,   95,  225,  123,  172,
      172,  172,  172,  172,  178,  183,  183,  183,  183,  183,
      265,  178,  178,  178,  178,  178,  178,  190,  165,  165,

      165,  165,  165,  213,  190,  190,  190,  190,  190,  190,
      213,  213,  213,  213,  213,  213,  123,  194,  265,  178,
      178,  178,  178,  178,  118,  180,  180,  180,  118,   93,
       49,  230,  190,  190,  190,  190,  190,  231,  213,  213,
      213,  213,  213,  181,  229,  227,  211,  232,  233,  135,
      181,  181,  181,  181,  181,  181,  276,  230,  276,  276,
      276,  234,  166,  231,  214,  135,  216,  135,   95,  235,
      215,  229,  227,  232,  233,   50,  236,  297,  181,  181,
      181,  181,  181,   48,   48,   48,  117,  135,  234,  119,
      253,  214,  216,  250,  260,  198,  235,  215,  279,  279,

      135,  277,  120,  236,  297,  277,  135,  135,  298,  120,
      120,  120,  120,  120,  120,  217,  253,  135,  135,  250,
      260,  218,  217,  217,  217,  217,  217,  217,  218,  218,
      218,  218,  218,  218,  121,  298,  135,  120,  120,  120,
      120,  120,  124,  124,  124,  124,  124,  135,  276,  135,
      217,  217,  217,  217,  217,  220,  218,  218,  218,  218,
      218,  184,  220,  220,  220,  220,  220,  220,  184,  184,
      184,  184,  184,  184,  243,  243,  243,  243,  243,  276,
      245,  261,  262,  264,  266,  246,  135,  247,  279,  276,
      220,  220,  220,  220,  220,  289,  184,  184,  184,  184,

      184,  127,  185,  185,  185,  127,  222,  261,  262,  264,
      266,  296,   49,  222,  222,  222,  222,  222,  222,  135,
      186,  289,  135,  135,  277,  248,  325,  186,  186,  186,
      186,  186,  186,  135,  277,  135,  135,  296,  299,  223,
      300,  222,  222,  222,  222,  222,  223,  223,  223,  223,
      223,  223,   56,  133,  325,  186,  186,  186,  186,  186,
       55,   55,   55,  126,  299,  208,  300,  334,  333,  335,
      354,  128,  123,  339,  223,  223,  223,  223,  223,  129,
      274,  274,  274,  274,  274,  362,  129,  129,  129,  129,
      129,  129,  228,  247,  333,  334,  354,  335,  237,  228,

      228,  228,  228,  228,  228,  237,  237,  237,  237,  237,
      237,  130,  362,  123,  129,  129,  129,  129,  129,  152,
      152,  152,  152,  152,  107,  170,  363,  228,  228,  228,
      228,  228,  276,  237,  237,  237,  237,  237,  196,  309,
      309,  309,  309,  309,  276,  196,  196,  196,  196,  196,
      196,  238,  310,  363,  155,  135,  369,  249,  238,  238,
      238,  238,  238,  238,  249,  249,  249,  249,  249,  249,
      135,  276,  279,  196,  196,  196,  196,  196,  163,  163,
      163,  163,  163,  369,  279,  135,  238,  238,  238,  238,
      238,  251,  249,  249,  249,  249,  249,  206,  251,  251,

      251,  251,  251,  251,  206,  206,  206,  206,  206,  206,
      252,  309,  309,  309,  309,  309,  277,  252,  252,  252,
      252,  252,  252,   64,  310,   83,  251,  251,  251,  251,
      251,  370,  206,  206,  206,  206,  206,  182,  182,  182,
      182,  182,  133,  254,  131,  252,  252,  252,  252,  252,
      254,  254,  254,  254,  254,  254,  221,  275,  370,  123,
      107,  372,  276,  221,  221,  221,  221,  221,  221,  124,
      124,  124,  124,  124,  106,  105,  368,  371,  254,  254,
      254,  254,  254,  163,  163,  163,  163,  163,  372,  104,
       85,  221,  221,  221,  221,  221,  189,  189,  189,  189,

      189,  255,  368,  371,   65,   64,   57,  277,  255,  255,
      255,  255,  255,  255,   54,  226,  182,  182,  182,  182,
      182,  256,  226,  226,  226,  226,  226,  226,  256,  256,
      256,  256,  256,  256,  257,  408,  255,  255,  255,  255,
      255,  257,  257,  257,  257,  257,  257,  408,  408,  408,
      226,  226,  226,  226,  226,  258,  256,  256,  256,  256,
      256,  373,  258,  258,  258,  258,  258,  258,  259,  257,
      257,  257,  257,  257,  267,  259,  259,  259,  259,  259,
      259,  267,  267,  267,  267,  267,  267,  408,  268,  373,
      258,  258,  258,  258,  258,  268,  268,  268,  268,  268,

      268,  408,  408,  259,  259,  259,  259,  259,  374,  267,
      267,  267,  267,  267,  189,  189,  189,  189,  189,  408,
      375,  408,  408,  268,  268,  268,  268,  268,  243,  243,
      243,  243,  243,  408,  245,  374,  382,  408,  408,  246,
      278,  247,  274,  274,  274,  274,  274,  375,  408,  286,
      276,  380,  396,  408,  381,  247,  286,  286,  286,  286,
      286,  286,  382,  274,  274,  274,  274,  274,  408,  408,
      408,  408,  408,  383,  408,  384,  247,  388,  380,  248,
      396,  381,  389,  390,  286,  286,  286,  286,  286,  391,
      279,  392,  395,  248,  274,  274,  274,  274,  280,  383,

      282,  384,  408,  388,  408,  282,  282,  283,  397,  389,
      390,  398,  408,  284,  248,  408,  391,  392,  395,  287,
      284,  284,  284,  284,  284,  284,  287,  287,  287,  287,
      287,  287,  288,  399,  408,  397,  408,  408,  398,  288,
      288,  288,  288,  288,  288,  285,  408,  408,  284,  284,
      284,  284,  284,  290,  287,  287,  287,  287,  287,  399,
      290,  290,  290,  290,  290,  290,  291,  288,  288,  288,
      288,  288,  292,  291,  291,  291,  291,  291,  291,  292,
      292,  292,  292,  292,  292,  403,  293,  408,  290,  290,
      290,  290,  290,  293,  293,  293,  293,  293,  293,  408,

      408,  291,  291,  291,  291,  291,  294,  292,  292,  292,
      292,  292,  403,  294,  294,  294,  294,  294,  294,  295,
      408,  293,  293,  293,  293,  293,  295,  295,  295,  295,
      295,  295,  312,  347,  347,  347,  312,  408,  276,  301,
      400,  294,  294,  294,  294,  294,  301,  301,  301,  301,
      301,  301,  302,  401,  295,  295,  295,  295,  295,  302,
      302,  302,  302,  302,  302,  408,  400,  408,  408,  408,
      402,  404,  408,  405,  301,  301,  301,  301,  301,  401,
      408,  408,  408,  277,  408,  408,  406,  302,  302,  302,
      302,  302,  275,  275,  275,  311,  402,  404,  313,  405,

      408,  408,  408,  407,  274,  274,  274,  274,  274,  408,
      408,  314,  406,  408,  408,  408,  408,  247,  314,  314,
      314,  314,  314,  314,  274,  274,  274,  274,  274,  407,
      408,  408,  408,  408,  408,  408,  408,  247,  408,  408,
      408,  408,  408,  315,  408,  408,  314,  314,  314,  314,
      314,  278,  278,  278,  316,  248,  408,  408,  408,  408,
      408,  408,  318,  274,  274,  274,  274,  274,  408,  408,
      319,  408,  408,  408,  408,  248,  247,  319,  319,  319,
      319,  319,  319,  408,  345,  309,  309,  309,  345,  408,
      276,  408,  408,  408,  408,  408,  408,  346,  408,  408,

      408,  408,  320,  408,  408,  319,  319,  319,  319,  319,
      408,  408,  408,  408,  248,  280,  280,  280,  280,  280,
      408,  408,  408,  408,  408,  408,  408,  408,  247,  408,
      408,  408,  408,  408,  321,  277,  408,  408,  408,  408,
      408,  321,  321,  321,  321,  321,  321,  317,  351,  351,
      351,  317,  408,  322,  408,  408,  408,  408,  276,  408,
      322,  322,  322,  322,  322,  322,  248,  408,  408,  321,
      321,  321,  321,  321,  274,  274,  274,  274,  280,  408,
      282,  408,  408,  408,  408,  282,  282,  283,  322,  322,
      322,  322,  322,  284,  408,  408,  408,  408,  279,  323,

      284,  284,  284,  284,  284,  284,  323,  323,  323,  323,
      323,  323,  324,  408,  408,  408,  408,  408,  408,  324,
      324,  324,  324,  324,  324,  285,  408,  408,  284,  284,
      284,  284,  284,  326,  323,  323,  323,  323,  323,  408,
      326,  326,  326,  326,  326,  326,  327,  324,  324,  324,
      324,  324,  328,  327,  327,  327,  327,  327,  327,  328,
      328,  328,  328,  328,  328,  408,  329,  408,  326,  326,
      326,  326,  326,  329,  329,  329,  329,  329,  329,  408,
      408,  327,  327,  327,  327,  327,  330,  328,  328,  328,
      328,  328,  408,  330,  330,  330,  330,  330,  330,  331,

      408,  329,  329,  329,  329,  329,  331,  331,  331,  331,
      331,  331,  408,  408,  408,  408,  408,  408,  408,  336,
      408,  330,  330,  330,  330,  330,  336,  336,  336,  336,
      336,  336,  337,  408,  331,  331,  331,  331,  331,  337,
      337,  337,  337,  337,  337,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  336,  336,  336,  336,  336,  408,
      408,  408,  408,  408,  408,  408,  408,  337,  337,  337,
      337,  337,  312,  347,  347,  347,  312,  408,  276,  408,
      408,  408,  408,  408,  349,  309,  309,  309,  349,  408,
      408,  348,  408,  408,  408,  276,  408,  350,  348,  348,

      348,  348,  348,  348,   94,  408,  408,  408,  408,  408,
      122,   94,   94,   94,   94,   94,   94,  122,  122,  122,
      122,  122,  122,  277,  408,  408,  348,  348,  348,  348,
      348,  275,  275,  275,  311,  279,  408,  313,  408,   94,
       94,   94,   94,   94,  408,  122,  122,  122,  122,  122,
      314,  408,  408,  408,  408,  408,  408,  314,  314,  314,
      314,  314,  314,  408,  408,  408,  408,   48,  408,  408,
      408,  408,  408,  408,   48,   48,   48,   48,   48,   48,
      408,  408,  315,  408,  408,  314,  314,  314,  314,  314,
      317,  351,  351,  351,  317,  408,  408,  408,  408,  408,

      408,  276,   48,   48,   48,   48,   48,  408,  408,  352,
      408,  408,  408,  408,  408,  408,  352,  352,  352,  352,
      352,  352,  408,  408,  408,  408,  355,  408,  408,  408,
      408,  408,  408,  355,  355,  355,  355,  355,  355,  408,
      408,  279,  408,  408,  352,  352,  352,  352,  352,  278,
      278,  278,  316,  408,  408,  408,  408,  408,  408,  408,
      318,  355,  355,  355,  355,  355,  408,  408,  319,  408,
      408,  408,  408,  408,  408,  319,  319,  319,  319,  319,
      319,  408,  408,  408,  408,  408,  408,   55,  408,  408,
      408,  408,  408,  408,   55,   55,   55,   55,   55,   55,

      320,  408,  408,  319,  319,  319,  319,  319,  280,  280,
      280,  280,  280,  408,  408,  408,  408,  408,  408,  408,
      408,  247,   55,   55,   55,   55,   55,  353,  408,  408,
      408,  408,  408,  356,  353,  353,  353,  353,  353,  353,
      356,  356,  356,  356,  356,  356,  134,  408,  408,  408,
      408,  408,  408,  134,  134,  134,  134,  134,  134,  248,
      408,  408,  353,  353,  353,  353,  353,  408,  356,  356,
      356,  356,  356,  408,  408,  408,  408,  357,  408,  408,
      408,  134,  134,  134,  134,  134,  358,  408,  408,  364,
      408,  359,  360,  408,  408,  361,  364,  364,  364,  364,

      364,  364,  408,  408,  357,  408,  408,  345,  309,  309,
      309,  345,  358,  276,  408,  408,  408,  359,  360,  408,
      346,  361,  408,  408,  364,  364,  364,  364,  364,  365,
      408,  349,  309,  309,  309,  349,  365,  365,  365,  365,
      365,  365,  276,  408,  350,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  277,  408,
      408,  408,  366,  408,  365,  365,  365,  365,  365,  366,
      366,  366,  366,  366,  366,  408,  367,  408,  408,  408,
      408,  408,  279,  367,  367,  367,  367,  367,  367,  408,
      408,  408,  408,  408,  408,  376,  408,  366,  366,  366,

      366,  366,  376,  376,  376,  376,  376,  376,  408,  377,
      408,  367,  367,  367,  367,  367,  377,  377,  377,  377,
      377,  377,  408,  408,  408,  408,  408,  408,  378,  408,
      376,  376,  376,  376,  376,  378,  378,  378,  378,  378,
      378,  408,  379,  408,  377,  377,  377,  377,  377,  379,
      379,  379,  379,  379,  379,  408,  408,  408,  408,  408,
      408,  385,  408,  378,  378,  378,  378,  378,  385,  385,
      385,  385,  385,  385,  408,  386,  408,  379,  379,  379,
      379,  379,  386,  386,  386,  386,  386,  386,  408,  408,
      408,  408,  408,  408,  387,  408,  385,  385,  385,  385,

      385,  387,  387,  387,  387,  387,  387,  408,  393,  408,
      386,  386,  386,  386,  386,  393,  393,  393,  393,  393,
      393,  408,  408,  408,  408,  408,  408,  394,  408,  387,
      387,  387,  387,  387,  394,  394,  394,  394,  394,  394,
      408,  244,  408,  393,  393,  393,  393,  393,  244,  244,
      244,  244,  244,  244,  408,  408,  408,  408,  408,  408,
      408,  408,  394,  394,  394,  394,  394,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  244,  244,  244,  244,
      244,   48,  408,   48,   48,   48,   48,   48,   48,   48,
       52,  408,  408,   52,   52,   55,  408,   55,   55,   55,

       55,   55,   55,   55,   61,   61,  408,   61,   61,   94,
       94,   94,  408,   94,   94,  102,  102,  102,  102,  102,
      102,  102,  118,  118,  118,  118,  118,  118,  118,  118,
      118,  122,  122,  408,  122,  122,  124,  124,  124,  124,
      124,  124,  124,  127,  127,  127,  127,  127,  127,  127,
      127,  127,  132,  132,  132,  132,  132,  132,  132,  132,
      132,  132,   70,   70,  134,  134,  408,  134,  134,  152,
      152,  152,  152,  152,  152,  152,  163,  163,  163,  163,
      163,  163,  163,  169,  169,  169,  182,  182,  182,  182,
      182,  182,  182,  187,  187,  187,  187,  187,  187,  187,

      187,  187,  187,  189,  189,  189,  189,  189,  189,  189,
      209,  209,  209,  209,  224,  224,  224,  224,  224,  224,
      224,  224,  224,  224,  239,  239,  239,  239,  244,  244,
      244,  408,  244,  244,  244,  244,  244,  187,  187,  187,
      187,  187,  187,  187,  187,  187,  187,  269,  269,  269,
      269,  275,  408,  275,  275,  275,  275,  275,  275,  275,
      278,  408,  278,  278,  278,  278,  278,  278,  278,  281,
      281,  281,  281,  281,  281,  281,  281,  281,  303,  303,
      303,  303,  312,  312,  312,  312,  312,  312,  312,  312,
      312,  317,  317,  317,  317,  317,  317,  317,  317,  317,

      338,  338,  338,  338,  317,  317,  317,  317,  317,  317,
      317,  317,  317,    9,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408

    } ;

static yyconst flex_int16_t yy_chk[2898] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    3,    5,    3,    3,    4,    6,    4,
        4,    7,    3,   14,    8,   15,    4,   11,   11,   11,

       11,   11,   17,   19,  338,    3,    3,   26,   47,    4,
        4,   12,   12,   12,   12,   12,   20,   37,   51,   20,
        3,   39,   48,   19,    4,   13,   13,   13,   13,   13,
       15,    3,    3,   55,   47,    4,    4,   58,   14,   20,
       91,    5,   17,    3,   37,    6,   26,    4,   39,   19,
       35,   20,   35,   51,   61,   86,   37,   58,   87,   13,
       39,    7,   35,    7,    8,   20,    8,   48,   91,   72,
       37,   92,   74,   55,   39,   45,   45,   45,   45,   45,
       74,   86,   84,   58,   84,   87,   13,   23,  133,   35,
       72,  308,  133,   61,   23,   23,   72,   23,   74,   92,

      307,  306,  305,  304,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       81,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   81,  296,  273,   81,   23,
       25,   27,   27,   27,   27,   27,  272,   28,  118,  271,
       28,   73,   25,   27,   88,   25,   27,   27,   25,   29,
      119,   73,   25,   25,   73,   25,   29,   29,   29,   29,
       29,   29,   46,   46,   46,   46,   46,   73,   28,   25,

       88,   27,   25,  270,   89,   25,   28,   73,   25,   25,
      127,   25,   27,  118,   29,   29,   29,   29,   29,   38,
       38,   38,   38,   38,   28,  119,   46,   27,   90,   53,
       89,   38,  260,  156,   38,   38,   53,   53,   53,   53,
       53,   53,   59,   59,   59,   59,   59,   64,  169,   64,
      127,   75,   75,   46,   94,   90,  169,   59,   59,   38,
      156,  250,  194,  128,   53,   53,   53,   53,   53,   64,
       38,   63,   62,   62,   62,   62,   62,   75,   63,   63,
       63,   63,   63,   63,   62,   38,   43,   62,   62,   43,
       76,  116,  138,   94,  194,   64,   43,   43,   43,   43,

       43,   43,   76,  128,  209,   99,   63,   63,   63,   63,
       63,  138,  209,  102,  101,   71,   76,  116,   77,  138,
       71,   43,  113,   62,   43,   43,   43,   43,   43,   50,
       50,   50,   50,   71,  157,   50,   77,   78,   99,  101,
      144,  144,   71,   78,   99,   77,   71,  113,   50,  158,
       78,   80,  102,  101,  141,   50,   50,   50,   50,   50,
       50,  113,  157,   78,   99,  101,  144,  163,   80,   78,
      159,   80,  117,  113,   80,  158,  242,  117,   80,  141,
       50,  111,  141,   50,   50,   50,   50,   50,   56,   56,
       56,   56,  241,   83,   80,  161,  159,   80,  111,   56,

       83,   83,   83,   83,   83,   83,  163,   56,   79,   79,
       79,   79,   79,  160,   56,   56,   56,   56,   56,   56,
      111,  161,  117,   79,   79,  111,   95,  240,   83,   83,
       83,   83,   83,   95,   95,   95,   95,   95,   95,   56,
      160,  232,   56,   56,   56,   56,   56,  227,  126,  167,
      112,   96,   96,   96,   96,   96,  167,  168,  126,   79,
      171,   95,   95,   95,   95,   95,   96,   96,   97,   97,
       97,   97,   97,   98,   98,   98,   98,   98,  109,  151,
      109,  162,  107,  112,  107,   98,  110,   97,  167,  112,
      109,  224,   98,  154,  107,  174,  168,  110,  126,  171,

      215,  151,  154,  211,  107,  210,  151,  110,  162,  112,
      179,  225,  239,  110,  269,  225,  195,  109,  180,  154,
      239,  107,  269,  110,   98,  103,  103,  103,  103,  103,
      107,  114,  175,  185,  174,  216,  179,  103,  114,  114,
      114,  114,  114,  114,  103,  165,  165,  165,  165,  165,
      123,  103,  103,  103,  103,  103,  103,  123,  123,  123,
      123,  123,  123,  180,  165,  193,  114,  114,  114,  114,
      114,  175,  191,  185,  216,  189,  103,  187,  182,  103,
      103,  103,  103,  103,  115,  123,  123,  123,  123,  123,
      234,  115,  115,  115,  115,  115,  115,  135,  147,  147,

      147,  147,  147,  172,  135,  135,  135,  135,  135,  135,
      172,  172,  172,  172,  172,  172,  115,  147,  234,  115,
      115,  115,  115,  115,  120,  120,  120,  120,  120,  176,
      120,  199,  135,  135,  135,  135,  135,  200,  172,  172,
      172,  172,  172,  120,  197,  192,  170,  201,  202,  147,
      120,  120,  120,  120,  120,  120,  245,  199,  246,  278,
      275,  203,  166,  200,  173,  197,  176,  192,  176,  204,
      173,  197,  192,  201,  202,  120,  205,  262,  120,  120,
      120,  120,  120,  121,  121,  121,  121,  173,  203,  121,
      219,  173,  176,  214,  229,  155,  204,  173,  246,  278,

      152,  245,  121,  205,  262,  275,  214,  229,  263,  121,
      121,  121,  121,  121,  121,  177,  219,  150,  149,  214,
      229,  178,  177,  177,  177,  177,  177,  177,  178,  178,
      178,  178,  178,  178,  121,  263,  148,  121,  121,  121,
      121,  121,  125,  125,  125,  125,  125,  146,  317,  145,
      177,  177,  177,  177,  177,  181,  178,  178,  178,  178,
      178,  125,  181,  181,  181,  181,  181,  181,  125,  125,
      125,  125,  125,  125,  212,  212,  212,  212,  212,  312,
      212,  230,  231,  233,  235,  212,  143,  212,  317,  346,
      181,  181,  181,  181,  181,  253,  125,  125,  125,  125,

      125,  129,  129,  129,  129,  129,  184,  230,  231,  233,
      235,  261,  129,  184,  184,  184,  184,  184,  184,  142,
      129,  253,  140,  139,  312,  212,  289,  129,  129,  129,
      129,  129,  129,  137,  346,  136,  134,  261,  264,  186,
      266,  184,  184,  184,  184,  184,  186,  186,  186,  186,
      186,  186,  129,  132,  289,  129,  129,  129,  129,  129,
      130,  130,  130,  130,  264,  303,  266,  298,  297,  300,
      325,  130,  124,  303,  186,  186,  186,  186,  186,  130,
      274,  274,  274,  274,  274,  334,  130,  130,  130,  130,
      130,  130,  196,  274,  297,  298,  325,  300,  206,  196,

      196,  196,  196,  196,  196,  206,  206,  206,  206,  206,
      206,  130,  334,  122,  130,  130,  130,  130,  130,  153,
      153,  153,  153,  153,  108,  100,  335,  196,  196,  196,
      196,  196,  350,  206,  206,  206,  206,  206,  153,  276,
      276,  276,  276,  276,  351,  153,  153,  153,  153,  153,
      153,  208,  276,  335,   85,   82,  357,  213,  208,  208,
      208,  208,  208,  208,  213,  213,  213,  213,  213,  213,
      153,  347,  350,  153,  153,  153,  153,  153,  164,  164,
      164,  164,  164,  357,  351,   70,  208,  208,  208,  208,
      208,  217,  213,  213,  213,  213,  213,  164,  217,  217,

      217,  217,  217,  217,  164,  164,  164,  164,  164,  164,
      218,  309,  309,  309,  309,  309,  347,  218,  218,  218,
      218,  218,  218,   68,  309,   67,  217,  217,  217,  217,
      217,  358,  164,  164,  164,  164,  164,  183,  183,  183,
      183,  183,   65,  220,   60,  218,  218,  218,  218,  218,
      220,  220,  220,  220,  220,  220,  183,  311,  358,   52,
       34,  360,  311,  183,  183,  183,  183,  183,  183,  328,
      328,  328,  328,  328,   33,   32,  354,  359,  220,  220,
      220,  220,  220,  336,  336,  336,  336,  336,  360,   30,
       24,  183,  183,  183,  183,  183,  190,  190,  190,  190,

      190,  221,  354,  359,   22,   21,   18,  311,  221,  221,
      221,  221,  221,  221,   16,  190,  355,  355,  355,  355,
      355,  222,  190,  190,  190,  190,  190,  190,  222,  222,
      222,  222,  222,  222,  223,    9,  221,  221,  221,  221,
      221,  223,  223,  223,  223,  223,  223,    0,    0,    0,
      190,  190,  190,  190,  190,  226,  222,  222,  222,  222,
      222,  361,  226,  226,  226,  226,  226,  226,  228,  223,
      223,  223,  223,  223,  237,  228,  228,  228,  228,  228,
      228,  237,  237,  237,  237,  237,  237,    0,  238,  361,
      226,  226,  226,  226,  226,  238,  238,  238,  238,  238,

      238,    0,    0,  228,  228,  228,  228,  228,  362,  237,
      237,  237,  237,  237,  356,  356,  356,  356,  356,    0,
      363,    0,    0,  238,  238,  238,  238,  238,  243,  243,
      243,  243,  243,    0,  243,  362,  371,    0,    0,  243,
      316,  243,  244,  244,  244,  244,  244,  363,  244,  249,
      316,  369,  389,  244,  370,  244,  249,  249,  249,  249,
      249,  249,  371,  280,  280,  280,  280,  280,    0,  280,
        0,    0,    0,  372,  280,  373,  280,  380,  369,  243,
      389,  370,  381,  382,  249,  249,  249,  249,  249,  383,
      316,  384,  388,  244,  248,  248,  248,  248,  248,  372,

      248,  373,    0,  380,    0,  248,  248,  248,  391,  381,
      382,  392,    0,  248,  280,    0,  383,  384,  388,  251,
      248,  248,  248,  248,  248,  248,  251,  251,  251,  251,
      251,  251,  252,  396,    0,  391,    0,    0,  392,  252,
      252,  252,  252,  252,  252,  248,    0,    0,  248,  248,
      248,  248,  248,  254,  251,  251,  251,  251,  251,  396,
      254,  254,  254,  254,  254,  254,  255,  252,  252,  252,
      252,  252,  256,  255,  255,  255,  255,  255,  255,  256,
      256,  256,  256,  256,  256,  401,  257,    0,  254,  254,
      254,  254,  254,  257,  257,  257,  257,  257,  257,    0,

        0,  255,  255,  255,  255,  255,  258,  256,  256,  256,
      256,  256,  401,  258,  258,  258,  258,  258,  258,  259,
        0,  257,  257,  257,  257,  257,  259,  259,  259,  259,
      259,  259,  393,  393,  393,  393,  393,    0,  393,  267,
      397,  258,  258,  258,  258,  258,  267,  267,  267,  267,
      267,  267,  268,  399,  259,  259,  259,  259,  259,  268,
      268,  268,  268,  268,  268,    0,  397,    0,    0,    0,
      400,  402,    0,  403,  267,  267,  267,  267,  267,  399,
        0,    0,    0,  393,    0,    0,  404,  268,  268,  268,
      268,  268,  277,  277,  277,  277,  400,  402,  277,  403,

        0,    0,    0,  405,  281,  281,  281,  281,  281,    0,
      281,  277,  404,    0,    0,  281,    0,  281,  277,  277,
      277,  277,  277,  277,  282,  282,  282,  282,  282,  405,
      282,    0,    0,    0,    0,  282,    0,  282,    0,    0,
        0,    0,    0,  277,    0,    0,  277,  277,  277,  277,
      277,  279,  279,  279,  279,  281,    0,    0,    0,    0,
        0,    0,  279,  283,  283,  283,  283,  283,    0,  283,
      279,    0,    0,    0,  283,  282,  283,  279,  279,  279,
      279,  279,  279,    0,  313,  313,  313,  313,  313,    0,
      313,    0,    0,    0,    0,    0,    0,  313,    0,    0,

        0,    0,  279,    0,    0,  279,  279,  279,  279,  279,
        0,    0,    0,    0,  283,  284,  284,  284,  284,  284,
        0,  284,    0,    0,    0,    0,  284,    0,  284,    0,
        0,    0,    0,    0,  284,  313,    0,    0,    0,    0,
        0,  284,  284,  284,  284,  284,  284,  394,  394,  394,
      394,  394,    0,  286,    0,    0,    0,    0,  394,    0,
      286,  286,  286,  286,  286,  286,  284,    0,    0,  284,
      284,  284,  284,  284,  285,  285,  285,  285,  285,    0,
      285,    0,    0,    0,    0,  285,  285,  285,  286,  286,
      286,  286,  286,  285,    0,    0,    0,    0,  394,  287,

      285,  285,  285,  285,  285,  285,  287,  287,  287,  287,
      287,  287,  288,    0,    0,    0,    0,    0,    0,  288,
      288,  288,  288,  288,  288,  285,    0,    0,  285,  285,
      285,  285,  285,  290,  287,  287,  287,  287,  287,    0,
      290,  290,  290,  290,  290,  290,  291,  288,  288,  288,
      288,  288,  292,  291,  291,  291,  291,  291,  291,  292,
      292,  292,  292,  292,  292,    0,  293,    0,  290,  290,
      290,  290,  290,  293,  293,  293,  293,  293,  293,    0,
        0,  291,  291,  291,  291,  291,  294,  292,  292,  292,
      292,  292,    0,  294,  294,  294,  294,  294,  294,  295,

        0,  293,  293,  293,  293,  293,  295,  295,  295,  295,
      295,  295,    0,    0,    0,    0,    0,    0,    0,  301,
        0,  294,  294,  294,  294,  294,  301,  301,  301,  301,
      301,  301,  302,    0,  295,  295,  295,  295,  295,  302,
      302,  302,  302,  302,  302,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  301,  301,  301,  301,  301,    0,
        0,    0,    0,    0,    0,    0,    0,  302,  302,  302,
      302,  302,  314,  314,  314,  314,  314,    0,  314,    0,
        0,    0,    0,    0,  318,  318,  318,  318,  318,    0,
        0,  314,    0,    0,    0,  318,    0,  318,  314,  314,

      314,  314,  314,  314,  322,    0,    0,    0,    0,    0,
      324,  322,  322,  322,  322,  322,  322,  324,  324,  324,
      324,  324,  324,  314,    0,    0,  314,  314,  314,  314,
      314,  315,  315,  315,  315,  318,    0,  315,    0,  322,
      322,  322,  322,  322,    0,  324,  324,  324,  324,  324,
      315,    0,    0,    0,    0,    0,    0,  315,  315,  315,
      315,  315,  315,    0,    0,    0,    0,  326,    0,    0,
        0,    0,    0,    0,  326,  326,  326,  326,  326,  326,
        0,    0,  315,    0,    0,  315,  315,  315,  315,  315,
      319,  319,  319,  319,  319,    0,    0,    0,    0,    0,

        0,  319,  326,  326,  326,  326,  326,    0,    0,  319,
        0,    0,    0,    0,    0,    0,  319,  319,  319,  319,
      319,  319,    0,    0,    0,    0,  327,    0,    0,    0,
        0,    0,    0,  327,  327,  327,  327,  327,  327,    0,
        0,  319,    0,    0,  319,  319,  319,  319,  319,  320,
      320,  320,  320,    0,    0,    0,    0,    0,    0,    0,
      320,  327,  327,  327,  327,  327,    0,    0,  320,    0,
        0,    0,    0,    0,    0,  320,  320,  320,  320,  320,
      320,    0,    0,    0,    0,    0,    0,  329,    0,    0,
        0,    0,    0,    0,  329,  329,  329,  329,  329,  329,

      320,    0,    0,  320,  320,  320,  320,  320,  321,  321,
      321,  321,  321,    0,  321,    0,    0,    0,    0,  321,
        0,  321,  329,  329,  329,  329,  329,  321,    0,    0,
        0,    0,    0,  330,  321,  321,  321,  321,  321,  321,
      330,  330,  330,  330,  330,  330,  331,    0,    0,    0,
        0,    0,    0,  331,  331,  331,  331,  331,  331,  321,
        0,    0,  321,  321,  321,  321,  321,    0,  330,  330,
      330,  330,  330,    0,    0,    0,    0,  332,    0,    0,
        0,  331,  331,  331,  331,  331,  332,    0,    0,  337,
        0,  332,  332,    0,    0,  332,  337,  337,  337,  337,

      337,  337,    0,    0,  332,    0,    0,  345,  345,  345,
      345,  345,  332,  345,    0,    0,    0,  332,  332,    0,
      345,  332,    0,    0,  337,  337,  337,  337,  337,  348,
        0,  349,  349,  349,  349,  349,  348,  348,  348,  348,
      348,  348,  349,    0,  349,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  345,    0,
        0,    0,  352,    0,  348,  348,  348,  348,  348,  352,
      352,  352,  352,  352,  352,    0,  353,    0,    0,    0,
        0,    0,  349,  353,  353,  353,  353,  353,  353,    0,
        0,    0,    0,    0,    0,  364,    0,  352,  352,  352,

      352,  352,  364,  364,  364,  364,  364,  364,    0,  365,
        0,  353,  353,  353,  353,  353,  365,  365,  365,  365,
      365,  365,    0,    0,    0,    0,    0,    0,  366,    0,
      364,  364,  364,  364,  364,  366,  366,  366,  366,  366,
      366,    0,  367,    0,  365,  365,  365,  365,  365,  367,
      367,  367,  367,  367,  367,    0,    0,    0,    0,    0,
        0,  377,    0,  366,  366,  366,  366,  366,  377,  377,
      377,  377,  377,  377,    0,  378,    0,  367,  367,  367,
      367,  367,  378,  378,  378,  378,  378,  378,    0,    0,
        0,    0,    0,    0,  379,    0,  377,  377,  377,  377,

      377,  379,  379,  379,  379,  379,  379,    0,  385,    0,
      378,  378,  378,  378,  378,  385,  385,  385,  385,  385,
      385,    0,    0,    0,    0,    0,    0,  386,    0,  379,
      379,  379,  379,  379,  386,  386,  386,  386,  386,  386,
        0,  387,    0,  385,  385,  385,  385,  385,  387,  387,
      387,  387,  387,  387,    0,    0,    0,    0,    0,    0,
        0,    0,  386,  386,  386,  386,  386,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  387,  387,  387,  387,
      387,  409,    0,  409,  409,  409,  409,  409,  409,  409,
      410,    0,    0,  410,  410,  411,    0,  411,  411,  411,

      411,  411,  411,  411,  412,  412,    0,  412,  412,  413,
      413,  413,    0,  413,  413,  414,  414,  414,  414,  414,
      414,  414,  415,  415,  415,  415,  415,  415,  415,  415,
      415,  416,  416,    0,  416,  416,  417,  417,  417,  417,
      417,  417,  417,  418,  418,  418,  418,  418,  418,  418,
      418,  418,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  420,  420,  421,  421,    0,  421,  421,  422,
      422,  422,  422,  422,  422,  422,  423,  423,  423,  423,
      423,  423,  423,  424,  424,  424,  425,  425,  425,  425,
      425,  425,  425,  426,  426,  426,  426,  426,  426,  426,

      426,  426,  426,  427,  427,  427,  427,  427,  427,  427,
      428,  428,  428,  428,  429,  429,  429,  429,  429,  429,
      429,  429,  429,  429,  430,  430,  430,  430,  431,  431,
      431,    0,  431,  431,  431,  431,  431,  432,  432,  432,
      432,  432,  432,  432,  432,  432,  432,  433,  433,  433,
      433,  434,    0,  434,  434,  434,  434,  434,  434,  434,
      435,    0,  435,  435,  435,  435,  435,  435,  435,  436,
      436,  436,  436,  436,  436,  436,  436,  436,  437,  437,
      437,  437,  438,  438,  438,  438,  438,  438,  438,  438,
      438,  439,  439,  439,  439,  439,  439,  439,  439,  439,

      440,  440,  440,  440,  441,  441,  441,  441,  441,  441,
      441,  441,  441,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408

    } ;

YY_DECL
{
	register yy_state_type yy_current_state;
	register unsigned short *yy_cp, *yy_bp;
	register int yy_act;
	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 409 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 2814 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 30 "tokenizer.flex"
/* ignore comments */
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 32 "tokenizer.flex"
{yyTok = S; return yyTok;}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 34 "tokenizer.flex"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 35 "tokenizer.flex"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 36 "tokenizer.flex"
{yyTok = INCLUDES; return yyTok;}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 37 "tokenizer.flex"
{yyTok = DASHMATCH; return yyTok;}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 38 "tokenizer.flex"
{yyTok = BEGINSWITH; return yyTok;}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 39 "tokenizer.flex"
{yyTok = ENDSWITH; return yyTok;}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 40 "tokenizer.flex"
{yyTok = CONTAINS; return yyTok;}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 41 "tokenizer.flex"
{yyTok = MEDIA_NOT; return yyTok;}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 42 "tokenizer.flex"
{yyTok = MEDIA_ONLY; return yyTok;}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 43 "tokenizer.flex"
{yyTok = MEDIA_AND; return yyTok;}
	YY_BREAK
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 45 "tokenizer.flex"
{yyTok = STRING; return yyTok;}
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 46 "tokenizer.flex"
{yyTok = IDENT; return yyTok;}
	YY_BREAK
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
#line 47 "tokenizer.flex"
{yyTok = NTH; return yyTok;}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 50 "tokenizer.flex"
{yyTok = HEXCOLOR; return yyTok;}
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 51 "tokenizer.flex"
{yyTok = HASH; return yyTok;}
	YY_BREAK
/* @rule tokens surrounding css declaration blocks with { } braces must start a BEGIN(at_rule) context */
case 18:
YY_RULE_SETUP
#line 53 "tokenizer.flex"
{BEGIN(mediaquery); yyTok = IMPORT_SYM; return yyTok;}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 54 "tokenizer.flex"
{BEGIN(at_rule); yyTok = PAGE_SYM; return yyTok;}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 55 "tokenizer.flex"
{BEGIN(mediaquery); yyTok = MEDIA_SYM; return yyTok;}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 56 "tokenizer.flex"
{BEGIN(at_rule); yyTok = FONT_FACE_SYM; return yyTok;}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 57 "tokenizer.flex"
{BEGIN(at_rule); yyTok = CHARSET_SYM; return yyTok;}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 58 "tokenizer.flex"
{BEGIN(at_rule); yyTok = NAMESPACE_SYM; return yyTok; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 59 "tokenizer.flex"
{BEGIN(at_rule); yyTok = KHTML_RULE_SYM; return yyTok; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 60 "tokenizer.flex"
{yyTok = KHTML_DECLS_SYM; return yyTok; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 61 "tokenizer.flex"
{yyTok = KHTML_VALUE_SYM; return yyTok; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 62 "tokenizer.flex"
{yyTok = KHTML_SELECTORS_SYM; return yyTok; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 63 "tokenizer.flex"
{BEGIN(mediaquery); yyTok = KHTML_MEDIAQUERY_SYM; return yyTok; }
	YY_BREAK
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 65 "tokenizer.flex"
{yyTok = IMPORTANT_SYM; return yyTok;}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 67 "tokenizer.flex"
{yyTok = EMS; return yyTok;}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 68 "tokenizer.flex"
{yyTok = QEMS; return yyTok;} /* quirky ems */
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 69 "tokenizer.flex"
{yyTok = EXS; return yyTok;}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 70 "tokenizer.flex"
{yyTok = CHS; return yyTok;}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 71 "tokenizer.flex"
{yyTok = PXS; return yyTok;}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 72 "tokenizer.flex"
{yyTok = CMS; return yyTok;}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 73 "tokenizer.flex"
{yyTok = MMS; return yyTok;}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 74 "tokenizer.flex"
{yyTok = INS; return yyTok;}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 75 "tokenizer.flex"
{yyTok = PTS; return yyTok;}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 76 "tokenizer.flex"
{yyTok = PCS; return yyTok;}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 77 "tokenizer.flex"
{yyTok = DEGS; return yyTok;}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 78 "tokenizer.flex"
{yyTok = RADS; return yyTok;}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 79 "tokenizer.flex"
{yyTok = GRADS; return yyTok;}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 80 "tokenizer.flex"
{yyTok = MSECS; return yyTok;}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 81 "tokenizer.flex"
{yyTok = SECS; return yyTok;}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 82 "tokenizer.flex"
{yyTok = HERZ; return yyTok;}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 83 "tokenizer.flex"
{yyTok = DPI; return yyTok;}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 84 "tokenizer.flex"
{yyTok = DPCM; return yyTok;}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 85 "tokenizer.flex"
{yyTok = KHERZ; return yyTok;}
	YY_BREAK
case 49:
/* rule 49 can match eol */
YY_RULE_SETUP
#line 86 "tokenizer.flex"
{yyTok = DIMEN; return yyTok;}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 87 "tokenizer.flex"
{yyTok = PERCENTAGE; return yyTok;}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 88 "tokenizer.flex"
{yyTok = INTEGER; return yyTok;}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 89 "tokenizer.flex"
{yyTok = FLOAT; return yyTok;}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 92 "tokenizer.flex"
{yyTok = NOTFUNCTION; return yyTok;}
	YY_BREAK
case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
#line 93 "tokenizer.flex"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 55:
/* rule 55 can match eol */
YY_RULE_SETUP
#line 94 "tokenizer.flex"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 56:
/* rule 56 can match eol */
YY_RULE_SETUP
#line 95 "tokenizer.flex"
{yyTok = FUNCTION; return yyTok;}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 97 "tokenizer.flex"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 98 "tokenizer.flex"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 100 "tokenizer.flex"
{BEGIN(block); yyTok = *yytext; return yyTok;}
	YY_BREAK
case 60:
#line 102 "tokenizer.flex"
case 61:
#line 103 "tokenizer.flex"
case 62:
#line 104 "tokenizer.flex"
case 63:
#line 105 "tokenizer.flex"
case 64:
YY_RULE_SETUP
#line 105 "tokenizer.flex"
{BEGIN(INITIAL); yyTok = *yytext; return yyTok; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 106 "tokenizer.flex"
{yyTok = *yytext; return yyTok;}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 108 "tokenizer.flex"
ECHO;
	YY_BREAK
#line 1862 "<stdout>"
case YY_STATE_EOF(INITIAL):
case YY_END_OF_BUFFER:
case YY_STATE_EOF(mediaquery):
case YY_STATE_EOF(at_rule):
case YY_STATE_EOF(block):
	yyterminate();

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */
