/* Candido Theme Engine
 * Copyright (C) 2005 Richard Stellingwerff.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Written by Owen Taylor <otaylor@redhat.com>
 * and by Alexander Larsson <alexl@redhat.com>
 * Modified by Richard Stellingwerff <remenic@gmail.com>
 * Modified by Kulyk Nazar <schamane@myeburg.net>
 */

#include <gtk/gtkrc.h>

typedef struct _CandidoRcStyle CandidoRcStyle;
typedef struct _CandidoRcStyleClass CandidoRcStyleClass;

extern GType candido_type_rc_style;

#define CANDIDO_TYPE_RC_STYLE              candido_type_rc_style
#define CANDIDO_RC_STYLE(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), CANDIDO_TYPE_RC_STYLE, CandidoRcStyle))
#define CANDIDO_RC_STYLE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), CANDIDO_TYPE_RC_STYLE, CandidoRcStyleClass))
#define CANDIDO_IS_RC_STYLE(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), CANDIDO_TYPE_RC_STYLE))
#define CANDIDO_IS_RC_STYLE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), CANDIDO_TYPE_RC_STYLE))
#define CANDIDO_RC_STYLE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), CANDIDO_TYPE_RC_STYLE, CandidoRcStyleClass))

struct _CandidoRcStyle
{
  GtkRcStyle parent_instance;

  GdkColor scrollbar_color;
  gboolean has_scrollbar_color;
  double contrast;
  guint8 sunkenmenubar;
  guint8 progressbarstyle;
  guint8 menubarstyle;
  guint8 menubaritemstyle;
  guint8 menuitemstyle;
  guint8 listviewitemstyle;
  guint8 scrollbarstyle;
  guint8 squaredstyle;
  gboolean animation;
};

struct _CandidoRcStyleClass
{
  GtkRcStyleClass parent_class;
};

void candido_rc_style_register_type (GTypeModule *module);
