// Generated by gmmproc 2.73.2 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/treeiter.h>
#include <gtkmm/private/treeiter_p.h>

#include <cstring> // std::memset()

/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/treemodel.h>
#include <gtk/gtk.h>


namespace Gtk
{

/**** Gtk::TreeIterBase2 ***************************************************/

TreeIterBase2::TreeIterBase2()
:
  TreeIterBase(),
  model_      (nullptr),
  is_end_     (false)
{}

TreeIterBase2::TreeIterBase2(TreeModel* model)
:
  TreeIterBase(),
  model_      (model),
  is_end_     (false)
{}

TreeIterBase2::TreeIterBase2(GtkTreeModel* model, const GtkTreeIter* iter)
:
  TreeIterBase(iter),
  model_      (dynamic_cast<TreeModel*>(Glib::wrap_auto((GObject*)model))),
  is_end_     (iter == nullptr)
{}

/**** Gtk::TreeIterBase3 ***************************************************/

TreeIterBase3::TreeIterBase3()
:
  TreeIterBase2()
{}

TreeIterBase3::TreeIterBase3(TreeModel* model)
:
  TreeIterBase2(model)
{}

TreeIterBase3::TreeIterBase3(GtkTreeModel* model, const GtkTreeIter* iter)
:
  TreeIterBase2(model, iter)
{}

void TreeIterBase3::plus_plus()
{
  g_assert(!is_end_);

  auto previous = gobject_;

  if(!gtk_tree_model_iter_next(model_->gobj(), &gobject_))
  {
    is_end_ = true;
    gtk_tree_model_iter_parent(Glib::unwrap(model_), &gobject_, &previous);
  }
}

void TreeIterBase3::minus_minus()
{
  if(!is_end_)
  {
    gtk_tree_model_iter_previous(Glib::unwrap(model_), &gobject_);
  }
  else // --end yields last
  {
    auto next = gobject_;
    const auto parent = (next.stamp != 0) ? &next : nullptr;

    const int index = gtk_tree_model_iter_n_children(Glib::unwrap(model_), parent) - 1;
    is_end_ = !gtk_tree_model_iter_nth_child(Glib::unwrap(model_), &gobject_, parent, index);

    g_assert(!is_end_);
  }
}

/* There is no public gtk_tree_iter_equal(), so we must write our own.
 */
bool TreeIterBase3::equal(const TreeIterBase3& other) const
{
  g_assert(model_ == other.model_);

  // A GtkTreeIter has the same stamp value as its model.
  g_assert(gobject_.stamp == other.gobject_.stamp || is_end_ || other.is_end_);

  // If all user_data pointers are equal we can assume the iterators to be
  // equal.  This should be safe since GtkTreeIter lacks destroy notification,
  // thus there is no way to attach more data fields to the iterator.
  return (is_end_ == other.is_end_) &&
         (gobject_.user_data  == other.gobject_.user_data)  &&
         (gobject_.user_data2 == other.gobject_.user_data2) &&
         (gobject_.user_data3 == other.gobject_.user_data3);
}

void TreeIterBase3::setup_end_iterator(const TreeIterBase3& last_valid)
{
  g_assert(model_ == last_valid.model_);

  if(last_valid.is_end_)
    gobject_ = last_valid.gobject_;
  else
    gtk_tree_model_iter_parent(model_->gobj(), &gobject_, const_cast<GtkTreeIter*>(&last_valid.gobject_));

  is_end_ = true;
}

void TreeIterBase3::set_model_refptr(const Glib::RefPtr<TreeModel>& model)
{
  model_ = model.operator->();
}

void TreeIterBase3::set_model_gobject(GtkTreeModel* model)
{
  model_ = dynamic_cast<TreeModel*>(Glib::wrap_auto((GObject*) model));
}

GtkTreeModel* TreeIterBase3::get_model_gobject()
{
  return (model_) ? model_->gobj() : nullptr;
}

const GtkTreeModel* TreeIterBase3::get_model_gobject() const
{
  return (model_) ? model_->gobj() : nullptr;
}

int TreeIterBase3::get_stamp() const
{
  return gobj()->stamp;
}

void TreeIterBase3::set_stamp(int stamp)
{
  gobj()->stamp = stamp;
}


/**** Gtk::TreeConstRow and Gtk::TreeRow **************************************/

TreeNodeChildren& TreeRow::children()
{
  g_assert(!is_end_);

  return static_cast<TreeNodeChildren&>(static_cast<TreeIterBase2&>(*this));
}

const TreeNodeConstChildren& TreeConstRow::children() const
{
  g_assert(!is_end_);

  return static_cast<const TreeNodeConstChildren&>(static_cast<const TreeIterBase2&>(*this));
}

TreeIter<TreeRow> TreeRow::parent()
{
  TreeIter<TreeRow> iter(model_);

  if(is_end_)
    iter.gobject_ = gobject_;
  else
    gtk_tree_model_iter_parent(model_->gobj(), iter.gobj(), &gobject_);

  return iter;
}

TreeIter<TreeConstRow> TreeConstRow::parent() const
{
  TreeIter<TreeConstRow> iter(model_);

  if(is_end_)
    iter.gobject_ = gobject_;
  else
    gtk_tree_model_iter_parent(model_->gobj(), iter.gobj(), const_cast<GtkTreeIter*>(&gobject_));

  return iter;
}

TreeIter<TreeRow> TreeRow::get_iter()
{
  return static_cast<TreeIter<TreeRow>&>(static_cast<TreeIterBase2&>(*this));
}

TreeIter<TreeConstRow> TreeConstRow::get_iter() const
{
  return static_cast<const TreeIter<TreeConstRow>&>(static_cast<const TreeIterBase2&>(*this));
}

void TreeRow::set_value_impl(int column, const Glib::ValueBase& value)
{
  model_->set_value_impl(static_cast<TreeIter<TreeRow>&>(static_cast<TreeIterBase2&>(*this)), column, value);
}

void TreeRow::get_value_impl(int column, Glib::ValueBase& value) const
{
  model_->get_value_impl(static_cast<const TreeIter<TreeConstRow>&>(static_cast<const TreeIterBase2&>(*this)), column, value);
}

void TreeConstRow::get_value_impl(int column, Glib::ValueBase& value) const
{
  model_->get_value_impl(static_cast<const TreeIter<TreeConstRow>&>(static_cast<const TreeIterBase2&>(*this)), column, value);
}

TreeConstRow::operator bool() const
{
  // Test whether the GtkTreeIter is valid and not an end iterator. This check
  // is almost the same as the private VALID_ITER() macro in gtkliststore.c and
  // gtktreestore.c.
  return !is_end_ && gobject_.stamp;
}

/**** Gtk::TreeNodeConstChildren and Gtk::TreeNodeChildren ********************/

TreeNodeChildren::iterator TreeNodeChildren::begin()
{
  iterator iter(model_);

  // If the iterator is invalid (stamp == 0), assume a 'virtual' toplevel
  // node.  This behaviour is needed to implement Gtk::TreeModel::children().

  if(gobject_.stamp != 0)
  {
    if(!gtk_tree_model_iter_children(model_->gobj(), iter.gobj(), &gobject_))
    {
      // Assign the already known parent, in order to create an end iterator.
      iter.gobject_ = gobject_;
      iter.is_end_ = true;
    }
  }
  else
  {
    if(!gtk_tree_model_get_iter_first(model_->gobj(), iter.gobj()))
    {
      // No need to copy the GtkTreeIter, since iter.gobject_ is already empty.
      iter.is_end_ = true;
    }
  }

  return iter;
}

TreeNodeConstChildren::const_iterator TreeNodeConstChildren::begin() const
{
  return const_cast<TreeNodeChildren*>(static_cast<const TreeNodeChildren*>(this))->begin();
}

TreeNodeChildren::iterator TreeNodeChildren::end()
{
  // Just copy the parent, and turn it into an end iterator.
  iterator iter(model_);
  iter.gobject_ = gobject_;
  iter.is_end_ = true;
  return iter;
}

TreeNodeConstChildren::const_iterator TreeNodeConstChildren::end() const
{
  return const_cast<TreeNodeChildren*>(static_cast<const TreeNodeChildren*>(this))->end();
}

TreeNodeChildren::value_type TreeNodeChildren::operator[](TreeNodeChildren::size_type index)
{
  iterator iter(model_);

  const auto parent = const_cast<GtkTreeIter*>(get_parent_gobject());

  if (!gtk_tree_model_iter_nth_child(model_->gobj(), iter.gobj(), parent, index))
  {
    // Assign the already known parent, in order to create an end iterator.
    iter.gobject_ = gobject_;
    iter.is_end_ = true;
  }

  return *iter;
}

const TreeNodeConstChildren::value_type TreeNodeConstChildren::operator[](TreeNodeChildren::size_type index) const
{
  const_iterator iter(model_);

  const auto parent = const_cast<GtkTreeIter*>(get_parent_gobject());

  if(!gtk_tree_model_iter_nth_child(model_->gobj(), iter.gobj(), parent, index))
  {
    // Assign the already known parent, in order to create an end iterator.
    iter.gobject_ = gobject_;
    iter.is_end_ = true;
  }

  return *iter;
}

TreeNodeConstChildren::size_type TreeNodeConstChildren::size() const
{
  const auto parent = const_cast<GtkTreeIter*>(get_parent_gobject());

  return gtk_tree_model_iter_n_children(model_->gobj(), parent);
}

bool TreeNodeConstChildren::empty() const
{
  // If the iterator is invalid (stamp == 0), assume a 'virtual' toplevel
  // node.  This behaviour is needed to implement Gtk::TreeModel::children().

  if(gobject_.stamp == 0)
  {
    GtkTreeIter dummy;
    return !gtk_tree_model_get_iter_first(model_->gobj(), &dummy);
  }

  return !gtk_tree_model_iter_has_child(model_->gobj(), const_cast<GtkTreeIter*>(&gobject_));
}

} // namespace Gtk

namespace
{
} // anonymous namespace


namespace Gtk
{


TreeIterBase::TreeIterBase(const TreeIterBase& other) noexcept
:
  gobject_(other.gobject_)
{
}

TreeIterBase& TreeIterBase::operator=(const TreeIterBase& other) noexcept
{
  gobject_ = other.gobject_;
  return *this;
}

TreeIterBase::TreeIterBase(TreeIterBase&& other) noexcept
:
  gobject_(std::move(other.gobject_))
{
  //We could wipe other.gobject_ via memset,
  //but that is not really necessary:
  //other.gobject_ = nullptr;
}

TreeIterBase& TreeIterBase::operator=(TreeIterBase&& other) noexcept
{
  gobject_ = std::move(other.gobject_);
  return *this;
}

// static
GType TreeIterBase::get_type()
{
  return gtk_tree_iter_get_type();
}

TreeIterBase::TreeIterBase()
{
  std::memset(&gobject_, 0, sizeof(GtkTreeIter));
}

TreeIterBase::TreeIterBase(const GtkTreeIter* gobject)
{
  if(gobject)
    gobject_ = *gobject;
  else
    std::memset(&gobject_, 0, sizeof(GtkTreeIter));
}


} // namespace Gtk


