// Generated by gmmproc 2.68.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gdkmm/device.h>
#include <gdkmm/private/device_p.h>


/* Copyright 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gdk/gdk.h>
#include <gdkmm/cursor.h>
#include <gdkmm/devicetool.h>
#include <gdkmm/devicewithpad.h>
#include <gdkmm/display.h>
#include <gdkmm/seat.h>
#include <gdkmm/surface.h>

namespace Gdk
{

Glib::RefPtr<Surface> Device::get_surface_at_position()
{
  auto retvalue = Glib::wrap(gdk_device_get_surface_at_position(gobj(), nullptr, nullptr));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Surface> Device::get_surface_at_position() const
{
  return const_cast<Device*>(this)->get_surface_at_position();
}

// Custom wrap_new() because we want to create a DeviceWithPad, if the underlying
// C class implements the GdkDevicePad interface.
Glib::ObjectBase* Device_Class::wrap_new(GObject* object)
{
  // GdkDevice is an abstract class. C functions that return a GdkDevice* usually
  // (always?) return a pointer to a subclass of GdkDevice. Some subclasses, e.g.
  // GdkWaylandDevicePad, implement the GdkDevicePad interface.
  // Give C++ programmers a chance to access methods in that interface, although
  // gtkmm does not wrap subclasses of GdkDevice.

  if (GDK_IS_DEVICE_PAD(object))
     return new DeviceWithPad((GdkDevice*)object);
  return new Device((GdkDevice*)object);
}

bool Device::has_device_pad() const
{
  return dynamic_cast<const DeviceWithPad*>(this) != nullptr;
}

Glib::RefPtr<DeviceWithPad> Device::device_with_pad_cast()
{
  auto retvalue = Glib::make_refptr_for_instance<DeviceWithPad>(dynamic_cast<DeviceWithPad*>(this));
  if (retvalue)
    retvalue->reference();
  return retvalue;
}

Glib::RefPtr<const DeviceWithPad> Device::device_with_pad_cast() const
{
  return const_cast<Device*>(this)->device_with_pad_cast();
}

} // namespace Gdk

namespace
{


static const Glib::SignalProxyInfo Device_signal_changed_info =
{
  "changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Device_signal_tool_changed_callback(GdkDevice* self, GdkDeviceTool* p0,void* data)
{
  using namespace Gdk;
  using SlotType = sigc::slot<void(const Glib::RefPtr<DeviceTool>&)>;

  auto obj = dynamic_cast<Device*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Device_signal_tool_changed_info =
{
  "tool-changed",
  (GCallback) &Device_signal_tool_changed_callback,
  (GCallback) &Device_signal_tool_changed_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gdk::InputSource>::value_type()
{
  return gdk_input_source_get_type();
}


namespace Glib
{

Glib::RefPtr<Gdk::Device> wrap(GdkDevice* object, bool take_copy)
{
  return Glib::make_refptr_for_instance<Gdk::Device>( dynamic_cast<Gdk::Device*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

const Glib::Class& Device_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Device_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gdk_device_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Device_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


/* The implementation: */

GdkDevice* Device::gobj_copy()
{
  reference();
  return gobj();
}

Device::Device(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Device::Device(GdkDevice* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Device::Device(Device&& src) noexcept
: Glib::Object(std::move(src))
{}

Device& Device::operator=(Device&& src) noexcept
{
  Glib::Object::operator=(std::move(src));
  return *this;
}


Device::~Device() noexcept
{}


Device::CppClassType Device::device_class_; // initialize static member

GType Device::get_type()
{
  return device_class_.init().get_type();
}


GType Device::get_base_type()
{
  return gdk_device_get_type();
}


Device::Device()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(device_class_.init()))
{
  

}

Glib::ustring Device::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gdk_device_get_name(const_cast<GdkDevice*>(gobj())));
}

bool Device::get_has_cursor() const
{
  return gdk_device_get_has_cursor(const_cast<GdkDevice*>(gobj()));
}

InputSource Device::get_source() const
{
  return static_cast<InputSource>(gdk_device_get_source(const_cast<GdkDevice*>(gobj())));
}

Glib::RefPtr<Display> Device::get_display()
{
  auto retvalue = Glib::wrap(gdk_device_get_display(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Display> Device::get_display() const
{
  return const_cast<Device*>(this)->get_display();
}

Glib::RefPtr<Surface> Device::get_surface_at_position(double& win_x, double& win_y)
{
  auto retvalue = Glib::wrap(gdk_device_get_surface_at_position(gobj(), &(win_x), &(win_y)));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Surface> Device::get_surface_at_position(double& win_x, double& win_y) const
{
  return const_cast<Device*>(this)->get_surface_at_position(win_x, win_y);
}

Glib::ustring Device::get_vendor_id() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gdk_device_get_vendor_id(const_cast<GdkDevice*>(gobj())));
}

Glib::ustring Device::get_product_id()
{
  return Glib::convert_const_gchar_ptr_to_ustring(gdk_device_get_product_id(gobj()));
}

Glib::RefPtr<Seat> Device::get_seat()
{
  auto retvalue = Glib::wrap(gdk_device_get_seat(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Seat> Device::get_seat() const
{
  return const_cast<Device*>(this)->get_seat();
}

guint Device::get_num_touches() const
{
  return gdk_device_get_num_touches(const_cast<GdkDevice*>(gobj()));
}

Glib::RefPtr<DeviceTool> Device::get_device_tool()
{
  auto retvalue = Glib::wrap(gdk_device_get_device_tool(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const DeviceTool> Device::get_device_tool() const
{
  return const_cast<Device*>(this)->get_device_tool();
}

bool Device::get_caps_lock_state() const
{
  return gdk_device_get_caps_lock_state(const_cast<GdkDevice*>(gobj()));
}

bool Device::get_num_lock_state() const
{
  return gdk_device_get_num_lock_state(const_cast<GdkDevice*>(gobj()));
}

bool Device::get_scroll_lock_state() const
{
  return gdk_device_get_scroll_lock_state(const_cast<GdkDevice*>(gobj()));
}

ModifierType Device::get_modifier_state() const
{
  return static_cast<ModifierType>(gdk_device_get_modifier_state(const_cast<GdkDevice*>(gobj())));
}

Pango::Direction Device::get_direction() const
{
  return static_cast<Pango::Direction>(gdk_device_get_direction(const_cast<GdkDevice*>(gobj())));
}

bool Device::has_bidi_layouts() const
{
  return gdk_device_has_bidi_layouts(const_cast<GdkDevice*>(gobj()));
}

guint32 Device::get_timestamp() const
{
  return gdk_device_get_timestamp(const_cast<GdkDevice*>(gobj()));
}


Glib::SignalProxy<void()> Device::signal_changed()
{
  return Glib::SignalProxy<void() >(this, &Device_signal_changed_info);
}


Glib::SignalProxy<void(const Glib::RefPtr<DeviceTool>&)> Device::signal_tool_changed()
{
  return Glib::SignalProxy<void(const Glib::RefPtr<DeviceTool>&) >(this, &Device_signal_tool_changed_info);
}


static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Display>>::value,
  "Type Glib::RefPtr<Display> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Display> > Device::property_display() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Display> >(this, "display");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Device::property_name() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "name");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<InputSource>::value,
  "Type InputSource cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< InputSource > Device::property_source() const
{
  return Glib::PropertyProxy_ReadOnly< InputSource >(this, "source");
}

Glib::PropertyProxy_ReadOnly< bool > Device::property_has_cursor() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "has-cursor");
}

Glib::PropertyProxy_ReadOnly< guint > Device::property_n_axes() const
{
  return Glib::PropertyProxy_ReadOnly< guint >(this, "n-axes");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Device::property_vendor_id() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "vendor-id");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Device::property_product_id() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "product-id");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Seat>>::value,
  "Type Glib::RefPtr<Seat> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<Seat> > Device::property_seat() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Seat> >(this, "seat");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Seat> > Device::property_seat() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Seat> >(this, "seat");
}

Glib::PropertyProxy_ReadOnly< guint > Device::property_num_touches() const
{
  return Glib::PropertyProxy_ReadOnly< guint >(this, "num-touches");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<DeviceTool>>::value,
  "Type Glib::RefPtr<DeviceTool> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DeviceTool> > Device::property_tool() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<DeviceTool> >(this, "tool");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Pango::Direction>::value,
  "Type Pango::Direction cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Pango::Direction > Device::property_direction() const
{
  return Glib::PropertyProxy_ReadOnly< Pango::Direction >(this, "direction");
}

Glib::PropertyProxy_ReadOnly< bool > Device::property_has_bidi_layouts() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "has-bidi-layouts");
}

Glib::PropertyProxy_ReadOnly< bool > Device::property_caps_lock_state() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "caps-lock-state");
}

Glib::PropertyProxy_ReadOnly< bool > Device::property_num_lock_state() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "num-lock-state");
}

Glib::PropertyProxy_ReadOnly< bool > Device::property_scroll_lock_state() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "scroll-lock-state");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<ModifierType>::value,
  "Type ModifierType cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< ModifierType > Device::property_modifier_state() const
{
  return Glib::PropertyProxy_ReadOnly< ModifierType >(this, "modifier-state");
}


} // namespace Gdk


