// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_LAYOUT_H
#define _GTKMM_LAYOUT_H

#include <glibmm.h>

/* $Id: layout.hg,v 1.2 2004/01/05 17:32:16 murrayc Exp $ */

/* layout.h
 * 
 * Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/container.h>
#include <gtkmm/adjustment.h>
#include <gdkmm/window.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkLayout GtkLayout;
typedef struct _GtkLayoutClass GtkLayoutClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Layout_Class; } // namespace Gtk
namespace Gtk
{

/** Infinite scrollable area containing child widgets and/or custom drawing.
 *
 * Gtk::Layout is similar to Gtk::DrawingArea in that it's a "blank slate"
 * and doesn't do anything but paint a blank background by default. It's
 * different in that it supports scrolling natively (You can add it directly
 * to a Gtk::ScrolledWindow), and it can contain child widgets, since it's a
 * Gtk::Container.  However if you're just going to draw, a Gtk::DrawingArea
 * is a better choice since it has lower overhead.
 *
 * When handling expose_event signals, you must draw to the bin_window
 * Gdk::Window - see get_bin_window() - rather than the normal Gdk::Window -
 * see get_window() - as you would for a drawing area.
 *
 * @ingroup Widgets
 * @ingroup Containers
 */

class Layout : public Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Layout CppObjectType;
  typedef Layout_Class CppClassType;
  typedef GtkLayout BaseObjectType;
  typedef GtkLayoutClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Layout();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Layout_Class;
  static CppClassType layout_class_;

  // noncopyable
  Layout(const Layout&);
  Layout& operator=(const Layout&);

protected:
  explicit Layout(const Glib::ConstructParams& construct_params);
  explicit Layout(GtkLayout* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkLayout*       gobj()       { return reinterpret_cast<GtkLayout*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkLayout* gobj() const { return reinterpret_cast<GtkLayout*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_set_scroll_adjustments(Adjustment* hadj, Adjustment* vadj);


private:

  
public:
  Layout();
  Layout(Adjustment& hadjustment, Adjustment& vadjustment);

  
  /** Adds @a child_widget  to @a layout , at position ( @a x , @a y ).
   *  @a layout  becomes the new parent container of @a child_widget .
   * @param child_widget Child widget.
   * @param x X position of child widget.
   * @param y Y position of child widget.
   */
  void put(Widget& widget, int x, int y);
  
  /** Moves a current child of @a layout  to a new position.
   * @param child_widget A current child of @a layout .
   * @param x X position to move to.
   * @param y Y position to move to.
   */
  void move(Widget& widget, int x, int y);
  
  /** Sets the size of the scrollable area of the layout.
   * @param width Width of entire scrollable area.
   * @param height Height of entire scrollable area.
   */
  void set_size(guint width, guint height);
  
  /** Gets the size that has been set on the layout, and that determines
   * the total extents of the layout's scrollbar area. See
   * set_size().
   * @param width Location to store the width set on @a layout , or <tt>0</tt>.
   * @param height Location to store the height set on @a layout , or <tt>0</tt>.
   */
  void get_size(guint& width, guint& height) const;

  
  /** Sets the horizontal scroll adjustment for the layout.
   * 
   * See Gtk::ScrolledWindow, Gtk::Scrollbar, Gtk::Adjustment for details.
   * @param adjustment New scroll adjustment.
   */
  void set_hadjustment(Adjustment& adjustment);

  /// Creates the Adjustment.
  void set_hadjustment();
  
  /** This function should only be called after the layout has been
   * placed in a Gtk::ScrolledWindow or otherwise configured for
   * scrolling. It returns the Gtk::Adjustment used for communication
   * between the horizontal scrollbar and @a layout .
   * 
   * See Gtk::ScrolledWindow, Gtk::Scrollbar, Gtk::Adjustment for details.
   * @return Horizontal scroll adjustment.
   */
  Adjustment* get_hadjustment();
  
  /** This function should only be called after the layout has been
   * placed in a Gtk::ScrolledWindow or otherwise configured for
   * scrolling. It returns the Gtk::Adjustment used for communication
   * between the horizontal scrollbar and @a layout .
   * 
   * See Gtk::ScrolledWindow, Gtk::Scrollbar, Gtk::Adjustment for details.
   * @return Horizontal scroll adjustment.
   */
  const Adjustment* get_hadjustment() const;
  
  /** Sets the vertical scroll adjustment for the layout.
   * 
   * See Gtk::ScrolledWindow, Gtk::Scrollbar, Gtk::Adjustment for details.
   * @param adjustment New scroll adjustment.
   */
  void set_vadjustment(Adjustment& adjustment);

  /// Creates the Adjustment.
  void set_vadjustment();
  
  /** This function should only be called after the layout has been
   * placed in a Gtk::ScrolledWindow or otherwise configured for
   * scrolling. It returns the Gtk::Adjustment used for communication
   * between the vertical scrollbar and @a layout .
   * 
   * See Gtk::ScrolledWindow, Gtk::Scrollbar, Gtk::Adjustment for details.
   * @return Vertical scroll adjustment.
   */
  Adjustment* get_vadjustment();
  
  /** This function should only be called after the layout has been
   * placed in a Gtk::ScrolledWindow or otherwise configured for
   * scrolling. It returns the Gtk::Adjustment used for communication
   * between the vertical scrollbar and @a layout .
   * 
   * See Gtk::ScrolledWindow, Gtk::Scrollbar, Gtk::Adjustment for details.
   * @return Vertical scroll adjustment.
   */
  const Adjustment* get_vadjustment() const;

  Glib::RefPtr<Gdk::Window> get_bin_window();
  Glib::RefPtr<const Gdk::Window> get_bin_window() const;

  // See Gtk::Widget::set_scroll_adjustments()
  

  Glib::SignalProxy2< void,Adjustment*,Adjustment* > signal_set_scroll_adjustments();


    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Adjustment*> property_hadjustment() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Adjustment*> property_hadjustment() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Adjustment*> property_vadjustment() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Adjustment*> property_vadjustment() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_width() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_width() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_height() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_height() const;


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Layout
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gtk::Layout* wrap(GtkLayout* object, bool take_copy = false);
}
#endif /* _GTKMM_LAYOUT_H */

