// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TEXTBUFFER_H
#define _GTKMM_TEXTBUFFER_H

#include <glibmm.h>

/* $Id: textbuffer.hg,v 1.5 2003/10/12 09:38:11 murrayc Exp $ */

/* Copyright(C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gtkmm/object.h>
#include <gtkmm/texttagtable.h>
#include <gtkmm/textchildanchor.h>
#include <gtkmm/textmark.h>
#include <gtkmm/textiter.h>
#include <gtkmm/clipboard.h>
#include <gdkmm/pixbuf.h>
#include <gtkmmconfig.h>
#include <utility>

GLIBMM_USING_STD(pair)


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTextBuffer GtkTextBuffer;
typedef struct _GtkTextBufferClass GtkTextBufferClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TextBuffer_Class; } // namespace Gtk
namespace Gtk
{

class TextMark;
class TextIter;

/** Multi-line text that can be displayed by one or more Gtk::TextView widgets.
 * @ingroup TextView
 */

class TextBuffer : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef TextBuffer CppObjectType;
  typedef TextBuffer_Class CppClassType;
  typedef GtkTextBuffer BaseObjectType;
  typedef GtkTextBufferClass BaseClassType;

private:
  friend class TextBuffer_Class;
  static CppClassType textbuffer_class_;

  // noncopyable
  TextBuffer(const TextBuffer&);
  TextBuffer& operator=(const TextBuffer&);

protected:
  explicit TextBuffer(const Glib::ConstructParams& construct_params);
  explicit TextBuffer(GtkTextBuffer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~TextBuffer();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkTextBuffer*       gobj()       { return reinterpret_cast<GtkTextBuffer*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkTextBuffer* gobj() const { return reinterpret_cast<GtkTextBuffer*>(gobject_); }

  GtkTextBuffer* gobj_copy();

private:

   
public:
  typedef TextIter iterator;
  typedef TextTag Tag;
  typedef TextTagTable TagTable;
  typedef TextMark Mark;

protected:
  TextBuffer();
  explicit TextBuffer(const Glib::RefPtr<TagTable>& tag_table);

public:
  
  static Glib::RefPtr<TextBuffer> create();

  
  static Glib::RefPtr<TextBuffer> create(const Glib::RefPtr<TagTable>& tag_table);


  int get_line_count() const;
  
  int get_char_count() const;
  int size() const;

  
  Glib::RefPtr<TextBuffer::TagTable> get_tag_table();
  
  Glib::RefPtr<const TextBuffer::TagTable> get_tag_table() const;

  void set_text(const Glib::ustring& text);
  void set_text(const char* text_begin, const char* text_end);

  /** Alias for set_text(). */
  void assign(const Glib::ustring& text);
  /** Alias for set_text(). */
  void assign(const char* text_begin, const char* text_end);

  iterator insert(const iterator& pos, const Glib::ustring& text);
  iterator insert(const iterator& pos, const char* text_begin, const char* text_end);

  void insert_at_cursor(const Glib::ustring& text);
  void insert_at_cursor(const char* text_begin, const char* text_end);

  std::pair<iterator,bool> insert_interactive(
      const iterator& pos, const Glib::ustring& text, bool default_editable = true);

  std::pair<iterator,bool> insert_interactive(
      const iterator& pos, const char* text_begin, const char* text_end, bool default_editable = true);

  bool insert_interactive_at_cursor(const Glib::ustring& text, bool default_editable = true);
  bool insert_interactive_at_cursor(const char* text_begin, const char* text_end,
                                    bool default_editable = true);

  iterator insert(const iterator& pos, const iterator& range_begin, const iterator& range_end);
  

  std::pair<iterator,bool> insert_interactive(const iterator& pos, const iterator& range_begin, const iterator& range_end, bool default_editable = true);
  

  iterator insert_with_tag(const iterator& pos, const Glib::ustring& text, const Glib::RefPtr<Tag>& tag);
  iterator insert_with_tag(const iterator& pos, const char* text_begin, const char* text_end, const Glib::RefPtr<Tag>& tag);

  iterator insert_with_tag(const iterator& pos, const Glib::ustring& text, const Glib::ustring& tag_name);
  iterator insert_with_tag(const iterator& pos, const char* text_begin, const char* text_end, const Glib::ustring& tag_name);

  iterator insert_with_tags(const iterator& pos, const Glib::ustring& text,
                            const Glib::ArrayHandle< Glib::RefPtr<Tag> >& tags);
  iterator insert_with_tags(const iterator& pos, const char* text_begin, const char* text_end,
                            const Glib::ArrayHandle< Glib::RefPtr<Tag> >& tags);

  iterator insert_with_tags_by_name(const iterator& pos, const Glib::ustring& text,
                                    const Glib::StringArrayHandle& tag_names);
  iterator insert_with_tags_by_name(const iterator& pos, const char* text_begin, const char* text_end,
                                    const Glib::StringArrayHandle& tag_names);

  ///Returns the iterator where the deletion occured.
  iterator erase(const iterator& range_begin, const iterator& range_end);
  

  ///Returns the iterator where the deletion occured or end() if no text was deleted.
  std::pair<iterator,bool> erase_interactive(const iterator& range_begin, const iterator& range_end, bool default_editable = true);
  

  Glib::ustring get_text(const iterator& range_begin, const iterator& range_end, bool include_hidden_chars = true);
  Glib::ustring get_text(bool include_hidden_chars = true);

  
  Glib::ustring get_slice(const iterator& range_begin, const iterator& range_end, bool include_hidden_chars = true);

  iterator insert_pixbuf(const iterator& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  

  iterator insert_child_anchor(const iterator& pos, const Glib::RefPtr<TextChildAnchor>& anchor);
  

  Glib::RefPtr<TextChildAnchor> create_child_anchor(const iterator& pos);
  

  Glib::RefPtr<TextBuffer::Mark> create_mark(const Glib::ustring& mark_name, const iterator& where, bool left_gravity = true);

  /** Create an anonymous mark. */
  Glib::RefPtr<Mark> create_mark(const iterator& where, bool left_gravity = true);

  
  void move_mark(const Glib::RefPtr<Mark>& mark, const iterator& where);
  
  void delete_mark(const Glib::RefPtr<Mark>& mark);
  
  Glib::RefPtr<TextBuffer::Mark> get_mark(const Glib::ustring& name);
  
  Glib::RefPtr<const TextBuffer::Mark> get_mark(const Glib::ustring& name) const;

  
  void move_mark_by_name(const Glib::ustring& name, const iterator& where);
  
  void delete_mark_by_name(const Glib::ustring& name);

  
  Glib::RefPtr<TextBuffer::Mark> get_insert();
  
  Glib::RefPtr<TextBuffer::Mark> get_selection_bound();

  
  void place_cursor(const iterator& where);
  
  void apply_tag(const Glib::RefPtr<Tag>& tag, const iterator& range_begin, const iterator& range_end);
  
  void remove_tag(const Glib::RefPtr<Tag>& tag, const iterator& range_begin, const iterator& range_end);
  
  void apply_tag_by_name(const Glib::ustring& name, const iterator& range_begin, const iterator& range_end);
  
  void remove_tag_by_name(const Glib::ustring& name, const iterator& range_begin, const iterator& range_end);
  
  void remove_all_tags(const iterator& range_begin, const iterator& range_end);

  Glib::RefPtr<Tag> create_tag(const Glib::ustring& tag_name);

  iterator get_iter_at_line_offset(int line_number, int char_offset);
  iterator get_iter_at_line_index(int line_number, int byte_index);
  iterator get_iter_at_offset(int char_offset);
  iterator get_iter_at_line(int line_number);
  iterator begin();
  iterator end();
  void get_bounds(iterator& range_begin, iterator& range_end);

  iterator get_iter_at_mark(const Glib::RefPtr<Mark>& mark);
  iterator get_iter_at_child_anchor(const Glib::RefPtr<TextChildAnchor>& anchor);

  
  bool get_modified() const;
  
  void set_modified(bool setting = true);

  
  void add_selection_clipboard(const Glib::RefPtr<Clipboard>& clipboard);
  
  void remove_selection_clipboard(const Glib::RefPtr<Clipboard>& clipboard);
  
  void cut_clipboard(const Glib::RefPtr<Clipboard>& clipboard, bool default_editable = true);
  
  void copy_clipboard(const Glib::RefPtr<Clipboard>& clipboard);
  void paste_clipboard(const Glib::RefPtr<Clipboard>& clipboard, const iterator& override_location, bool default_editable = true);
  void paste_clipboard(const Glib::RefPtr<Clipboard>& clipboard, bool default_editable = true);
  

  bool get_selection_bounds(iterator& range_begin, iterator& range_end) const;
  
  bool erase_selection(bool interactive = true, bool default_editable = true);

  
  void select_range(const iterator& ins, const iterator& bound);
  
/* Called to specify atomic user actions, used to implement undo */
  
  void begin_user_action();
  
  void end_user_action();


  /**
   * @par Prototype:
   * <tt>void %insert(const TextBuffer::iterator& pos, const Glib::ustring& text, int bytes)</tt>
   */
  Glib::SignalProxy3<void,const TextBuffer::iterator&,const Glib::ustring&,int> signal_insert();

  
  /**
   * @par Prototype:
   * <tt>void %insert_pixbuf(const TextBuffer::iterator& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)</tt>
   */
  Glib::SignalProxy2<void,const TextBuffer::iterator&,const Glib::RefPtr<Gdk::Pixbuf>&> signal_insert_pixbuf();

  
  /**
   * @par Prototype:
   * <tt>void %insert_child_anchor(const TextBuffer::iterator& pos, const Glib::RefPtr<TextChildAnchor>& anchor)</tt>
   */
  Glib::SignalProxy2<void,const TextBuffer::iterator&,const Glib::RefPtr<TextChildAnchor>&> signal_insert_child_anchor();

  
  /**
   * @par Prototype:
   * <tt>void %erase(const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end)</tt>
   */
  Glib::SignalProxy2<void,const TextBuffer::iterator&,const TextBuffer::iterator&> signal_erase();

  
  /**
   * @par Prototype:
   * <tt>void %changed()</tt>
   */
  Glib::SignalProxy0<void> signal_changed();

  
  /**
   * @par Prototype:
   * <tt>void %modified_changed()</tt>
   */
  Glib::SignalProxy0<void> signal_modified_changed();

  
  /**
   * @par Prototype:
   * <tt>void %mark_set(const TextBuffer::iterator& location, const Glib::RefPtr<TextBuffer::Mark>& mark)</tt>
   */
  Glib::SignalProxy2<void,const TextBuffer::iterator&,const Glib::RefPtr<TextBuffer::Mark>&> signal_mark_set();

  
  /**
   * @par Prototype:
   * <tt>void %mark_deleted(const Glib::RefPtr<TextBuffer::Mark>& mark)</tt>
   */
  Glib::SignalProxy1<void,const Glib::RefPtr<TextBuffer::Mark>&> signal_mark_deleted();

  
  /**
   * @par Prototype:
   * <tt>void %apply_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end)</tt>
   */
  Glib::SignalProxy3<void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator&> signal_apply_tag();

  
  /**
   * @par Prototype:
   * <tt>void %remove_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end)</tt>
   */
  Glib::SignalProxy3<void,const Glib::RefPtr<TextBuffer::Tag>&,const TextBuffer::iterator&,const TextBuffer::iterator&> signal_remove_tag();

  
  /**
   * @par Prototype:
   * <tt>void %begin_user_action()</tt>
   */
  Glib::SignalProxy0<void> signal_begin_user_action();

  
  /**
   * @par Prototype:
   * <tt>void %end_user_action()</tt>
   */
  Glib::SignalProxy0<void> signal_end_user_action();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_insert(const TextBuffer::iterator& pos, const Glib::ustring& text, int bytes);
  virtual void on_insert_pixbuf(const TextBuffer::iterator& pos, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  virtual void on_insert_child_anchor(const TextBuffer::iterator& pos, const Glib::RefPtr<TextChildAnchor>& anchor);
  virtual void on_erase(const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end);
  virtual void on_changed();
  virtual void on_modified_changed();
  virtual void on_mark_set(const TextBuffer::iterator& location, const Glib::RefPtr<TextBuffer::Mark>& mark);
  virtual void on_mark_deleted(const Glib::RefPtr<TextBuffer::Mark>& mark);
  virtual void on_apply_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end);
  virtual void on_remove_tag(const Glib::RefPtr<TextBuffer::Tag>& tag, const TextBuffer::iterator& range_begin, const TextBuffer::iterator& range_end);
  virtual void on_begin_user_action();
  virtual void on_end_user_action();


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::TextBuffer */
  Glib::RefPtr<Gtk::TextBuffer> wrap(GtkTextBuffer* object, bool take_copy = false);
}


#endif /* _GTKMM_TEXTBUFFER_H */

