// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_PROGRESSBAR_H
#define _GTKMM_PROGRESSBAR_H

#include <glibmm.h>

/* $Id: progressbar.hg,v 1.1.1.1 2003/01/21 13:40:34 murrayc Exp $ */

/* progressbar.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkProgressBar GtkProgressBar;
typedef struct _GtkProgressBarClass GtkProgressBarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class ProgressBar_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum ProgressBarStyle
{
  PROGRESS_CONTINUOUS,
  PROGRESS_DISCRETE
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ProgressBarStyle> : public Glib::Value_Enum<Gtk::ProgressBarStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum ProgressBarOrientation
{
  PROGRESS_LEFT_TO_RIGHT,
  PROGRESS_RIGHT_TO_LEFT,
  PROGRESS_BOTTOM_TO_TOP,
  PROGRESS_TOP_TO_BOTTOM
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ProgressBarOrientation> : public Glib::Value_Enum<Gtk::ProgressBarOrientation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** A widget which indicates progress visually.
 *
 * The Gtk::ProgressBar is typically used to display the progress of a long
 * running operation. It provides a visual clue that processing is underway.
 * The Gtk::ProgressBar can be used in two different modes: percentage mode
 * and activity mode.
 *
 * When an application can determine how much work needs to take place (e.g.
 * read a fixed number of bytes from a file) and can monitor its progress,
 * it can use the Gtk::ProgressBar in percentage mode and the user sees a
 * growing bar indicating the percentage of the work that has been
 * completed. In this mode, the application is required to call
 * set_fraction() periodically to update the progress bar.
 *
 * When an application has no accurate way of knowing the amount of work to
 * do, it can use the Gtk::ProgressBar in activity mode, which shows
 * activity by a block moving back and forth within the progress area. In
 * this mode, the application is required to call pulse() perodically to
 * update the progress bar.
 *
 * There is quite a bit of flexibility provided to control the appearance of
 * the Gtk::ProgressBar. Functions are provided to control the orientation of
 * the bar, optional text can be displayed along with the bar, and the step
 * size used in activity mode can be set. 
 *
 * @ingroup Widgets
 */

class ProgressBar : public Widget
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ProgressBar CppObjectType;
  typedef ProgressBar_Class CppClassType;
  typedef GtkProgressBar BaseObjectType;
  typedef GtkProgressBarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~ProgressBar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class ProgressBar_Class;
  static CppClassType progressbar_class_;

  // noncopyable
  ProgressBar(const ProgressBar&);
  ProgressBar& operator=(const ProgressBar&);

protected:
  explicit ProgressBar(const Glib::ConstructParams& construct_params);
  explicit ProgressBar(GtkProgressBar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkProgressBar*       gobj()       { return reinterpret_cast<GtkProgressBar*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkProgressBar* gobj() const { return reinterpret_cast<GtkProgressBar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

  
public:
  ProgressBar();

  
  void pulse();

  
  Glib::ustring get_text() const;
  
  void set_text(const Glib::ustring& text);

  
  double get_fraction() const;
  
  void set_fraction(double fraction);

  
  double get_pulse_step() const;
  
  void set_pulse_step(double fraction);

  
  void set_orientation(ProgressBarOrientation orientation = PROGRESS_LEFT_TO_RIGHT);
  
  ProgressBarOrientation get_orientation() const;

  Glib::PropertyProxy<double> property_fraction();

  Glib::PropertyProxy<double> property_pulse_step();

  Glib::PropertyProxy<ProgressBarOrientation> property_orientation();

  Glib::PropertyProxy<Glib::ustring> property_text();


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::ProgressBar */
  Gtk::ProgressBar* wrap(GtkProgressBar* object, bool take_copy = false);
}
#endif /* _GTKMM_PROGRESSBAR_H */

