// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_IMAGE_H
#define _GTKMM_IMAGE_H

#include <glibmm.h>

/* $Id: image.hg,v 1.2 2003/05/07 16:25:38 murrayc Exp $ */

/* image.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/misc.h>
#include <gtkmm/iconset.h>
#include <gdkmm/pixbufanimation.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkImage GtkImage;
typedef struct _GtkImageClass GtkImageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Image_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum ImageType
{
  IMAGE_EMPTY,
  IMAGE_PIXMAP,
  IMAGE_IMAGE,
  IMAGE_PIXBUF,
  IMAGE_STOCK,
  IMAGE_ICON_SET,
  IMAGE_ANIMATION
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ImageType> : public Glib::Value_Enum<Gtk::ImageType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** A widget displaying an image.
 *
 * The Gtk::Image widget displays an image. Various kinds of object can be
 * displayed as an image; most typically, you would load a Gdk::Pixbuf ("pixel
 * buffer") from a file, and then display that. 
 *
 * Gtk::Image is a subclass of Gtk::Misc, which implies that you can align it
 * (center, left, right) and add padding to it, using Gtk::Misc methods.
 *
 * Gtk::Image is a "no window" widget (has no Gdk::Window of its own), so by
 * default does not receive events. If you want to receive events on the
 * image, such as button clicks, place the image inside a Gtk::EventBox, then
 * connect to the event signals on the event box. 
 *
 * @ingroup Widgets
 */

class Image : public Misc
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Image CppObjectType;
  typedef Image_Class CppClassType;
  typedef GtkImage BaseObjectType;
  typedef GtkImageClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Image();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Image_Class;
  static CppClassType image_class_;

  // noncopyable
  Image(const Image&);
  Image& operator=(const Image&);

protected:
  explicit Image(const Glib::ConstructParams& construct_params);
  explicit Image(GtkImage* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkImage*       gobj()       { return reinterpret_cast<GtkImage*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkImage* gobj() const { return reinterpret_cast<GtkImage*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

  
public:

  Image();
  explicit Image(const Glib::RefPtr<Gdk::Pixmap>& pixmap, const Glib::RefPtr<Gdk::Bitmap>& mask);
  explicit Image(const Glib::RefPtr<Gdk::Image>& image, const Glib::RefPtr<Gdk::Bitmap>& mask);
  explicit Image(const std::string& file);
  explicit Image(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  Image(const Gtk::StockID& stock_id, IconSize size);
  Image(IconSet& icon_set, IconSize size);
  Image(const Glib::RefPtr<Gdk::PixbufAnimation>& animation);
  

  void set(const Glib::RefPtr<Gdk::Pixmap>& pixmap, const Glib::RefPtr<Gdk::Bitmap>& mask);
  
  void set(const Glib::RefPtr<Gdk::Image>& image, const Glib::RefPtr<Gdk::Bitmap>& mask);
  
  void set(const std::string& filename);
  
  void set(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
  
  void set(const Gtk::StockID& stock_id, IconSize size);
  
  void set(IconSet& icon_set, IconSize size);
  
  void set(const Glib::RefPtr<Gdk::PixbufAnimation>& animation);

  void clear();

  
  ImageType get_storage_type() const;

  void get_pixmap(Glib::RefPtr<Gdk::Pixmap>& pixmap, Glib::RefPtr<Gdk::Bitmap>& mask) const;
  void get_image(Glib::RefPtr<Gdk::Image>& gdk_image, Glib::RefPtr<Gdk::Bitmap>& mask) const;
  
  Glib::RefPtr<Gdk::Pixbuf> get_pixbuf() const;
  void get_stock(Gtk::StockID& stock_id, IconSize& size) const;
  void get_icon_set(IconSet& icon_set, IconSize& size) const;
  
  Glib::RefPtr<Gdk::PixbufAnimation> get_animation();

  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > property_pixbuf();

  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixmap> > property_pixmap();

  Glib::PropertyProxy< Glib::RefPtr<Gdk::Image> > property_image();

  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixmap> > property_mask();

  Glib::PropertyProxy_WriteOnly<Glib::ustring> property_file();

  Glib::PropertyProxy<Glib::ustring> property_stock();

  Glib::PropertyProxy<Gtk::IconSet> property_icon_set();

  Glib::PropertyProxy<int> property_icon_size();

  Glib::PropertyProxy< Glib::RefPtr<Gdk::PixbufAnimation> > property_pixbuf_animation();

  Glib::PropertyProxy_ReadOnly<ImageType> property_storage_type();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::Image */
  Gtk::Image* wrap(GtkImage* object, bool take_copy = false);
}
#endif /* _GTKMM_IMAGE_H */

